package me.zalo.startuphelper;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build.VERSION;

public class StartupHelperReceiver extends BroadcastReceiver {
    public static final boolean DEBUG = false;
    private static final String TAG = "StartupHelperReceiver";

    public void onReceive(final Context context, Intent intent) {
        if (intent.getAction() != null && VERSION.SDK_INT >= 19 && "android.intent.action.PACKAGE_ADDED".equals(intent.getAction())) {
            final int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            if (uid != 0) {
                TaskExecutor.queueRunnable(new Runnable() {
                    public void run() {
                        StartupHelperUtil.startHelperProvider(context, uid);
                    }
                });
            }
        }
    }
}
