package me.zalo.startuphelper;

import android.content.Context;
import android.os.Build.VERSION;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;

class Installation {
    private static final String INSTALLATION = "ZALO-STARTUP-HELPER-INSTALLATION";
    private static String sID = null;

    Installation() {
    }

    public static synchronized boolean isFirstCall(Context context) {
        boolean firstLaunch;
        synchronized (Installation.class) {
            firstLaunch = false;
            if (sID == null) {
                File installation = new File(VERSION.SDK_INT >= 21 ? context.getNoBackupFilesDir() : context.getFilesDir(), INSTALLATION);
                try {
                    if (!installation.exists()) {
                        writeInstallationFile(installation);
                        firstLaunch = true;
                    }
                    try {
                        sID = readInstallationFile(installation);
                    } catch (IOException e) {
                        e.printStackTrace();
                        if (installation.delete()) {
                            writeInstallationFile(installation);
                            sID = readInstallationFile(installation);
                            firstLaunch = true;
                        }
                    }
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        return firstLaunch;
    }

    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[((int) f.length())];
        f.readFully(bytes);
        f.close();
        return new String(bytes, "utf-8");
    }

    private static void writeInstallationFile(File installation) throws IOException {
        FileOutputStream out = new FileOutputStream(installation);
        out.write(UUID.randomUUID().toString().getBytes("utf-8"));
        out.close();
    }
}
