package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog.Builder;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.oauth.WebDialog.FeedDialogBuilder;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Map.Entry;
import org.json.JSONObject;

public class OpenAPIService {
    private static OpenAPIService l;
    public boolean _autoBack;
    public String _shareTo;
    protected WeakReference<ZaloPluginCallback> a;
    protected WeakReference<Context> b;
    protected FeedData c;
    private OauthStorage d;
    /* access modifiers changed from: private */
    public boolean e;
    /* access modifiers changed from: private */
    public String f;
    private BroadcastReceiver g;
    private boolean h;
    /* access modifiers changed from: private */
    public WeakReference<ZaloPluginCallback> i;
    private ShareVia j;
    private boolean k;

    private class NewUserTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        ZaloOpenAPICallback b;

        NewUserTask(Context ctx, ZaloOpenAPICallback _mOpenAPICallackNewAPI) {
            this.a = ctx;
            this.b = _mOpenAPICallackNewAPI;
        }

        /* access modifiers changed from: protected */
        public void onPreExecute() {
            super.onPreExecute();
        }

        /* access modifiers changed from: protected */
        /* renamed from: a */
        public JSONObject doInBackground(HttpClientRequest... requests) {
            HttpClientRequest request = requests[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                } catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            } else {
                JSONObject accessToken = OpenAPIService.this.a(this.a);
                if (accessToken == null) {
                    try {
                        return new JSONObject("{\"error\":-1008}");
                    } catch (Exception e2) {
                        e2.printStackTrace();
                        return null;
                    }
                } else {
                    try {
                        if (!accessToken.has("access_token")) {
                            return accessToken;
                        }
                        request.addParams("access_token", accessToken.optString("access_token"));
                        return request.getJSON();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            }
        }

        /* access modifiers changed from: protected */
        /* renamed from: a */
        public void onPostExecute(JSONObject object) {
            if (object != null) {
                try {
                    this.b.onResult(object);
                } catch (Exception ex) {
                    ex.printStackTrace();
                    this.b.onResult(null);
                }
            } else {
                this.b.onResult(new JSONObject("{\"error\":-1112}"));
            }
        }
    }

    public OpenAPIService() {
        this.d = null;
        this.e = false;
        this._shareTo = "";
        this._autoBack = false;
        this.f = "";
        this.h = false;
        this.j = ShareVia.AppThenWeb;
        this.k = false;
        this.d = ZaloSDK.Instance.getOauthStorage();
    }

    @Deprecated
    public static OpenAPIService getInstance() {
        if (l == null) {
            l = new OpenAPIService();
        }
        return l;
    }

    /* access modifiers changed from: private */
    /* JADX WARNING: Removed duplicated region for block: B:10:0x001d A[SYNTHETIC, Splitter:B:10:0x001d] */
    /* JADX WARNING: Removed duplicated region for block: B:26:? A[RETURN, SYNTHETIC] */
    /* Code decompiled incorrectly, please refer to instructions dump. */
    public org.json.JSONObject a(android.content.Context r13) {
        /*
            r12 = this;
            r0 = 0
            org.json.JSONObject r1 = new org.json.JSONObject     // Catch:{ Exception -> 0x00dc }
            com.zing.zalo.zalosdk.oauth.OauthStorage r5 = r12.d     // Catch:{ Exception -> 0x00dc }
            java.lang.String r5 = r5.getAccessTokenNewAPI()     // Catch:{ Exception -> 0x00dc }
            r1.<init>(r5)     // Catch:{ Exception -> 0x00dc }
            java.lang.String r5 = "expires_in"
            long r8 = r1.getLong(r5)     // Catch:{ Exception -> 0x00e6 }
            long r10 = java.lang.System.currentTimeMillis()     // Catch:{ Exception -> 0x00e6 }
            int r5 = (r8 > r10 ? 1 : (r8 == r10 ? 0 : -1))
            if (r5 >= 0) goto L_0x00e9
            r0 = 0
        L_0x001b:
            if (r0 != 0) goto L_0x00db
            com.zing.zalo.zalosdk.core.http.HttpClientRequest r4 = new com.zing.zalo.zalosdk.core.http.HttpClientRequest     // Catch:{ Exception -> 0x00e0 }
            com.zing.zalo.zalosdk.core.http.HttpClientRequest$Type r5 = com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type.POST     // Catch:{ Exception -> 0x00e0 }
            com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager r8 = com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager.getInstance()     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r9 = "oauth_http_s"
            java.lang.String r10 = "/v3/mobile/access_token"
            java.lang.String r8 = r8.urlFor(r9, r10)     // Catch:{ Exception -> 0x00e0 }
            r4.<init>(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "code"
            com.zing.zalo.zalosdk.oauth.ZaloSDK r8 = com.zing.zalo.zalosdk.oauth.ZaloSDK.Instance     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r8.getOAuthCode()     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "pkg_name"
            java.lang.String r8 = com.zing.zalo.zalosdk.core.helper.AppInfo.getPackageName(r13)     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "sign_key"
            java.lang.String r8 = com.zing.zalo.zalosdk.core.helper.AppInfo.getApplicationHashKey(r13)     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "app_id"
            java.lang.StringBuilder r8 = new java.lang.StringBuilder     // Catch:{ Exception -> 0x00e0 }
            r8.<init>()     // Catch:{ Exception -> 0x00e0 }
            com.zing.zalo.zalosdk.oauth.ZaloSDK r9 = com.zing.zalo.zalosdk.oauth.ZaloSDK.Instance     // Catch:{ Exception -> 0x00e0 }
            long r10 = r9.getAppID()     // Catch:{ Exception -> 0x00e0 }
            java.lang.StringBuilder r8 = r8.append(r10)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r9 = ""
            java.lang.StringBuilder r8 = r8.append(r9)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r8.toString()     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "version"
            com.zing.zalo.zalosdk.oauth.ZaloSDK r8 = com.zing.zalo.zalosdk.oauth.ZaloSDK.Instance     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r8.getVersion()     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "zdevice"
            com.zing.zalo.zalosdk.oauth.ZaloSDK r8 = com.zing.zalo.zalosdk.oauth.ZaloSDK.Instance     // Catch:{ Exception -> 0x00e0 }
            com.zing.zalo.devicetrackingsdk.DeviceTracking r8 = r8.getBaseAppInfo()     // Catch:{ Exception -> 0x00e0 }
            org.json.JSONObject r8 = r8.prepareDeviceIdData()     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r8.toString()     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "ztracking"
            com.zing.zalo.zalosdk.oauth.ZaloSDK r8 = com.zing.zalo.zalosdk.oauth.ZaloSDK.Instance     // Catch:{ Exception -> 0x00e0 }
            com.zing.zalo.devicetrackingsdk.DeviceTracking r8 = r8.getBaseAppInfo()     // Catch:{ Exception -> 0x00e0 }
            org.json.JSONObject r8 = r8.prepareTrackingData()     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r8.toString()     // Catch:{ Exception -> 0x00e0 }
            r4.addParams(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "gid"
            com.zing.zalo.zalosdk.oauth.ZaloSDK r8 = com.zing.zalo.zalosdk.oauth.ZaloSDK.Instance     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r8.getDeviceId()     // Catch:{ Exception -> 0x00e0 }
            r4.addHeader(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            org.json.JSONObject r0 = r4.getJSON()     // Catch:{ Exception -> 0x00e0 }
            if (r0 == 0) goto L_0x00db
            java.lang.String r5 = "error"
            r8 = -1
            int r5 = r0.optInt(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            if (r5 < 0) goto L_0x00db
            java.lang.String r5 = "data"
            org.json.JSONObject r0 = r0.optJSONObject(r5)     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r5 = "error"
            r8 = 0
            r0.put(r5, r8)     // Catch:{ Exception -> 0x00e0 }
            if (r0 == 0) goto L_0x00db
            long r8 = java.lang.System.currentTimeMillis()     // Catch:{ Exception -> 0x00e0 }
            r10 = 1800000(0x1b7740, double:8.89318E-318)
            long r6 = r8 + r10
            java.lang.String r5 = "expires_in"
            r0.put(r5, r6)     // Catch:{ Exception -> 0x00e0 }
            com.zing.zalo.zalosdk.oauth.OauthStorage r5 = r12.d     // Catch:{ Exception -> 0x00e0 }
            java.lang.String r8 = r0.toString()     // Catch:{ Exception -> 0x00e0 }
            r5.setAccessTokenNewAPI(r8)     // Catch:{ Exception -> 0x00e0 }
        L_0x00db:
            return r0
        L_0x00dc:
            r3 = move-exception
        L_0x00dd:
            r0 = 0
            goto L_0x001b
        L_0x00e0:
            r2 = move-exception
            r2.printStackTrace()
            r0 = 0
            goto L_0x00db
        L_0x00e6:
            r3 = move-exception
            r0 = r1
            goto L_0x00dd
        L_0x00e9:
            r0 = r1
            goto L_0x001b
        */
        throw new UnsupportedOperationException("Method not decompiled: com.zing.zalo.zalosdk.oauth.OpenAPIService.a(android.content.Context):org.json.JSONObject");
    }

    private String a(String[] fields) {
        if (fields == null || fields.length <= 0) {
            return "";
        }
        StringBuffer param = new StringBuffer();
        for (int i2 = 0; i2 < fields.length - 1; i2++) {
            param.append(fields[i2]).append(",");
        }
        param.append(fields[fields.length - 1]);
        return param.toString();
    }

    public void getProfile(Context ctx, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me"));
        request.addParams("fields", a(fields));
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListUsedApp(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/friends"));
        request.addParams("fields", a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListInvitable(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/invitable_friends"));
        request.addParams("fields", a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void setShareZaloUsing(ShareVia _shareVia) {
        this.j = _shareVia;
    }

    public void setShareZaloChatOnly(boolean chatOnly) {
        this.k = chatOnly;
    }

    public ShareVia getShareZaloUsing() {
        return this.j;
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        c(context, feedOb, callback, "feed", false);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        c(context, feedOb, callback, "message", false);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        c(context, feedOb, callback, null, false);
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        c(context, feedOb, callback, "feed", autoBack);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        c(context, feedOb, callback, "message", autoBack);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        c(context, feedOb, callback, null, autoBack);
    }

    private void a(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        CharSequence[] colors = {"Gửi tin nhắn Zalo", "Đăng lên Zalo"};
        Builder builder = new Builder(context);
        builder.setTitle("Chọn");
        final Context context2 = context;
        final FeedData feedData = feedOb;
        final ZaloPluginCallback zaloPluginCallback = callback;
        final boolean z = autoBack;
        builder.setItems(colors, new OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    OpenAPIService.this.a(context2, feedData, zaloPluginCallback, "message", z);
                } else {
                    OpenAPIService.this.a(context2, feedData, zaloPluginCallback, "feed", z);
                }
            }
        });
        builder.show();
    }

    private void b(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("msg=").append(URLEncoder.encode(feedOb.getMsg(), "UTF-8")).append("&");
            sb.append("link=").append(URLEncoder.encode(feedOb.getLink(), "UTF-8")).append("&");
            sb.append("app_name=").append(URLEncoder.encode(feedOb.getAppName(), "UTF-8")).append("&");
            sb.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty(shareTo)) {
                sb.append("share_to=").append(shareTo).append("&");
            }
            sb.append("app_version=").append(context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName).append("&");
            sb.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            sb.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer extraBody = new StringBuffer();
            extraBody.append("link_title=").append(URLEncoder.encode(feedOb.getLinkTitle(), "UTF-8")).append("&");
            extraBody.append("link_desc=").append(URLEncoder.encode(feedOb.getLinkDesc(), "UTF-8")).append("&");
            extraBody.append("link_source=").append(URLEncoder.encode(feedOb.getLinkSource(), "UTF-8")).append("&");
            if (feedOb.getLinkThumb() != null) {
                for (String encode : feedOb.getLinkThumb()) {
                    extraBody.append("link_thumb=").append(URLEncoder.encode(encode, "UTF-8")).append("&");
                }
            }
            if (feedOb.getParams() != null) {
                for (Entry<String, String> entry : feedOb.getParams().entrySet()) {
                    StringBuffer stringBuffer = sb;
                    stringBuffer.append(((String) entry.getKey()) + "=").append(URLEncoder.encode((String) entry.getValue(), "UTF-8")).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", sb.toString());
            bundle.putString("bodyrequest", extraBody.toString());
            bundle.putString("oauthCodeaa", this.d.getZaloPluginOAuthCode());
            final WebDialog feedDialog = new FeedDialogBuilder(context, bundle).build();
            final Context context2 = context;
            final FeedData feedData = feedOb;
            final ZaloPluginCallback zaloPluginCallback = callback;
            final String str = shareTo;
            final boolean z = autoBack;
            feedDialog.setFeedCallBackListener(new ZaloPluginCallback() {
                public void onResult(boolean arg0, int errorCode, String arg2, String arg3) {
                    feedDialog.dismiss();
                    if (errorCode == -10) {
                        OpenAPIService.this.e = true;
                        OpenAPIService.this.a(context2, feedData, zaloPluginCallback, str, z);
                    } else if (errorCode == -1) {
                        OpenAPIService.this.e(context2, feedData, zaloPluginCallback, str, z);
                    } else {
                        OpenAPIService.this.e = false;
                        if (zaloPluginCallback != null) {
                            zaloPluginCallback.onResult(arg0, errorCode, arg2, arg3);
                        }
                    }
                }
            });
            feedDialog.show();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void c(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        if (ZaloSDK.Instance.isAuthenticate(this.d.getZaloPluginOAuthCode(), null)) {
            a(context, feedOb, callback, shareTo, autoBack);
        } else if (!LoginChannel.ZALO.toString().equalsIgnoreCase(this.d.getLastestLoginChannel()) || !ZaloSDK.Instance.isAuthenticate(null)) {
            e(context, feedOb, callback, shareTo, autoBack);
        } else {
            this.d.setZaloPluginOAuthCode(this.d.getOAuthCode());
            this.d.setZaloPluginUserId(this.d.getZaloId());
            a(context, feedOb, callback, shareTo, autoBack);
        }
    }

    /* access modifiers changed from: protected */
    public void a(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        this.c = feedOb;
        this._shareTo = shareTo;
        this._autoBack = autoBack;
        if (this.e) {
            d(context, feedOb, callback, shareTo, autoBack);
        } else if (this.j != ShareVia.AppThenWeb) {
            b(context, feedOb, callback, shareTo, autoBack);
        } else if (Utilities.isZaloInstalled(context)) {
            d(context, feedOb, callback, shareTo, autoBack);
        } else {
            b(context, feedOb, callback, shareTo, autoBack);
        }
    }

    private void d(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        boolean ableCalled = false;
        if (TextUtils.isEmpty(shareTo)) {
            a(context, feedOb, callback, autoBack);
            return;
        }
        Intent intent = a(context, feedOb, shareTo, autoBack);
        if (intent.resolveActivityInfo(context.getPackageManager(), 0) != null) {
            ableCalled = true;
        }
        if (ableCalled) {
            c(context);
            this.i = new WeakReference<>(callback);
            context.startActivity(intent);
            return;
        }
        Utilities.invokeMarketApp(context, "com.zing.zalo");
    }

    private Intent b(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent a(Context context, String shareTo, boolean _autoBack2) {
        Intent intent = b(context);
        intent.addFlags(268435456);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        intent.putExtra("autoBack", _autoBack2);
        return intent;
    }

    /* access modifiers changed from: private */
    public void e(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean _autoBack2) {
        this.c = feedOb;
        this.a = new WeakReference<>(callback);
        this.b = new WeakReference<>(context);
        context.startActivity(a(context, shareTo, _autoBack2));
    }

    private Intent a(Context context, FeedData feedOb, String shareTo, boolean autoBack) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedOb.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedOb.getLink());
        this.f = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.f);
        if (!TextUtils.isEmpty(shareTo)) {
            if (shareTo.equals("feed")) {
                intent.putExtra("postFeed", true);
            } else if (shareTo.equals("message") && this.k) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (autoBack) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra("backToSource", true);
        return intent;
    }

    private void c(Context mContext) {
        if (Utilities.isZaloSupportCallBack(mContext)) {
            if (!this.h) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.g = new BroadcastReceiver() {
                    public void onReceive(Context context, Intent intent) {
                        try {
                            JSONObject jOb = new JSONObject(intent.getExtras().getString("result"));
                            boolean isSucc = false;
                            if (jOb != null) {
                                try {
                                    if (jOb.has("token")) {
                                        String token = jOb.getString("token");
                                        if (token != null && token.equals(OpenAPIService.this.f)) {
                                            int errorCode = jOb.getInt("error_code");
                                            OpenAPIService.this.d(context);
                                            if (OpenAPIService.this.i != null) {
                                                ZaloPluginCallback callback = (ZaloPluginCallback) OpenAPIService.this.i.get();
                                                if (errorCode == 0) {
                                                    isSucc = true;
                                                }
                                                if (callback != null) {
                                                    callback.onResult(isSucc, jOb.getInt("error_code"), null, null);
                                                }
                                            }
                                        }
                                    }
                                } catch (Exception e) {
                                    JSONObject jSONObject = jOb;
                                    return;
                                }
                            }
                            JSONObject jSONObject2 = jOb;
                        } catch (Exception e2) {
                        }
                    }
                };
                mContext.registerReceiver(this.g, filter);
                this.h = true;
            }
        } else if (this.i != null) {
            ZaloPluginCallback callback = (ZaloPluginCallback) this.i.get();
            if (callback != null) {
                callback.onResult(true, 0, null, null);
            }
        }
    }

    /* access modifiers changed from: private */
    public void d(Context mContext) {
        if (this.g != null) {
            mContext.unregisterReceiver(this.g);
            this.h = false;
        }
    }

    public void inviteFriendUseApp(Context ctx, String[] friendId, String message, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/apprequests"));
        request.addParams("to", a(friendId));
        request.addParams("message", message);
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void postToWall(Context context, String link, String msg, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/feed"));
        request.addParams("link", link);
        request.addParams("message", msg);
        new NewUserTask(context, callback).execute(new HttpClientRequest[]{request});
    }

    public void sendMsgToFriend(Context context, String friendId, String msg, String link, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/message"));
        request.addParams("to", friendId);
        request.addParams("message", msg);
        request.addParams("link", link);
        new NewUserTask(context, callback).execute(new HttpClientRequest[]{request});
    }

    public void broadcastViaOfficalAccount(Context context, String templateid, String templatedata, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/oa/message"));
        request.addParams("templateid", templateid);
        request.addParams("templatedata", templatedata);
        new NewUserTask(context, callback).execute(new HttpClientRequest[]{request});
    }
}
