package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;

public class OpenAPIActivity extends Activity {
    LoginListener a;

    private class LoginListener extends OAuthCompleteListener {
        String a;
        boolean b;

        public LoginListener(String shareTo, boolean _autoBack) {
            this.a = shareTo;
            this.b = _autoBack;
        }

        public void onAuthenError(int errorCode, String message) {
            OpenAPIActivity.super.onAuthenError(errorCode, message);
            if (OpenAPIService.getInstance().a != null) {
                ZaloPluginCallback callback = (ZaloPluginCallback) OpenAPIService.getInstance().a.get();
                if (callback != null) {
                    callback.onResult(false, errorCode, message, "");
                }
            }
            OpenAPIActivity.this.finish();
        }

        public void onGetOAuthComplete(OauthResponse response) {
            OpenAPIActivity.super.onGetOAuthComplete(response);
            OpenAPIService op = OpenAPIService.getInstance();
            if (op.a != null) {
                ZaloPluginCallback callback = (ZaloPluginCallback) op.a.get();
                Context context = (Context) op.b.get();
                if (!(callback == null || context == null)) {
                    op._shareTo = this.a;
                    op._autoBack = this.b;
                    op.a(context, op.c, callback, op._shareTo, op._autoBack);
                }
            }
            OpenAPIActivity.this.finish();
        }
    }

    /* access modifiers changed from: protected */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean login_from_share_feed = getIntent().getBooleanExtra("login_from_share_feed", false);
        String shareTo = getIntent().getStringExtra("share_to");
        boolean _autoBack = getIntent().getBooleanExtra("autoBack", false);
        if (login_from_share_feed) {
            this.a = new LoginListener(shareTo, _autoBack);
            ZaloSDK.Instance.authenticateZaloPlugin(this, this.a);
        }
    }

    /* access modifiers changed from: protected */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ZaloSDK.Instance.onActivityResult(this, requestCode, resultCode, data);
    }
}
