/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.oauth.FeedData;
import com.zing.zalo.zalosdk.oauth.LoginChannel;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.OpenAPIActivity;
import com.zing.zalo.zalosdk.oauth.ShareVia;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.WebDialog;
import com.zing.zalo.zalosdk.oauth.ZaloOpenAPICallback;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONObject;

public class OpenAPIService {
    private OauthStorage d = null;
    private boolean e = false;
    protected WeakReference<ZaloPluginCallback> a;
    protected WeakReference<Context> b;
    protected FeedData c;
    public String _shareTo = "";
    public boolean _autoBack = false;
    private String f = "";
    private BroadcastReceiver g;
    private boolean h = false;
    private WeakReference<ZaloPluginCallback> i;
    private ShareVia j = ShareVia.AppThenWeb;
    private boolean k = false;
    private static OpenAPIService l;

    public OpenAPIService() {
        this.d = ZaloSDK.Instance.getOauthStorage();
    }

    @Deprecated
    public static OpenAPIService getInstance() {
        if (l == null) {
            l = new OpenAPIService();
        }
        return l;
    }

    private JSONObject a(Context ctx) {
        JSONObject accessToken = null;
        try {
            accessToken = new JSONObject(this.d.getAccessTokenNewAPI());
            if (accessToken.getLong("expires_in") < System.currentTimeMillis()) {
                accessToken = null;
            }
        }
        catch (Exception ex) {
            accessToken = null;
        }
        try {
            if (accessToken == null) {
                HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/mobile/access_token"));
                request.addParams("code", ZaloSDK.Instance.getOAuthCode());
                request.addParams("pkg_name", AppInfo.getPackageName((Context)ctx));
                request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)ctx));
                request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                request.addParams("version", ZaloSDK.Instance.getVersion());
                request.addParams("zdevice", ZaloSDK.Instance.getBaseAppInfo().prepareDeviceIdData().toString());
                request.addParams("ztracking", ZaloSDK.Instance.getBaseAppInfo().prepareTrackingData().toString());
                request.addHeader("gid", ZaloSDK.Instance.getDeviceId());
                accessToken = request.getJSON();
                if (accessToken != null && accessToken.optInt("error", -1) >= 0) {
                    accessToken = accessToken.optJSONObject("data");
                    accessToken.put("error", 0);
                    if (accessToken != null) {
                        long time = System.currentTimeMillis() + 1800000L;
                        accessToken.put("expires_in", time);
                        this.d.setAccessTokenNewAPI(accessToken.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            accessToken = null;
        }
        return accessToken;
    }

    private String a(String[] fields) {
        if (fields != null && fields.length > 0) {
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < fields.length - 1; ++i) {
                param.append(fields[i]).append(",");
            }
            param.append(fields[fields.length - 1]);
            return param.toString();
        }
        return "";
    }

    public void getProfile(Context ctx, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me"));
        request.addParams("fields", this.a(fields));
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListUsedApp(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/friends"));
        request.addParams("fields", this.a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListInvitable(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/invitable_friends"));
        request.addParams("fields", this.a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void setShareZaloUsing(ShareVia _shareVia) {
        this.j = _shareVia;
    }

    public void setShareZaloChatOnly(boolean chatOnly) {
        this.k = chatOnly;
    }

    public ShareVia getShareZaloUsing() {
        return this.j;
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.c(context, feedOb, callback, "feed", false);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.c(context, feedOb, callback, "message", false);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.c(context, feedOb, callback, null, false);
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        this.c(context, feedOb, callback, "feed", autoBack);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        this.c(context, feedOb, callback, "message", autoBack);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        this.c(context, feedOb, callback, null, autoBack);
    }

    private void a(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final boolean autoBack) {
        CharSequence[] colors = new CharSequence[]{"G\u1eedi tin nh\u1eafn Zalo", "\u0110\u0103ng l\u00ean Zalo"};
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"Ch\u1ecdn");
        builder.setItems(colors, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    OpenAPIService.this.a(context, feedOb, callback, "message", autoBack);
                } else {
                    OpenAPIService.this.a(context, feedOb, callback, "feed", autoBack);
                }
            }
        });
        builder.show();
    }

    private void b(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo, final boolean autoBack) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("msg=").append(URLEncoder.encode(feedOb.getMsg(), "UTF-8")).append("&");
            sb.append("link=").append(URLEncoder.encode(feedOb.getLink(), "UTF-8")).append("&");
            sb.append("app_name=").append(URLEncoder.encode(feedOb.getAppName(), "UTF-8")).append("&");
            sb.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty((CharSequence)shareTo)) {
                sb.append("share_to=").append(shareTo).append("&");
            }
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String version = pInfo.versionName;
            sb.append("app_version=").append(version).append("&");
            sb.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            sb.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer extraBody = new StringBuffer();
            extraBody.append("link_title=").append(URLEncoder.encode(feedOb.getLinkTitle(), "UTF-8")).append("&");
            extraBody.append("link_desc=").append(URLEncoder.encode(feedOb.getLinkDesc(), "UTF-8")).append("&");
            extraBody.append("link_source=").append(URLEncoder.encode(feedOb.getLinkSource(), "UTF-8")).append("&");
            if (feedOb.getLinkThumb() != null) {
                int length = feedOb.getLinkThumb().length;
                for (int i = 0; i < length; ++i) {
                    extraBody.append("link_thumb=").append(URLEncoder.encode(feedOb.getLinkThumb()[i], "UTF-8")).append("&");
                }
            }
            if (feedOb.getParams() != null) {
                for (Map.Entry<String, String> entry : feedOb.getParams().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    sb.append(key + "=").append(URLEncoder.encode(value, "UTF-8")).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", sb.toString());
            bundle.putString("bodyrequest", extraBody.toString());
            bundle.putString("oauthCodeaa", this.d.getZaloPluginOAuthCode());
            final WebDialog feedDialog = new WebDialog.FeedDialogBuilder(context, bundle).build();
            feedDialog.setFeedCallBackListener(new ZaloPluginCallback(){

                public void onResult(boolean arg0, int errorCode, String arg2, String arg3) {
                    feedDialog.dismiss();
                    if (errorCode == -10) {
                        OpenAPIService.this.e = true;
                        OpenAPIService.this.a(context, feedOb, callback, shareTo, autoBack);
                    } else if (errorCode == -1) {
                        OpenAPIService.this.e(context, feedOb, callback, shareTo, autoBack);
                    } else {
                        OpenAPIService.this.e = false;
                        if (callback != null) {
                            callback.onResult(arg0, errorCode, arg2, arg3);
                        }
                    }
                }
            });
            feedDialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void c(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        if (ZaloSDK.Instance.isAuthenticate(this.d.getZaloPluginOAuthCode(), null)) {
            this.a(context, feedOb, callback, shareTo, autoBack);
        } else {
            if (LoginChannel.ZALO.toString().equalsIgnoreCase(this.d.getLastestLoginChannel()) && ZaloSDK.Instance.isAuthenticate(null)) {
                this.d.setZaloPluginOAuthCode(this.d.getOAuthCode());
                this.d.setZaloPluginUserId(this.d.getZaloId());
                this.a(context, feedOb, callback, shareTo, autoBack);
                return;
            }
            this.e(context, feedOb, callback, shareTo, autoBack);
        }
    }

    protected void a(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        this.c = feedOb;
        this._shareTo = shareTo;
        this._autoBack = autoBack;
        if (this.e) {
            this.d(context, feedOb, callback, shareTo, autoBack);
            return;
        }
        if (this.j == ShareVia.AppThenWeb) {
            if (Utilities.isZaloInstalled((Context)context)) {
                this.d(context, feedOb, callback, shareTo, autoBack);
            } else {
                this.b(context, feedOb, callback, shareTo, autoBack);
            }
        } else {
            this.b(context, feedOb, callback, shareTo, autoBack);
        }
    }

    private void d(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        if (TextUtils.isEmpty((CharSequence)shareTo)) {
            this.a(context, feedOb, callback, autoBack);
        } else {
            boolean ableCalled;
            Intent intent = this.a(context, feedOb, shareTo, autoBack);
            boolean bl = ableCalled = intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
            if (ableCalled) {
                this.c(context);
                this.i = new WeakReference<ZaloPluginCallback>(callback);
                context.startActivity(intent);
            } else {
                Utilities.invokeMarketApp((Context)context, (String)"com.zing.zalo");
            }
        }
    }

    private Intent b(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent a(Context context, String shareTo, boolean _autoBack) {
        Intent intent = this.b(context);
        intent.addFlags(0x10000000);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        intent.putExtra("autoBack", _autoBack);
        return intent;
    }

    private void e(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean _autoBack) {
        this.c = feedOb;
        this.a = new WeakReference<ZaloPluginCallback>(callback);
        this.b = new WeakReference<Context>(context);
        Intent intent = this.a(context, shareTo, _autoBack);
        context.startActivity(intent);
    }

    private Intent a(Context context, FeedData feedOb, String shareTo, boolean autoBack) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedOb.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedOb.getLink());
        this.f = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.f);
        if (!TextUtils.isEmpty((CharSequence)shareTo)) {
            if (shareTo.equals("feed")) {
                intent.putExtra("postFeed", true);
            } else if (shareTo.equals("message") && this.k) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (autoBack) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra("backToSource", true);
        return intent;
    }

    private void c(Context mContext) {
        ZaloPluginCallback callback;
        if (Utilities.isZaloSupportCallBack((Context)mContext)) {
            if (!this.h) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.g = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String json = intent.getExtras().getString("result");
                        JSONObject jOb = null;
                        try {
                            jOb = new JSONObject(json);
                            int errorCode = 0;
                            boolean isSucc = false;
                            String token = null;
                            if (jOb != null && jOb.has("token") && (token = jOb.getString("token")) != null && token.equals(OpenAPIService.this.f)) {
                                errorCode = jOb.getInt("error_code");
                                OpenAPIService.this.d(context);
                                if (OpenAPIService.this.i != null) {
                                    ZaloPluginCallback callback = (ZaloPluginCallback)OpenAPIService.this.i.get();
                                    if (errorCode == 0) {
                                        isSucc = true;
                                    }
                                    if (callback != null) {
                                        callback.onResult(isSucc, jOb.getInt("error_code"), null, null);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                mContext.registerReceiver(this.g, filter);
                this.h = true;
            }
        } else if (this.i != null && (callback = (ZaloPluginCallback)this.i.get()) != null) {
            callback.onResult(true, 0, null, null);
        }
    }

    private void d(Context mContext) {
        if (this.g != null) {
            mContext.unregisterReceiver(this.g);
            this.h = false;
        }
    }

    public void inviteFriendUseApp(Context ctx, String[] friendId, String message, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/apprequests"));
        request.addParams("to", this.a(friendId));
        request.addParams("message", message);
        new NewUserTask(ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void postToWall(Context context, String link, String msg, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/feed"));
        request.addParams("link", link);
        request.addParams("message", msg);
        new NewUserTask(context, callback).execute(new HttpClientRequest[]{request});
    }

    public void sendMsgToFriend(Context context, String friendId, String msg, String link, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/message"));
        request.addParams("to", friendId);
        request.addParams("message", msg);
        request.addParams("link", link);
        new NewUserTask(context, callback).execute(new HttpClientRequest[]{request});
    }

    public void broadcastViaOfficalAccount(Context context, String templateid, String templatedata, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/oa/message"));
        request.addParams("templateid", templateid);
        request.addParams("templatedata", templatedata);
        new NewUserTask(context, callback).execute(new HttpClientRequest[]{request});
    }

    private class NewUserTask
    extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        ZaloOpenAPICallback b;

        NewUserTask(Context ctx, ZaloOpenAPICallback _mOpenAPICallackNewAPI) {
            this.a = ctx;
            this.b = _mOpenAPICallackNewAPI;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject a(HttpClientRequest ... requests) {
            HttpClientRequest request = requests[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            JSONObject accessToken = OpenAPIService.this.a(this.a);
            if (accessToken == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            try {
                if (accessToken.has("access_token")) {
                    request.addParams("access_token", accessToken.optString("access_token"));
                    return request.getJSON();
                }
                return accessToken;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        protected void a(JSONObject object) {
            try {
                if (object != null) {
                    this.b.onResult(object);
                } else {
                    this.b.onResult(new JSONObject("{\"error\":-1112}"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.b.onResult(null);
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((JSONObject)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((HttpClientRequest[])objectArray);
        }
    }
}

