package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog.Builder;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.oauth.WebDialog.FeedDialogBuilder;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Map.Entry;
import org.json.JSONObject;

public class OpenAPIService {
    private static OpenAPIService l;
    public boolean _autoBack;
    public String _shareTo;
    protected WeakReference<ZaloPluginCallback> a;
    protected WeakReference<Context> b;
    protected FeedData c;
    private OauthStorage d;
    private boolean e;
    private String f;
    private BroadcastReceiver g;
    private boolean h;
    private WeakReference<ZaloPluginCallback> i;
    private ShareVia j;
    private boolean k;

    private class NewUserTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        ZaloOpenAPICallback b;
        final /* synthetic */ OpenAPIService c;

        protected /* synthetic */ Object doInBackground(Object[] objArr) {
            return a((HttpClientRequest[]) objArr);
        }

        protected /* synthetic */ void onPostExecute(Object obj) {
            a((JSONObject) obj);
        }

        NewUserTask(OpenAPIService openAPIService, Context ctx, ZaloOpenAPICallback _mOpenAPICallackNewAPI) {
            this.c = openAPIService;
            this.a = ctx;
            this.b = _mOpenAPICallackNewAPI;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject a(HttpClientRequest... requests) {
            HttpClientRequest request = requests[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                } catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            JSONObject accessToken = this.c.a(this.a);
            if (accessToken == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                } catch (Exception e2) {
                    e2.printStackTrace();
                    return null;
                }
            }
            try {
                if (!accessToken.has("access_token")) {
                    return accessToken;
                }
                request.addParams("access_token", accessToken.optString("access_token"));
                return request.getJSON();
            } catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        protected void a(JSONObject object) {
            if (object != null) {
                try {
                    this.b.onResult(object);
                    return;
                } catch (Exception ex) {
                    ex.printStackTrace();
                    this.b.onResult(null);
                    return;
                }
            }
            this.b.onResult(new JSONObject("{\"error\":-1112}"));
        }
    }

    public OpenAPIService() {
        this.d = null;
        this.e = false;
        this._shareTo = "";
        this._autoBack = false;
        this.f = "";
        this.h = false;
        this.j = ShareVia.AppThenWeb;
        this.k = false;
        this.d = ZaloSDK.Instance.getOauthStorage();
    }

    @Deprecated
    public static OpenAPIService getInstance() {
        if (l == null) {
            l = new OpenAPIService();
        }
        return l;
    }

    private JSONObject a(Context ctx) {
        JSONObject accessToken;
        HttpClientRequest request;
        try {
            JSONObject accessToken2 = new JSONObject(this.d.getAccessTokenNewAPI());
            try {
                if (accessToken2.getLong("expires_in") < System.currentTimeMillis()) {
                    accessToken = null;
                } else {
                    accessToken = accessToken2;
                }
            } catch (Exception e) {
                accessToken = accessToken2;
                accessToken = null;
                if (accessToken == null) {
                    return accessToken;
                }
                try {
                    request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/mobile/access_token"));
                    request.addParams("code", ZaloSDK.Instance.getOAuthCode());
                    request.addParams("pkg_name", AppInfo.getPackageName(ctx));
                    request.addParams("sign_key", AppInfo.getApplicationHashKey(ctx));
                    request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                    request.addParams("version", ZaloSDK.Instance.getVersion());
                    request.addParams("zdevice", ZaloSDK.Instance.getBaseAppInfo().prepareDeviceIdData().toString());
                    request.addParams("ztracking", ZaloSDK.Instance.getBaseAppInfo().prepareTrackingData().toString());
                    request.addHeader("gid", ZaloSDK.Instance.getDeviceId());
                    accessToken = request.getJSON();
                    return accessToken != null ? accessToken : accessToken;
                } catch (Exception e2) {
                    e2.printStackTrace();
                    return null;
                }
            }
        } catch (Exception e3) {
            accessToken = null;
            if (accessToken == null) {
                return accessToken;
            }
            request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/mobile/access_token"));
            request.addParams("code", ZaloSDK.Instance.getOAuthCode());
            request.addParams("pkg_name", AppInfo.getPackageName(ctx));
            request.addParams("sign_key", AppInfo.getApplicationHashKey(ctx));
            request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
            request.addParams("version", ZaloSDK.Instance.getVersion());
            request.addParams("zdevice", ZaloSDK.Instance.getBaseAppInfo().prepareDeviceIdData().toString());
            request.addParams("ztracking", ZaloSDK.Instance.getBaseAppInfo().prepareTrackingData().toString());
            request.addHeader("gid", ZaloSDK.Instance.getDeviceId());
            accessToken = request.getJSON();
            if (accessToken != null) {
            }
        }
        if (accessToken == null) {
            return accessToken;
        }
        request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/mobile/access_token"));
        request.addParams("code", ZaloSDK.Instance.getOAuthCode());
        request.addParams("pkg_name", AppInfo.getPackageName(ctx));
        request.addParams("sign_key", AppInfo.getApplicationHashKey(ctx));
        request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
        request.addParams("version", ZaloSDK.Instance.getVersion());
        request.addParams("zdevice", ZaloSDK.Instance.getBaseAppInfo().prepareDeviceIdData().toString());
        request.addParams("ztracking", ZaloSDK.Instance.getBaseAppInfo().prepareTrackingData().toString());
        request.addHeader("gid", ZaloSDK.Instance.getDeviceId());
        accessToken = request.getJSON();
        if (accessToken != null && accessToken.optInt("error", -1) >= 0) {
            accessToken = accessToken.optJSONObject("data");
            accessToken.put("error", 0);
            if (accessToken == null) {
                return accessToken;
            }
            accessToken.put("expires_in", System.currentTimeMillis() + 1800000);
            this.d.setAccessTokenNewAPI(accessToken.toString());
            return accessToken;
        }
    }

    private String a(String[] fields) {
        if (fields == null || fields.length <= 0) {
            return "";
        }
        StringBuffer param = new StringBuffer();
        for (int i = 0; i < fields.length - 1; i++) {
            param.append(fields[i]).append(",");
        }
        param.append(fields[fields.length - 1]);
        return param.toString();
    }

    public void getProfile(Context ctx, ZaloOpenAPICallback callback, String[] fields) {
        new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me")).addParams("fields", a(fields));
        new NewUserTask(this, ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListUsedApp(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/friends"));
        request.addParams("fields", a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        new NewUserTask(this, ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void getFriendListInvitable(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/invitable_friends"));
        request.addParams("fields", a(fields));
        request.addParams("offset", position + "");
        request.addParams("limit", count + "");
        new NewUserTask(this, ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void setShareZaloUsing(ShareVia _shareVia) {
        this.j = _shareVia;
    }

    public void setShareZaloChatOnly(boolean chatOnly) {
        this.k = chatOnly;
    }

    public ShareVia getShareZaloUsing() {
        return this.j;
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        c(context, feedOb, callback, "feed", false);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        c(context, feedOb, callback, "message", false);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        c(context, feedOb, callback, null, false);
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        c(context, feedOb, callback, "feed", autoBack);
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        c(context, feedOb, callback, "message", autoBack);
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        c(context, feedOb, callback, null, autoBack);
    }

    private void a(Context context, FeedData feedOb, ZaloPluginCallback callback, boolean autoBack) {
        CharSequence[] colors = new CharSequence[]{"Gửi tin nhắn Zalo", "Đăng lên Zalo"};
        Builder builder = new Builder(context);
        builder.setTitle("Chọn");
        final Context context2 = context;
        final FeedData feedData = feedOb;
        final ZaloPluginCallback zaloPluginCallback = callback;
        final boolean z = autoBack;
        builder.setItems(colors, new OnClickListener(this) {
            final /* synthetic */ OpenAPIService e;

            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    this.e.a(context2, feedData, zaloPluginCallback, "message", z);
                } else {
                    this.e.a(context2, feedData, zaloPluginCallback, "feed", z);
                }
            }
        });
        builder.show();
    }

    private void b(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("msg=").append(URLEncoder.encode(feedOb.getMsg(), "UTF-8")).append("&");
            sb.append("link=").append(URLEncoder.encode(feedOb.getLink(), "UTF-8")).append("&");
            sb.append("app_name=").append(URLEncoder.encode(feedOb.getAppName(), "UTF-8")).append("&");
            sb.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty(shareTo)) {
                sb.append("share_to=").append(shareTo).append("&");
            }
            sb.append("app_version=").append(context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName).append("&");
            sb.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            sb.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer extraBody = new StringBuffer();
            extraBody.append("link_title=").append(URLEncoder.encode(feedOb.getLinkTitle(), "UTF-8")).append("&");
            extraBody.append("link_desc=").append(URLEncoder.encode(feedOb.getLinkDesc(), "UTF-8")).append("&");
            extraBody.append("link_source=").append(URLEncoder.encode(feedOb.getLinkSource(), "UTF-8")).append("&");
            if (feedOb.getLinkThumb() != null) {
                for (String encode : feedOb.getLinkThumb()) {
                    extraBody.append("link_thumb=").append(URLEncoder.encode(encode, "UTF-8")).append("&");
                }
            }
            if (feedOb.getParams() != null) {
                for (Entry<String, String> entry : feedOb.getParams().entrySet()) {
                    StringBuffer stringBuffer = sb;
                    stringBuffer.append(((String) entry.getKey()) + "=").append(URLEncoder.encode((String) entry.getValue(), "UTF-8")).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", sb.toString());
            bundle.putString("bodyrequest", extraBody.toString());
            bundle.putString("oauthCodeaa", this.d.getZaloPluginOAuthCode());
            final WebDialog feedDialog = new FeedDialogBuilder(context, bundle).build();
            final Context context2 = context;
            final FeedData feedData = feedOb;
            final ZaloPluginCallback zaloPluginCallback = callback;
            final String str = shareTo;
            final boolean z = autoBack;
            feedDialog.setFeedCallBackListener(new ZaloPluginCallback(this) {
                final /* synthetic */ OpenAPIService g;

                public void onResult(boolean arg0, int errorCode, String arg2, String arg3) {
                    feedDialog.dismiss();
                    if (errorCode == -10) {
                        this.g.e = true;
                        this.g.a(context2, feedData, zaloPluginCallback, str, z);
                    } else if (errorCode == -1) {
                        this.g.e(context2, feedData, zaloPluginCallback, str, z);
                    } else {
                        this.g.e = false;
                        if (zaloPluginCallback != null) {
                            zaloPluginCallback.onResult(arg0, errorCode, arg2, arg3);
                        }
                    }
                }
            });
            feedDialog.show();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void c(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        if (ZaloSDK.Instance.isAuthenticate(this.d.getZaloPluginOAuthCode(), null)) {
            a(context, feedOb, callback, shareTo, autoBack);
        } else if (LoginChannel.ZALO.toString().equalsIgnoreCase(this.d.getLastestLoginChannel()) && ZaloSDK.Instance.isAuthenticate(null)) {
            this.d.setZaloPluginOAuthCode(this.d.getOAuthCode());
            this.d.setZaloPluginUserId(this.d.getZaloId());
            a(context, feedOb, callback, shareTo, autoBack);
        } else {
            e(context, feedOb, callback, shareTo, autoBack);
        }
    }

    protected void a(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        this.c = feedOb;
        this._shareTo = shareTo;
        this._autoBack = autoBack;
        if (this.e) {
            d(context, feedOb, callback, shareTo, autoBack);
        } else if (this.j != ShareVia.AppThenWeb) {
            b(context, feedOb, callback, shareTo, autoBack);
        } else if (Utilities.isZaloInstalled(context)) {
            d(context, feedOb, callback, shareTo, autoBack);
        } else {
            b(context, feedOb, callback, shareTo, autoBack);
        }
    }

    private void d(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean autoBack) {
        boolean ableCalled = false;
        if (TextUtils.isEmpty(shareTo)) {
            a(context, feedOb, callback, autoBack);
            return;
        }
        Intent intent = a(context, feedOb, shareTo, autoBack);
        if (intent.resolveActivityInfo(context.getPackageManager(), 0) != null) {
            ableCalled = true;
        }
        if (ableCalled) {
            c(context);
            this.i = new WeakReference(callback);
            context.startActivity(intent);
            return;
        }
        Utilities.invokeMarketApp(context, "com.zing.zalo");
    }

    private Intent b(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent a(Context context, String shareTo, boolean _autoBack) {
        Intent intent = b(context);
        intent.addFlags(268435456);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        intent.putExtra("autoBack", _autoBack);
        return intent;
    }

    private void e(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo, boolean _autoBack) {
        this.c = feedOb;
        this.a = new WeakReference(callback);
        this.b = new WeakReference(context);
        context.startActivity(a(context, shareTo, _autoBack));
    }

    private Intent a(Context context, FeedData feedOb, String shareTo, boolean autoBack) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedOb.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedOb.getLink());
        this.f = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.f);
        if (!TextUtils.isEmpty(shareTo)) {
            if (shareTo.equals("feed")) {
                intent.putExtra("postFeed", true);
            } else if (shareTo.equals("message") && this.k) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (autoBack) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra("backToSource", true);
        return intent;
    }

    private void c(Context mContext) {
        if (Utilities.isZaloSupportCallBack(mContext)) {
            if (!this.h) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.g = new BroadcastReceiver(this) {
                    final /* synthetic */ OpenAPIService a;

                    {
                        this.a = this$0;
                    }

                    public void onReceive(Context context, Intent intent) {
                        JSONObject jSONObject;
                        try {
                            JSONObject jOb = new JSONObject(intent.getExtras().getString("result"));
                            boolean isSucc = false;
                            if (jOb != null) {
                                try {
                                    if (jOb.has("token")) {
                                        String token = jOb.getString("token");
                                        if (token != null && token.equals(this.a.f)) {
                                            int errorCode = jOb.getInt("error_code");
                                            this.a.d(context);
                                            if (this.a.i != null) {
                                                ZaloPluginCallback callback = (ZaloPluginCallback) this.a.i.get();
                                                if (errorCode == 0) {
                                                    isSucc = true;
                                                }
                                                if (callback != null) {
                                                    callback.onResult(isSucc, jOb.getInt("error_code"), null, null);
                                                }
                                            }
                                        }
                                    }
                                } catch (Exception e) {
                                    jSONObject = jOb;
                                    return;
                                }
                            }
                            jSONObject = jOb;
                        } catch (Exception e2) {
                        }
                    }
                };
                mContext.registerReceiver(this.g, filter);
                this.h = true;
            }
        } else if (this.i != null) {
            ZaloPluginCallback callback = (ZaloPluginCallback) this.i.get();
            if (callback != null) {
                callback.onResult(true, 0, null, null);
            }
        }
    }

    private void d(Context mContext) {
        if (this.g != null) {
            mContext.unregisterReceiver(this.g);
            this.h = false;
        }
    }

    public void inviteFriendUseApp(Context ctx, String[] friendId, String message, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/apprequests"));
        request.addParams("to", a(friendId));
        request.addParams("message", message);
        new NewUserTask(this, ctx, callback).execute(new HttpClientRequest[]{request});
    }

    public void postToWall(Context context, String link, String msg, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/feed"));
        request.addParams("link", link);
        request.addParams("message", msg);
        new NewUserTask(this, context, callback).execute(new HttpClientRequest[]{request});
    }

    public void sendMsgToFriend(Context context, String friendId, String msg, String link, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/me/message"));
        request.addParams("to", friendId);
        request.addParams("message", msg);
        request.addParams("link", link);
        new NewUserTask(this, context, callback).execute(new HttpClientRequest[]{request});
    }

    public void broadcastViaOfficalAccount(Context context, String templateid, String templatedata, ZaloOpenAPICallback callback) {
        HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("graph_http_s", "/v2.0/oa/message"));
        request.addParams("templateid", templateid);
        request.addParams("templatedata", templatedata);
        new NewUserTask(this, context, callback).execute(new HttpClientRequest[]{request});
    }
}
