/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.oauth.FeedData;
import com.zing.zalo.zalosdk.oauth.LoginChannel;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.OpenAPIActivity;
import com.zing.zalo.zalosdk.oauth.ShareVia;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.WebDialog;
import com.zing.zalo.zalosdk.oauth.ZaloOpenAPICallback;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenAPIService {
    private OauthStorage d = null;
    private String e = "http://openapi.zaloapp.com/query";
    private String f = "https://graph.zalo.me/v2.0/me";
    private boolean g = false;
    protected WeakReference<ZaloPluginCallback> a;
    protected WeakReference<Context> b;
    protected FeedData c;
    public String _shareTo = "";
    public boolean _autoBack = false;
    private String h = "";
    private BroadcastReceiver i;
    private boolean j = false;
    private WeakReference<ZaloPluginCallback> k;
    private ShareVia l = ShareVia.AppThenWeb;
    private boolean m = false;
    private static OpenAPIService n;

    OpenAPIService() {
        this.d = ZaloSDK.Instance.getOauthStorage();
    }

    public static OpenAPIService getInstance() {
        if (n == null) {
            n = new OpenAPIService();
        }
        return n;
    }

    private JSONObject a(Context context) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(this.d.getAccessTokenNewAPI());
            if (jSONObject.getLong("expires_in") < System.currentTimeMillis()) {
                jSONObject = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jSONObject == null) {
                HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.POST, "https://oauth.zaloapp.com/v3/mobile/access_token");
                httpClientRequest.addParams("code", ZaloSDK.Instance.getOAuthCode());
                httpClientRequest.addParams("pkg_name", AppInfo.getPackageName((Context)context));
                httpClientRequest.addParams("sign_key", AppInfo.getApplicationHashKey((Context)context));
                httpClientRequest.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
                httpClientRequest.addParams("zdevice", ZaloSDK.Instance.getBaseAppInfo().prepareDeviceIdData().toString());
                httpClientRequest.addParams("ztracking", ZaloSDK.Instance.getBaseAppInfo().prepareTrackingData().toString());
                httpClientRequest.addHeader("gid", ZaloSDK.Instance.getDeviceId());
                jSONObject = httpClientRequest.getJSON();
                if (jSONObject != null && jSONObject.optInt("error", -1) >= 0) {
                    jSONObject = jSONObject.optJSONObject("data");
                    jSONObject.put("error", 0);
                    if (jSONObject != null) {
                        long l = System.currentTimeMillis() + 1800000L;
                        jSONObject.put("expires_in", l);
                        this.d.setAccessTokenNewAPI(jSONObject.toString());
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String a(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i]).append(",");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            return stringBuffer.toString();
        }
        return "";
    }

    public void getProfile(Context context, ZaloOpenAPICallback zaloOpenAPICallback, String[] stringArray) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.GET, this.f);
        httpClientRequest.addParams("fields", this.a(stringArray));
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void getFriendListUsedApp(Context context, int n, int n2, ZaloOpenAPICallback zaloOpenAPICallback, String[] stringArray) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.GET, this.f + "/friends");
        httpClientRequest.addParams("fields", this.a(stringArray));
        httpClientRequest.addParams("offset", n + "");
        httpClientRequest.addParams("limit", n2 + "");
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void getFriendListInvitable(Context context, int n, int n2, ZaloOpenAPICallback zaloOpenAPICallback, String[] stringArray) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.GET, this.f + "/invitable_friends");
        httpClientRequest.addParams("fields", this.a(stringArray));
        httpClientRequest.addParams("offset", n + "");
        httpClientRequest.addParams("limit", n2 + "");
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void setShareZaloUsing(ShareVia shareVia) {
        this.l = shareVia;
    }

    public void setShareZaloChatOnly(boolean bl) {
        this.m = bl;
    }

    public ShareVia getShareZaloUsing() {
        return this.l;
    }

    public void shareFeed(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback) {
        this.c(context, feedData, zaloPluginCallback, "feed", false);
    }

    public void shareMessage(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback) {
        this.c(context, feedData, zaloPluginCallback, "message", false);
    }

    public void share(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback) {
        this.c(context, feedData, zaloPluginCallback, null, false);
    }

    public void shareFeed(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean bl) {
        this.c(context, feedData, zaloPluginCallback, "feed", bl);
    }

    public void shareMessage(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean bl) {
        this.c(context, feedData, zaloPluginCallback, "message", bl);
    }

    public void share(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean bl) {
        this.c(context, feedData, zaloPluginCallback, null, bl);
    }

    private void a(final Context context, final FeedData feedData, final ZaloPluginCallback zaloPluginCallback, final boolean bl) {
        CharSequence[] charSequenceArray = new CharSequence[]{"G\u1eedi tin nh\u1eafn Zalo", "\u0110\u0103ng l\u00ean Zalo"};
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"Ch\u1ecdn");
        builder.setItems(charSequenceArray, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                if (n == 0) {
                    OpenAPIService.this.a(context, feedData, zaloPluginCallback, "message", bl);
                } else {
                    OpenAPIService.this.a(context, feedData, zaloPluginCallback, "feed", bl);
                }
            }
        });
        builder.show();
    }

    private void b(final Context context, final FeedData feedData, final ZaloPluginCallback zaloPluginCallback, final String string, final boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("msg=").append(URLEncoder.encode(feedData.getMsg(), "UTF-8")).append("&");
            stringBuffer.append("link=").append(URLEncoder.encode(feedData.getLink(), "UTF-8")).append("&");
            stringBuffer.append("app_name=").append(URLEncoder.encode(feedData.getAppName(), "UTF-8")).append("&");
            stringBuffer.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                stringBuffer.append("share_to=").append(string).append("&");
            }
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String string2 = packageInfo.versionName;
            stringBuffer.append("app_version=").append(string2).append("&");
            stringBuffer.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            stringBuffer.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("link_title=").append(URLEncoder.encode(feedData.getLinkTitle(), "UTF-8")).append("&");
            stringBuffer2.append("link_desc=").append(URLEncoder.encode(feedData.getLinkDesc(), "UTF-8")).append("&");
            stringBuffer2.append("link_source=").append(URLEncoder.encode(feedData.getLinkSource(), "UTF-8")).append("&");
            if (feedData.getLinkThumb() != null) {
                int n = feedData.getLinkThumb().length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer2.append("link_thumb=").append(URLEncoder.encode(feedData.getLinkThumb()[i], "UTF-8")).append("&");
                }
            }
            if (feedData.getParams() != null) {
                for (Map.Entry<String, String> entry : feedData.getParams().entrySet()) {
                    String string3 = entry.getKey();
                    String string4 = entry.getValue();
                    stringBuffer.append(string3 + "=").append(URLEncoder.encode(string4, "UTF-8")).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", stringBuffer.toString());
            bundle.putString("bodyrequest", stringBuffer2.toString());
            bundle.putString("oauthCodeaa", this.d.getZaloPluginOAuthCode());
            final WebDialog webDialog = new WebDialog.FeedDialogBuilder(context, bundle).build();
            webDialog.setFeedCallBackListener(new ZaloPluginCallback(){

                public void onResult(boolean bl2, int n, String string3, String string2) {
                    webDialog.dismiss();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("type", string);
                    hashMap.put("url", feedData.getLink());
                    hashMap.put("message", feedData.getMsg());
                    hashMap.put("appName", feedData.getAppName());
                    int n2 = 1;
                    if (n != 0) {
                        n2 = -1;
                    }
                    hashMap.put("sent", String.valueOf(n2));
                    hashMap.put("error_code", String.valueOf(n));
                    Utils.addEventZingAnalytics((String)"plugin_share", hashMap);
                    if (n == -10) {
                        OpenAPIService.this.g = true;
                        OpenAPIService.this.a(context, feedData, zaloPluginCallback, string, bl);
                    } else if (n == -1) {
                        OpenAPIService.this.e(context, feedData, zaloPluginCallback, string, bl);
                    } else {
                        OpenAPIService.this.g = false;
                        if (zaloPluginCallback != null) {
                            zaloPluginCallback.onResult(bl2, n, string3, string2);
                        }
                    }
                }
            });
            webDialog.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void c(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String string, boolean bl) {
        if (ZaloSDK.Instance.isAuthenticate(this.d.getZaloPluginOAuthCode(), null)) {
            this.a(context, feedData, zaloPluginCallback, string, bl);
        } else {
            if (LoginChannel.ZALO.toString().equalsIgnoreCase(this.d.getLastestLoginChannel()) && ZaloSDK.Instance.isAuthenticate(null)) {
                this.d.setZaloPluginOAuthCode(this.d.getOAuthCode());
                this.d.setZaloPluginUserId(this.d.getZaloId());
                this.a(context, feedData, zaloPluginCallback, string, bl);
                return;
            }
            this.e(context, feedData, zaloPluginCallback, string, bl);
        }
    }

    protected void a(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String string, boolean bl) {
        this.c = feedData;
        this._shareTo = string;
        this._autoBack = bl;
        if (this.g) {
            this.d(context, feedData, zaloPluginCallback, string, bl);
            return;
        }
        if (this.l == ShareVia.AppThenWeb) {
            if (Utilities.isZaloInstalled((Context)context)) {
                this.d(context, feedData, zaloPluginCallback, string, bl);
            } else {
                this.b(context, feedData, zaloPluginCallback, string, bl);
            }
        } else {
            this.b(context, feedData, zaloPluginCallback, string, bl);
        }
    }

    private void d(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.a(context, feedData, zaloPluginCallback, bl);
        } else {
            boolean bl2;
            Intent intent = this.a(context, feedData, string, bl);
            boolean bl3 = bl2 = intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
            if (bl2) {
                this.c(context);
                this.k = new WeakReference<ZaloPluginCallback>(zaloPluginCallback);
                context.startActivity(intent);
            } else {
                Utilities.invokeMarketApp((Context)context, (String)"com.zing.zalo");
            }
        }
    }

    private Intent b(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent a(Context context, String string, boolean bl) {
        Intent intent = this.b(context);
        intent.addFlags(0x10000000);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", string);
        intent.putExtra("autoBack", bl);
        return intent;
    }

    private void e(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String string, boolean bl) {
        this.c = feedData;
        this.a = new WeakReference<ZaloPluginCallback>(zaloPluginCallback);
        this.b = new WeakReference<Context>(context);
        Intent intent = this.a(context, string, bl);
        context.startActivity(intent);
    }

    private Intent a(Context context, FeedData feedData, String string, boolean bl) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedData.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedData.getLink());
        this.h = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.h);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.equals("feed")) {
                intent.putExtra("postFeed", true);
            } else if (string.equals("message") && this.m) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (bl) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra("backToSource", true);
        return intent;
    }

    private void c(Context context) {
        ZaloPluginCallback zaloPluginCallback;
        if (Utilities.isZaloSupportCallBack((Context)context)) {
            if (!this.j) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.i = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String string = intent.getExtras().getString("result");
                        JSONObject jSONObject = null;
                        try {
                            jSONObject = new JSONObject(string);
                            int n = 0;
                            boolean bl = false;
                            String string2 = null;
                            if (jSONObject != null && jSONObject.has("token") && (string2 = jSONObject.getString("token")) != null && string2.equals(OpenAPIService.this.h)) {
                                HashMap<String, String> hashMap = new HashMap<String, String>();
                                hashMap.put("type", OpenAPIService.this._shareTo);
                                hashMap.put("url", OpenAPIService.this.c.getLink());
                                hashMap.put("message", OpenAPIService.this.c.getMsg());
                                hashMap.put("appName", OpenAPIService.this.c.getAppName());
                                hashMap.put("sent", String.valueOf(jSONObject.getInt("send_action")));
                                n = jSONObject.getInt("error_code");
                                hashMap.put("error_code", String.valueOf(n));
                                Utils.addEventZingAnalytics((String)"plugin_share", hashMap);
                                OpenAPIService.this.d(context);
                                if (OpenAPIService.this.k != null) {
                                    ZaloPluginCallback zaloPluginCallback = (ZaloPluginCallback)OpenAPIService.this.k.get();
                                    if (n == 0) {
                                        bl = true;
                                    }
                                    if (zaloPluginCallback != null) {
                                        zaloPluginCallback.onResult(bl, jSONObject.getInt("error_code"), null, null);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                context.registerReceiver(this.i, intentFilter);
                this.j = true;
            }
        } else if (this.k != null && (zaloPluginCallback = (ZaloPluginCallback)this.k.get()) != null) {
            zaloPluginCallback.onResult(true, 0, null, null);
        }
    }

    private void d(Context context) {
        if (this.i != null) {
            context.unregisterReceiver(this.i);
            this.j = false;
        }
    }

    public void submitEventCancelDialog() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", this._shareTo);
        hashMap.put("url", this.c.getLink());
        hashMap.put("message", this.c.getMsg());
        hashMap.put("appName", this.c.getAppName());
        hashMap.put("sent", "0");
        hashMap.put("error_code", "0");
        Utils.addEventZingAnalytics((String)"plugin_share", hashMap);
    }

    public void inviteFriendUseApp(Context context, String[] stringArray, String string, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.POST, "https://graph.zalo.me/v2.0/apprequests");
        httpClientRequest.addParams("to", this.a(stringArray));
        httpClientRequest.addParams("message", string);
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void postToWall(Context context, String string, String string2, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.POST, "https://graph.zalo.me/v2.0/me/feed");
        httpClientRequest.addParams("link", string);
        httpClientRequest.addParams("message", string2);
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void sendMsgToFriend(Context context, String string, String string2, String string3, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.POST, "https://graph.zalo.me/v2.0/me/message");
        httpClientRequest.addParams("to", string);
        httpClientRequest.addParams("message", string2);
        httpClientRequest.addParams("link", string3);
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void broadcastViaOfficalAccount(Context context, String string, String string2, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.POST, "https://graph.zalo.me/v2.0/oa/message");
        httpClientRequest.addParams("templateid", string);
        httpClientRequest.addParams("templatedata", string2);
        new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    private class NewUserTask
    extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        WeakReference<ZaloOpenAPICallback> b;

        NewUserTask(Context context, WeakReference<ZaloOpenAPICallback> weakReference) {
            this.a = context;
            this.b = weakReference;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject a(HttpClientRequest ... httpClientRequestArray) {
            HttpClientRequest httpClientRequest = httpClientRequestArray[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    return null;
                }
            }
            JSONObject jSONObject = OpenAPIService.this.a(this.a);
            if (jSONObject == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    return null;
                }
            }
            if (jSONObject.has("access_token")) {
                httpClientRequest.addParams("access_token", jSONObject.optString("access_token"));
                return httpClientRequest.getJSON();
            }
            return jSONObject;
        }

        protected void a(JSONObject jSONObject) {
            try {
                if (jSONObject != null) {
                    if (this.b != null && this.b.get() != null) {
                        ((ZaloOpenAPICallback)this.b.get()).onResult(jSONObject);
                    }
                } else if (this.b != null && this.b.get() != null) {
                    ((ZaloOpenAPICallback)this.b.get()).onResult(new JSONObject("{\"error\":-1112}"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((JSONObject)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((HttpClientRequest[])objectArray);
        }
    }
}

