package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog.Builder;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.oauth.WebDialog.FeedDialogBuilder;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenAPIService {
    private static OpenAPIService n;
    public boolean _autoBack;
    public String _shareTo;
    protected WeakReference<ZaloPluginCallback> a;
    protected WeakReference<Context> b;
    protected FeedData c;
    private OauthStorage d;
    private String e;
    private String f;
    private boolean g;
    private String h;
    private BroadcastReceiver i;
    private boolean j;
    private WeakReference<ZaloPluginCallback> k;
    private ShareVia l;
    private boolean m;

    private class NewUserTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        WeakReference<ZaloOpenAPICallback> b;
        final /* synthetic */ OpenAPIService c;

        NewUserTask(OpenAPIService openAPIService, Context context, WeakReference<ZaloOpenAPICallback> weakReference) {
            this.c = openAPIService;
            this.a = context;
            this.b = weakReference;
        }

        protected JSONObject a(HttpClientRequest... httpClientRequestArr) {
            HttpClientRequest httpClientRequest = httpClientRequestArr[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                } catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            JSONObject b = this.c.b(this.a);
            if (b == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                } catch (JSONException e2) {
                    e2.printStackTrace();
                    return null;
                }
            } else if (!b.has("access_token")) {
                return b;
            } else {
                httpClientRequest.addParams("access_token", b.optString("access_token"));
                return httpClientRequest.getJSON();
            }
        }

        protected void a(JSONObject jSONObject) {
            if (jSONObject != null) {
                try {
                    if (this.b != null && this.b.get() != null) {
                        ((ZaloOpenAPICallback) this.b.get()).onResult(jSONObject);
                    }
                } catch (Exception e) {
                }
            } else if (this.b != null && this.b.get() != null) {
                ((ZaloOpenAPICallback) this.b.get()).onResult(new JSONObject("{\"error\":-1112}"));
            }
        }

        protected /* synthetic */ Object doInBackground(Object[] objArr) {
            return a((HttpClientRequest[]) objArr);
        }

        protected /* synthetic */ void onPostExecute(Object obj) {
            a((JSONObject) obj);
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }
    }

    @Deprecated
    private class UserTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context a;
        WeakReference<ZaloOpenAPICallback> b;
        final /* synthetic */ OpenAPIService c;

        UserTask(OpenAPIService openAPIService, Context context, WeakReference<ZaloOpenAPICallback> weakReference) {
            this.c = openAPIService;
            this.a = context;
            this.b = weakReference;
        }

        protected JSONObject a(HttpClientRequest... httpClientRequestArr) {
            HttpClientRequest httpClientRequest = httpClientRequestArr[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                } catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            JSONObject a = this.c.a(this.a);
            if (a == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                } catch (JSONException e2) {
                    e2.printStackTrace();
                    return null;
                }
            } else if (a.optInt("error", -1) < 0) {
                return a;
            } else {
                httpClientRequest.addParams("appid", ZaloSDK.Instance.getAppID() + "");
                httpClientRequest.addParams("accessTok", a.optString("access_token"));
                httpClientRequest.addParams("version", "3");
                return httpClientRequest.getJSON();
            }
        }

        protected void a(JSONObject jSONObject) {
            if (jSONObject != null) {
                try {
                    if (this.b != null && this.b.get() != null) {
                        ((ZaloOpenAPICallback) this.b.get()).onResult(jSONObject);
                    }
                } catch (Exception e) {
                }
            } else if (this.b != null && this.b.get() != null) {
                ((ZaloOpenAPICallback) this.b.get()).onResult(new JSONObject("{\"error\":-1112}"));
            }
        }

        protected /* synthetic */ Object doInBackground(Object[] objArr) {
            return a((HttpClientRequest[]) objArr);
        }

        protected /* synthetic */ void onPostExecute(Object obj) {
            a((JSONObject) obj);
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }
    }

    OpenAPIService() {
        this.d = null;
        this.e = "http://openapi.zaloapp.com/query";
        this.f = "https://graph.zalo.me/v2.0/me";
        this.g = false;
        this._shareTo = "";
        this._autoBack = false;
        this.h = "";
        this.j = false;
        this.l = ShareVia.AppThenWeb;
        this.m = false;
        this.d = ZaloSDK.Instance.getOauthStorage();
    }

    private Intent a(Context context, FeedData feedData, String str, boolean z) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedData.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedData.getLink());
        this.h = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.h);
        if (!TextUtils.isEmpty(str)) {
            if (str.equals("feed")) {
                intent.putExtra("postFeed", true);
            } else if (str.equals("message") && this.m) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        if (z) {
            intent.putExtra("autoBack2S", true);
        }
        intent.putExtra("backToSource", true);
        return intent;
    }

    private Intent a(Context context, String str, boolean z) {
        Intent c = c(context);
        c.addFlags(268435456);
        c.putExtra("login_from_share_feed", true);
        c.putExtra("share_to", str);
        c.putExtra("autoBack", z);
        return c;
    }

    private String a(String[] strArr) {
        if (strArr == null || strArr.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < strArr.length - 1; i++) {
            stringBuffer.append(strArr[i]).append(",");
        }
        stringBuffer.append(strArr[strArr.length - 1]);
        return stringBuffer.toString();
    }

    @Deprecated
    private JSONObject a(Context context) {
        JSONObject jSONObject = null;
        try {
            JSONObject jSONObject2 = new JSONObject(this.d.getAccessToken());
            try {
                if (jSONObject2.getLong("expires_in") >= System.currentTimeMillis()) {
                    jSONObject = jSONObject2;
                }
            } catch (Exception e) {
                jSONObject = jSONObject2;
            }
        } catch (Exception e2) {
        }
        if (jSONObject == null) {
            try {
                HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://oauth.zaloapp.com/v2/mobile/access_token");
                httpClientRequest.addParams("code", ZaloSDK.Instance.getOAuthCode());
                httpClientRequest.addParams("pkg_name", AppInfo.getPackageName(context));
                httpClientRequest.addParams("sign_key", AppInfo.getApplicationHashKey(context));
                httpClientRequest.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
                jSONObject = httpClientRequest.getJSON();
                if (jSONObject != null && jSONObject.optInt("error", -1) >= 0) {
                    jSONObject = jSONObject.optJSONObject("data");
                    jSONObject.put("error", 0);
                    if (jSONObject != null) {
                        jSONObject.put("expires_in", System.currentTimeMillis() + 1800000);
                        this.d.setAccessToken(jSONObject.toString());
                    }
                }
            } catch (JSONException e3) {
            }
        }
        return jSONObject;
    }

    private void a(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean z) {
        CharSequence[] charSequenceArr = new CharSequence[]{"Gửi tin nhắn Zalo", "Đăng lên Zalo"};
        Builder builder = new Builder(context);
        builder.setTitle("Chọn");
        final Context context2 = context;
        final FeedData feedData2 = feedData;
        final ZaloPluginCallback zaloPluginCallback2 = zaloPluginCallback;
        final boolean z2 = z;
        builder.setItems(charSequenceArr, new OnClickListener(this) {
            final /* synthetic */ OpenAPIService e;

            public void onClick(DialogInterface dialogInterface, int i) {
                if (i == 0) {
                    this.e.a(context2, feedData2, zaloPluginCallback2, "message", z2);
                } else {
                    this.e.a(context2, feedData2, zaloPluginCallback2, "feed", z2);
                }
            }
        });
        builder.show();
    }

    private JSONObject b(Context context) {
        JSONObject jSONObject = null;
        try {
            JSONObject jSONObject2 = new JSONObject(this.d.getAccessTokenNewAPI());
            try {
                if (jSONObject2.getLong("expires_in") >= System.currentTimeMillis()) {
                    jSONObject = jSONObject2;
                }
            } catch (Exception e) {
                jSONObject = jSONObject2;
            }
        } catch (Exception e2) {
        }
        if (jSONObject == null) {
            try {
                HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://oauth.zaloapp.com/v3/mobile/access_token");
                httpClientRequest.addParams("code", ZaloSDK.Instance.getOAuthCode());
                httpClientRequest.addParams("pkg_name", AppInfo.getPackageName(context));
                httpClientRequest.addParams("sign_key", AppInfo.getApplicationHashKey(context));
                httpClientRequest.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
                jSONObject = httpClientRequest.getJSON();
                if (jSONObject != null && jSONObject.optInt("error", -1) >= 0) {
                    jSONObject = jSONObject.optJSONObject("data");
                    jSONObject.put("error", 0);
                    if (jSONObject != null) {
                        jSONObject.put("expires_in", System.currentTimeMillis() + 1800000);
                        this.d.setAccessTokenNewAPI(jSONObject.toString());
                    }
                }
            } catch (JSONException e3) {
            }
        }
        return jSONObject;
    }

    private void b(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String str, boolean z) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("msg=").append(URLEncoder.encode(feedData.getMsg(), "UTF-8")).append("&");
            stringBuffer.append("link=").append(URLEncoder.encode(feedData.getLink(), "UTF-8")).append("&");
            stringBuffer.append("app_name=").append(URLEncoder.encode(feedData.getAppName(), "UTF-8")).append("&");
            stringBuffer.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty(str)) {
                stringBuffer.append("share_to=").append(str).append("&");
            }
            stringBuffer.append("app_version=").append(context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName).append("&");
            stringBuffer.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            stringBuffer.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("link_title=").append(URLEncoder.encode(feedData.getLinkTitle(), "UTF-8")).append("&");
            stringBuffer2.append("link_desc=").append(URLEncoder.encode(feedData.getLinkDesc(), "UTF-8")).append("&");
            stringBuffer2.append("link_source=").append(URLEncoder.encode(feedData.getLinkSource(), "UTF-8")).append("&");
            if (feedData.getLinkThumb() != null) {
                for (String encode : feedData.getLinkThumb()) {
                    stringBuffer2.append("link_thumb=").append(URLEncoder.encode(encode, "UTF-8")).append("&");
                }
            }
            if (feedData.getParams() != null) {
                for (Entry entry : feedData.getParams().entrySet()) {
                    stringBuffer.append(((String) entry.getKey()) + "=").append(URLEncoder.encode((String) entry.getValue(), "UTF-8")).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", stringBuffer.toString());
            bundle.putString("bodyrequest", stringBuffer2.toString());
            bundle.putString("oauthCodeaa", this.d.getZaloPluginOAuthCode());
            final WebDialog build = new FeedDialogBuilder(context, bundle).build();
            final String str2 = str;
            final FeedData feedData2 = feedData;
            final Context context2 = context;
            final ZaloPluginCallback zaloPluginCallback2 = zaloPluginCallback;
            final boolean z2 = z;
            build.setFeedCallBackListener(new ZaloPluginCallback(this) {
                final /* synthetic */ OpenAPIService g;

                public void onResult(boolean z, int i, String str, String str2) {
                    build.dismiss();
                    Map hashMap = new HashMap();
                    hashMap.put("type", str2);
                    hashMap.put("url", feedData2.getLink());
                    hashMap.put("message", feedData2.getMsg());
                    hashMap.put("appName", feedData2.getAppName());
                    hashMap.put("sent", String.valueOf(i != 0 ? -1 : 1));
                    hashMap.put("error_code", String.valueOf(i));
                    Utils.addEventZingAnalytics("plugin_share", hashMap);
                    if (i == -10) {
                        this.g.g = true;
                        this.g.a(context2, feedData2, zaloPluginCallback2, str2, z2);
                    } else if (i == -1) {
                        this.g.e(context2, feedData2, zaloPluginCallback2, str2, z2);
                    } else {
                        this.g.g = false;
                        if (zaloPluginCallback2 != null) {
                            zaloPluginCallback2.onResult(z, i, str, str2);
                        }
                    }
                }
            });
            build.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Intent c(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private void c(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String str, boolean z) {
        if (ZaloSDK.Instance.isAuthenticate(this.d.getZaloPluginOAuthCode(), null)) {
            a(context, feedData, zaloPluginCallback, str, z);
        } else if (LoginChannel.ZALO.toString().equalsIgnoreCase(this.d.getLastestLoginChannel()) && ZaloSDK.Instance.isAuthenticate(null)) {
            this.d.setZaloPluginOAuthCode(this.d.getOAuthCode());
            this.d.setZaloPluginUserId(this.d.getZaloId());
            a(context, feedData, zaloPluginCallback, str, z);
        } else {
            e(context, feedData, zaloPluginCallback, str, z);
        }
    }

    private void d(Context context) {
        if (Utilities.isZaloSupportCallBack(context)) {
            if (!this.j) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.i = new BroadcastReceiver(this) {
                    final /* synthetic */ OpenAPIService a;

                    {
                        this.a = r1;
                    }

                    public void onReceive(Context context, Intent intent) {
                        try {
                            JSONObject jSONObject = new JSONObject(intent.getExtras().getString("result"));
                            boolean z = false;
                            if (jSONObject != null && jSONObject.has("token")) {
                                String string = jSONObject.getString("token");
                                if (string != null && string.equals(this.a.h)) {
                                    Map hashMap = new HashMap();
                                    hashMap.put("type", this.a._shareTo);
                                    hashMap.put("url", this.a.c.getLink());
                                    hashMap.put("message", this.a.c.getMsg());
                                    hashMap.put("appName", this.a.c.getAppName());
                                    hashMap.put("sent", String.valueOf(jSONObject.getInt("send_action")));
                                    int i = jSONObject.getInt("error_code");
                                    hashMap.put("error_code", String.valueOf(i));
                                    Utils.addEventZingAnalytics("plugin_share", hashMap);
                                    this.a.e(context);
                                    if (this.a.k != null) {
                                        ZaloPluginCallback zaloPluginCallback = (ZaloPluginCallback) this.a.k.get();
                                        if (i == 0) {
                                            z = true;
                                        }
                                        if (zaloPluginCallback != null) {
                                            zaloPluginCallback.onResult(z, jSONObject.getInt("error_code"), null, null);
                                        }
                                    }
                                }
                            }
                        } catch (Exception e) {
                        }
                    }
                };
                context.registerReceiver(this.i, intentFilter);
                this.j = true;
            }
        } else if (this.k != null) {
            ZaloPluginCallback zaloPluginCallback = (ZaloPluginCallback) this.k.get();
            if (zaloPluginCallback != null) {
                zaloPluginCallback.onResult(true, 0, null, null);
            }
        }
    }

    private void d(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String str, boolean z) {
        int i = 0;
        if (TextUtils.isEmpty(str)) {
            a(context, feedData, zaloPluginCallback, z);
            return;
        }
        Intent a = a(context, feedData, str, z);
        if (a.resolveActivityInfo(context.getPackageManager(), 0) != null) {
            i = 1;
        }
        if (i != 0) {
            d(context);
            this.k = new WeakReference(zaloPluginCallback);
            context.startActivity(a);
            return;
        }
        Utilities.invokeMarketApp(context, "com.zing.zalo");
    }

    private void e(Context context) {
        if (this.i != null) {
            context.unregisterReceiver(this.i);
            this.j = false;
        }
    }

    private void e(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String str, boolean z) {
        this.c = feedData;
        this.a = new WeakReference(zaloPluginCallback);
        this.b = new WeakReference(context);
        context.startActivity(a(context, str, z));
    }

    public static OpenAPIService getInstance() {
        if (n == null) {
            n = new OpenAPIService();
        }
        return n;
    }

    protected void a(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, String str, boolean z) {
        this.c = feedData;
        this._shareTo = str;
        this._autoBack = z;
        if (this.g) {
            d(context, feedData, zaloPluginCallback, str, z);
        } else if (this.l != ShareVia.AppThenWeb) {
            b(context, feedData, zaloPluginCallback, str, z);
        } else if (Utilities.isZaloInstalled(context)) {
            d(context, feedData, zaloPluginCallback, str, z);
        } else {
            b(context, feedData, zaloPluginCallback, str, z);
        }
    }

    public void broadcastViaOfficalAccount(Context context, String str, String str2, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://graph.zalo.me/v2.0/oa/message");
        httpClientRequest.addParams("templateid", str);
        httpClientRequest.addParams("templatedata", str2);
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    @Deprecated
    public void getFriendList(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, this.e);
        httpClientRequest.addParams("act", "lstfri");
        httpClientRequest.addParams("pos", i + "");
        httpClientRequest.addParams("count", i2 + "");
        new UserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void getFriendListInvitable(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, this.f + "/invitable_friends");
        httpClientRequest.addParams("fields", a(strArr));
        httpClientRequest.addParams("offset", i + "");
        httpClientRequest.addParams("limit", i2 + "");
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void getFriendListUsedApp(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, this.f + "/friends");
        httpClientRequest.addParams("fields", a(strArr));
        httpClientRequest.addParams("offset", i + "");
        httpClientRequest.addParams("limit", i2 + "");
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    @Deprecated
    public void getProfile(Context context, ZaloOpenAPICallback zaloOpenAPICallback) {
        new HttpClientRequest(Type.GET, this.e).addParams("act", "profile");
        new UserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{r0});
    }

    public void getProfile(Context context, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr) {
        new HttpClientRequest(Type.GET, this.f).addParams("fields", a(strArr));
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{r0});
    }

    public ShareVia getShareZaloUsing() {
        return this.l;
    }

    public void inviteFriendUseApp(Context context, String[] strArr, String str, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://graph.zalo.me/v2.0/apprequests");
        httpClientRequest.addParams("to", a(strArr));
        httpClientRequest.addParams("message", str);
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void postToWall(Context context, String str, String str2, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://graph.zalo.me/v2.0/me/feed");
        httpClientRequest.addParams("link", str);
        httpClientRequest.addParams("message", str2);
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void sendMsgToFriend(Context context, String str, String str2, String str3, ZaloOpenAPICallback zaloOpenAPICallback) {
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://graph.zalo.me/v2.0/me/message");
        httpClientRequest.addParams("to", str);
        httpClientRequest.addParams("message", str2);
        httpClientRequest.addParams("link", str3);
        new NewUserTask(this, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void setShareZaloChatOnly(boolean z) {
        this.m = z;
    }

    public void setShareZaloUsing(ShareVia shareVia) {
        this.l = shareVia;
    }

    public void share(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback) {
        c(context, feedData, zaloPluginCallback, null, false);
    }

    public void share(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean z) {
        c(context, feedData, zaloPluginCallback, null, z);
    }

    public void shareFeed(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback) {
        c(context, feedData, zaloPluginCallback, "feed", false);
    }

    public void shareFeed(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean z) {
        c(context, feedData, zaloPluginCallback, "feed", z);
    }

    public void shareMessage(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback) {
        c(context, feedData, zaloPluginCallback, "message", false);
    }

    public void shareMessage(Context context, FeedData feedData, ZaloPluginCallback zaloPluginCallback, boolean z) {
        c(context, feedData, zaloPluginCallback, "message", z);
    }

    public void submitEventCancelDialog() {
        Map hashMap = new HashMap();
        hashMap.put("type", this._shareTo);
        hashMap.put("url", this.c.getLink());
        hashMap.put("message", this.c.getMsg());
        hashMap.put("appName", this.c.getAppName());
        hashMap.put("sent", "0");
        hashMap.put("error_code", "0");
        Utils.addEventZingAnalytics("plugin_share", hashMap);
    }
}
