/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.zing.zalo.zalosdk.auth.internal.j;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.ZTaskExecutor;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.oauth.GetZaloLoginStatus;
import com.zing.zalo.zalosdk.oauth.LocalizedString;
import com.zing.zalo.zalosdk.oauth.LoginChannel;
import com.zing.zalo.zalosdk.oauth.LoginVia;
import com.zing.zalo.zalosdk.oauth.OAuthCompleteListener;
import com.zing.zalo.zalosdk.oauth.OauthResponse;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.Permissions;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.ValidateOAuthCodeCallback;
import com.zing.zalo.zalosdk.oauth.WebLoginActivity;
import com.zing.zalo.zalosdk.oauth.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import com.zing.zalo.zalosdk.oauth.ZaloSDKApplication;
import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;
import com.zing.zalo.zalosdk.payment.direct.Utils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import org.json.JSONObject;

public class Authenticator {
    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;
    static boolean isGetZaloOAuth = false;
    private boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    private boolean zaloPluginLogin = false;
    public String nameActivtyCheckAuthen = "";
    public BroadcastReceiver receiver = new BroadcastReceiver(this){
        final /* synthetic */ Authenticator a;
        {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void onReceive(Context context, Intent intent) {
            if ("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP".equals(intent.getAction())) {
                void var2_2;
                Authenticator.access$002(this.a, var2_2.getBooleanExtra("loginSuccessful", false));
            }
        }
    };
    private OauthStorage mStorage;
    private LocalizedString mLocalizedString;
    protected Context mContext;

    /*
     * WARNING - void declaration
     */
    Authenticator(Context ctx, OauthStorage storage, LocalizedString localizedString) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mContext = var1_1;
        this.mStorage = var2_2;
        this.mLocalizedString = var3_3;
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        if (this.wListener != null && this.wListener.get() != null) {
            return (OAuthCompleteListener)this.wListener.get();
        }
        return new OAuthCompleteListener();
    }

    /*
     * WARNING - void declaration
     */
    public void setOAuthCompleteListener(OAuthCompleteListener listener) {
        void var1_1;
        this.wListener = new WeakReference<void>(var1_1);
    }

    protected OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        if (this.wLoginFormListener != null && this.wLoginFormListener.get() != null) {
            return (OAuthCompleteListener)this.wLoginFormListener.get();
        }
        return new OAuthCompleteListener();
    }

    /*
     * WARNING - void declaration
     */
    protected void setLoginFormOAuthCompleteListener(OAuthCompleteListener listener) {
        void var1_1;
        this.wLoginFormListener = new WeakReference<void>(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void authenticate(Activity activity, LoginVia loginVia, boolean zaloPluginLogin, OAuthCompleteListener listener) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        this.setOAuthCompleteListener(listener);
        this.zaloPluginLogin = var3_3;
        this.sendOAuthRequest((Activity)var1_1, (LoginVia)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void registerZalo(Activity activity, OAuthCompleteListener listener) {
        void var2_2;
        void var1_1;
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        this.setOAuthCompleteListener(listener);
        Intent intent = WebLoginActivity.a((Context)activity, true);
        var1_1.startActivityForResult((Intent)var2_2, 64725);
    }

    /*
     * WARNING - void declaration
     */
    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        void var2_2;
        boolean isZaloInstalled = AppInfo.isPackageExists((Context)activity, (String)"com.zing.zalo");
        switch (4.a[var2_2.ordinal()]) {
            case 1: {
                if (isZaloInstalled) {
                    this.loginViaApp(activity);
                    return;
                }
                this.getOAuthCompleteListener().onZaloNotInstalled((Context)activity);
                return;
            }
            case 2: {
                this.loginViaWeb(activity);
                return;
            }
            case 3: {
                void var1_1;
                void var3_3;
                if (var3_3 != false) {
                    if (SettingsManager.getInstance().isUseWebViewUnLoginZalo(this.mContext)) {
                        this.loginViaAppOrWebIfNotLogin(activity);
                        return;
                    }
                    this.loginViaApp(activity);
                    return;
                }
                this.loginViaWeb((Activity)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loginViaAppOrWebIfNotLogin(Activity activity) {
        void var1_1;
        this.getZaloLoginStatus(new GetZaloLoginStatus(this, (Activity)var1_1){
            final /* synthetic */ Activity a;
            final /* synthetic */ Authenticator b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = activity;
            }

            @Override
            public final void onGetZaloLoginStatusCompleted(int status) {
                if (status == 1) {
                    Authenticator.access$100(this.b, this.a);
                    return;
                }
                Authenticator.access$200(this.b, this.a);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void loginViaApp(Activity activity) {
        try {
            void var2_2;
            try {
                activity.unregisterReceiver(this.receiver);
            }
            catch (Exception exception) {
                Log.v((String)exception.toString());
            }
            IntentFilter intentFilter = new IntentFilter("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP");
            activity.registerReceiver(this.receiver, intentFilter);
            Intent i2 = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
            i2.putExtra("android.intent.extra.UID", (Serializable)AppInfo.getAppIdLong((Context)this.mContext));
            activity.startActivityForResult((Intent)var2_2, 64725);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            this.bIsZaloOutOfDate = true;
            this.getOAuthCompleteListener().onZaloOutOfDate((Context)activity);
            return;
        }
        catch (SecurityException securityException) {
            void var1_1;
            this.bIsZaloOutOfDate = true;
            this.getOAuthCompleteListener().onZaloOutOfDate((Context)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loginViaWeb(Activity activity) {
        void var1_1;
        if (!Utilities.a((Context)activity)) {
            this.getOAuthCompleteListener().onAuthenError(-1021, this.mLocalizedString.getNoNetworkMessage());
            return;
        }
        if (Utilities.b((Context)activity)) {
            this.loginViaBrowser(activity);
            return;
        }
        this.loginViaWebView((Activity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void loginViaBrowser(Activity activity) {
        void var3_4;
        void var1_1;
        void var2_2;
        StringBuilder url = new StringBuilder();
        url.append(ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/auth?app_id="));
        try {
            url.append(ZaloSDK.Instance.getAppID()).append("&sign_key=").append(URLEncoder.encode(AppInfo.getApplicationHashKey((Context)activity), "UTF-8")).append("&pkg_name=").append(URLEncoder.encode(AppInfo.getPackageName((Context)activity), "UTF-8")).append("&orientation=").append(activity.getResources().getConfiguration().orientation).append("&ts=").append(System.currentTimeMillis()).append("&lang=").append(Utils.getLanguage((Context)activity)).append("&ref=zsdk");
        }
        catch (UnsupportedEncodingException e2) {
            this.getOAuthCompleteListener().onAuthenError(-1020, e2.getMessage());
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)var2_2.toString()));
        var1_1.startActivity((Intent)var3_4);
    }

    private boolean checkCookieManagerSupport() {
        try {
            CookieManager.getInstance();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loginViaWebView(Activity activity) {
        void var2_2;
        void var1_1;
        if (!this.checkCookieManagerSupport()) {
            this.getOAuthCompleteListener().onAuthenError(-1020, "Webview does not support login!");
            return;
        }
        Intent intent = WebLoginActivity.a((Context)activity, false);
        var1_1.startActivityForResult((Intent)var2_2, 64725);
    }

    /*
     * WARNING - void declaration
     */
    protected void unauthenticate() {
        try {
            void var1_1;
            long uid = ZaloSDK.Instance.getZaloId();
            this.mContext.getSharedPreferences("zacPref", 0).edit().remove("MAX_PAGING" + uid).remove("GIFTCODE_EXPIRED_TIME" + uid).remove("CACHE_CODE_LIST" + uid).remove("CURRENT_PAGE" + (long)var1_1).apply();
            this.mStorage.setAccessToken("");
            this.mStorage.setAccessTokenNewAPI("");
            this.mStorage.setOAuthCode("", "");
            this.mStorage.setZaloId(0L);
            this.mStorage.setZaloDisplayName("");
            this.mStorage.setZaloPluginOAuthCode("");
            this.mStorage.setSocialId("");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isAuthenticate(String code, ValidateOAuthCodeCallback callback) {
        if (code == null || code.length() == 0) {
            if (callback != null) {
                callback.onValidateComplete(false, -1019, -1L, null);
            }
            return false;
        }
        if (callback != null) {
            void var2_2;
            void var1_1;
            new a((String)var1_1, (ValidateOAuthCodeCallback)var2_2).execute(new Void[0]);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        void var2_2;
        if (requestCode == 64725) {
            this.receiveOAuthData(activity, data);
            return true;
        }
        if (var2_2 == 64726) {
            void var1_1;
            this.receivePermissionData((Activity)var1_1, data);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void receiveOAuthData(Activity activity, Intent data) {
        ErrorResponse erResponse;
        OauthResponse resp;
        int isRegister;
        String oauth;
        isGetZaloOAuth = false;
        try {
            activity.unregisterReceiver(this.receiver);
        }
        catch (Exception exception) {}
        if (this.bIsZaloOutOfDate) {
            return;
        }
        this.mStorage.setAccessToken("");
        this.mStorage.setAccessTokenNewAPI("");
        if (data == null) {
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(this.mContext, -1111);
            ErrorResponse erResponse2 = new ErrorResponse(-1111, errorMsg, "", "", "web_login");
            this.getOAuthCompleteListener().onAuthenError(-1111, errorMsg);
            this.getOAuthCompleteListener().onAuthenError(-1111, errorMsg, erResponse2);
            return;
        }
        int error = data.getIntExtra("error", 0);
        if (error == 203) {
            this.getOAuthCompleteListener().onAuthenError(-1118, "Kh\u00f4ng th\u1ec3 \u0111\u0103ng nh\u1eadp Zalo.");
            return;
        }
        if (error == 0) {
            long id2 = data.getLongExtra("uid", 0L);
            oauth = data.getStringExtra("code");
            isRegister = data.getBooleanExtra("isRegister", false);
            if (this.zaloPluginLogin) {
                this.mStorage.setZaloPluginOAuthCode(oauth);
                this.mStorage.setZaloPluginUserId(id2);
            }
            if (this.zaloPluginLogin && TextUtils.isEmpty((CharSequence)this.mStorage.getOAuthCode()) || !this.zaloPluginLogin) {
                this.mStorage.setOAuthCode(LoginChannel.ZALO.toString(), oauth);
                this.mStorage.setZaloId(id2);
                try {
                    String jsData = data.getStringExtra("data");
                    JSONObject exData = new JSONObject(jsData).getJSONObject("data");
                    String displayname = exData.getString("display_name");
                    int zprotect = exData.optInt("zprotect");
                    this.mStorage.setIsProtected(zprotect);
                    this.mStorage.setZaloDisplayName(displayname);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            resp = new OauthResponse(id2, oauth, LoginChannel.ZALO);
            resp.setRegister(isRegister != 0);
            this.getOAuthCompleteListener().onGetOAuthComplete(resp);
            return;
        }
        if (isRegister == 4) {
            if (this.bIsZaloLoginSuccessful) {
                this.authenticate((Activity)oauth, LoginVia.APP, this.zaloPluginLogin, this.getOAuthCompleteListener());
                return;
            }
            this.getOAuthCompleteListener().onAuthenError(-1111, "");
            return;
        }
        if (isRegister == 3 || isRegister == 2) {
            int e2 = ZaloOAuthResultCode.findById(isRegister);
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(this.mContext, isRegister);
            erResponse = new ErrorResponse(e2, errorMsg, "", "", "app");
            this.getOAuthCompleteListener().onAuthenError(e2, errorMsg);
            this.getOAuthCompleteListener().onAuthenError(e2, errorMsg, erResponse);
            return;
        }
        int e3 = ZaloOAuthResultCode.findById(isRegister);
        String errorMsg = "Kh\u00f4ng th\u1ec3 \u0111\u0103ng nh\u1eadp Zalo.";
        try {
            String jsData = resp.getStringExtra("data");
            if (!TextUtils.isEmpty((CharSequence)jsData)) {
                void var1_1;
                void var2_2;
                void var3_11;
                JSONObject exData = new JSONObject(jsData);
                JSONObject extraData = new JSONObject(var3_11.getString("data"));
                String msg = extraData.getString("errorMsg");
                if (!TextUtils.isEmpty((CharSequence)msg)) {
                    errorMsg = msg;
                }
                String errorDescription = extraData.getString("error_description");
                String errorReason = extraData.getString("error_reason");
                String fromSource = var2_2.getString("from_source");
                erResponse = new ErrorResponse(e3, errorMsg, errorReason, errorDescription, fromSource);
                this.getOAuthCompleteListener().onAuthenError(e3, errorMsg, (ErrorResponse)var1_1);
            }
        }
        catch (Exception exception) {
            errorMsg = exception.toString();
            Log.v((String)errorMsg);
        }
        this.getOAuthCompleteListener().onAuthenError(e3, errorMsg);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkZaloVersionSupport(Context ctx, int versionCode) {
        try {
            void var2_2;
            if (ctx.getPackageManager().getPackageInfo((String)"com.zing.zalo", (int)0).versionCode < var2_2) {
                isGetZaloOAuth = false;
                this.bIsZaloOutOfDate = true;
                this.getOAuthCompleteListener().onZaloOutOfDate(ctx);
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            void var1_1;
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            this.getOAuthCompleteListener().onZaloOutOfDate((Context)var1_1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    void requestPermissions(Activity activity, Enum<Permissions> permission2, OAuthCompleteListener listener) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (!this.checkZaloVersionSupport((Context)activity, 90)) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.setOAuthCompleteListener(listener);
        Context ctx = activity.getApplicationContext();
        Intent i2 = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
        i2.putExtra("app_id", "" + ZaloSDK.Instance.getAppID());
        i2.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
        i2.putExtra("pkg_name", AppInfo.getPackageName((Context)ctx));
        i2.putExtra("sign_key", AppInfo.getApplicationHashKey((Context)var3_3));
        i2.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
        i2.putExtra("permission", var2_2.toString());
        var1_1.startActivityForResult(i2, 64726);
    }

    /*
     * WARNING - void declaration
     */
    void receivePermissionData(Activity activity, Intent data) {
        if (data != null) {
            void var1_2;
            void var2_3;
            int e2 = ZaloOAuthResultCode.findById(var2_3.getIntExtra("error", 0));
            this.getOAuthCompleteListener().onGetPermissionData((int)var1_2);
            return;
        }
        this.getOAuthCompleteListener().onGetPermissionData(-1111);
    }

    /*
     * WARNING - void declaration
     */
    void getZaloLoginStatus(GetZaloLoginStatus callback) {
        void var1_1;
        if (callback == null) {
            return;
        }
        ZTaskExecutor.queueRunnable((Runnable)new Runnable(this, (GetZaloLoginStatus)var1_1){
            final /* synthetic */ GetZaloLoginStatus a;
            final /* synthetic */ Authenticator b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = getZaloLoginStatus;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void run() {
                j service = new j();
                Handler handler = new Handler(Looper.getMainLooper());
                try {
                    void var1_2;
                    int status = service.a(this.b.mContext);
                    handler.post(new Runnable(this, (int)var1_2){
                        final /* synthetic */ int a;
                        final /* synthetic */ 3 b;
                        {
                            void var1_1;
                            this.b = var1_1;
                            this.a = n;
                        }

                        @Override
                        public final void run() {
                            this.b.a.onGetZaloLoginStatusCompleted(this.a);
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    void var2_3;
                    Log.e((Exception)exception);
                    var2_3.post(new Runnable(this){
                        final /* synthetic */ 3 a;
                        {
                            void var1_1;
                            this.a = var1_1;
                        }

                        @Override
                        public final void run() {
                            this.a.a.onGetZaloLoginStatusCompleted(-1);
                        }
                    });
                    return;
                }
            }
        });
    }

    public OauthStorage getStorage() {
        return this.mStorage;
    }

    public void resetListener() {
        this.wListener = null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(Authenticator x0, boolean x1) {
        void var1_1;
        x0.bIsZaloLoginSuccessful = var1_1;
        return x0.bIsZaloLoginSuccessful;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Authenticator x0, Activity x1) {
        void var1_1;
        x0.loginViaApp((Activity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Authenticator x0, Activity x1) {
        void var1_1;
        x0.loginViaWeb((Activity)var1_1);
    }

    final class a
    extends AsyncTask<Void, Void, String> {
        ValidateOAuthCodeCallback a;
        String b;

        /*
         * WARNING - void declaration
         */
        a(String code, ValidateOAuthCodeCallback callback) {
            void var2_2;
            void var3_3;
            if (callback == null) {
                throw new IllegalArgumentException("callback can't be null");
            }
            this.a = var3_3;
            this.b = var2_2;
        }

        protected final /* synthetic */ void onPostExecute(Object object) {
            String string = (String)object;
            object = this;
            super.onPostExecute((Object)string);
            try {
                string = new JSONObject(string);
                int n = string.getInt("error");
                if (n == 0) {
                    long l = (string = string.getJSONObject("data")).getLong("uid");
                    if (l == ((a)((Object)object)).Authenticator.this.mStorage.getZaloId()) {
                        n = string.optInt("zcert");
                        int n2 = string.optInt("zprotect");
                        ((a)((Object)object)).Authenticator.this.mStorage.setIsGuestCertificated(n);
                        ((a)((Object)object)).Authenticator.this.mStorage.setIsProtected(n2);
                    }
                    ((a)((Object)object)).a.onValidateComplete(true, 0, l, ((a)((Object)object)).b);
                    return;
                }
                ((a)((Object)object)).a.onValidateComplete(false, n, -1L, null);
                return;
            }
            catch (Exception exception) {
                ((a)((Object)object)).a.onValidateComplete(false, -1000, -1L, null);
                return;
            }
        }

        protected final /* synthetic */ Object doInBackground(Object[] object) {
            object = this;
            HttpClientRequest httpClientRequest = new HttpClientRequest(HttpClientRequest.Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v2/mobile/validate_oauth_code"));
            httpClientRequest.addParams("app_id", String.valueOf(ZaloSDKApplication.appID));
            httpClientRequest.addParams("code", object.b);
            httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
            httpClientRequest.addParams("frm", "sdk");
            return httpClientRequest.getText();
        }
    }
}

