/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.c;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class WebDialog
extends Dialog {
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String UTF8 = "UTF-8";
    private static final String LOG_TAG = "WebDialog";
    private static final String DISPLAY_TOUCH = "touch";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 0xFFFFFF;
    public static final int DEFAULT_THEME = 0x1030010;
    private String url;
    private String query;
    private String queryBody;
    private String code;
    private OnCompleteListener onCompleteListener;
    ZaloPluginCallback zFeedCallback;
    private WebView webView;
    private c spinner;
    private ImageView crossImageView;
    private FrameLayout contentFrameLayout;
    private boolean listenerCalled = false;
    private boolean isDetached = false;
    private boolean isDismissed = false;
    CookieSyncManager cookieSyncManager;
    CookieManager cookieManager;
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    int oldWidth = 0;
    OrientationEventListener myOrientationEventListener;

    /*
     * WARNING - void declaration
     */
    public WebDialog(Context context, String url) {
        this((Context)var1_1, (String)var2_2, 0x1030010);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebDialog(Context context, String url, int theme) {
        super((Context)var1_1, (int)var3_3);
        void var2_2;
        void var3_3;
        void var1_1;
        this.url = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public WebDialog(Context context, String action, Bundle parameters, int theme, OnCompleteListener listener) {
        super((Context)var1_1, theme);
        void var3_3;
        void var1_1;
        if (parameters == null) {
            parameters = new Bundle();
        }
        this.query = parameters.getString(EXTRA_QUERY);
        this.queryBody = parameters.getString(EXTRA_REQUEST_BODY);
        this.query = this.query == null ? "" : this.query;
        this.code = var3_3.getString(EXTRA_OAUTH_CODE);
        this.url = "https://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setFeedCallBackListener(ZaloPluginCallback callback) {
        void var1_1;
        this.zFeedCallback = var1_1;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void dismiss() {
        if (this.isDismissed) {
            return;
        }
        this.isDismissed = true;
        if (this.myOrientationEventListener != null) {
            this.myOrientationEventListener.disable();
        }
        if (!this.listenerCalled) {
            this.sendCancelToListener();
        }
        if (this.webView != null) {
            this.webView.stopLoading();
        }
        if (!this.isDetached) {
            if (this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
            super.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        super.onAttachedToWindow();
    }

    /*
     * WARNING - void declaration
     */
    protected void onCreate(Bundle savedInstanceState) {
        void var1_1;
        super.onCreate(savedInstanceState);
        this.spinner = new c(this.getContext(), new c.a(this){
            final /* synthetic */ WebDialog this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void onClose() {
            }
        });
        this.spinner.requestWindowFeature(1);
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(this){
            final /* synthetic */ WebDialog this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onCancel(DialogInterface dialogInterface) {
                this.this$0.dismiss();
            }
        });
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.calculateSize();
        this.getWindow().setGravity(17);
        this.getWindow().setSoftInputMode(16);
        this.createCrossImage();
        this.crossImageView.getDrawable().getIntrinsicWidth();
        this.setUpWebView(0);
        ViewGroup.LayoutParams param = new ViewGroup.LayoutParams(-2, -2);
        this.contentFrameLayout.addView((View)this.crossImageView, (ViewGroup.LayoutParams)var1_1);
        this.setContentView((View)this.contentFrameLayout);
        this.crossImageView.bringToFront();
        this.myOrientationEventListener = new OrientationEventListener(this, this.getContext(), 3){
            final /* synthetic */ WebDialog this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Context)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            public void onOrientationChanged(int arg0) {
                void var1_1;
                if (arg0 > 350 || arg0 < 10) {
                    this.this$0.updateLayout();
                    return;
                }
                if (arg0 < 100 && arg0 > 80) {
                    this.this$0.updateLayout();
                    return;
                }
                if (arg0 > 170 && arg0 < 190) {
                    this.this$0.updateLayout();
                    return;
                }
                if (arg0 > 260 && var1_1 < 280) {
                    this.this$0.updateLayout();
                }
            }
        };
        if (this.myOrientationEventListener.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        this.setOnCancelListener(new DialogInterface.OnCancelListener(this){
            final /* synthetic */ WebDialog this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onCancel(DialogInterface dialog) {
            }
        });
        this.getWindow().addFlags(2);
        this.getWindow().getAttributes().dimAmount = 0.7f;
    }

    private void updateLayout() {
        if (this.oldWidth != this.getScreenWidth()) {
            this.calculateSize();
            this.oldWidth = this.getScreenWidth();
        }
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    /*
     * WARNING - void declaration
     */
    private int getScreenWidth() {
        void var2_2;
        void var1_1;
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        var1_1.getMetrics(metrics);
        return var2_2.widthPixels;
    }

    /*
     * WARNING - void declaration
     */
    private void calculateSize() {
        void var2_4;
        void var1_2;
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        if (Utilities.isTablet(this.getContext())) {
            int dialogWidth;
            int dialogHeight = height * 2 / 3;
            if (Utilities.isPortait(this.getContext())) {
                dialogWidth = width * 2 / 3;
                if (dialogWidth < 300) {
                    dialogWidth = 300;
                }
                if (dialogHeight < 400) {
                    dialogHeight = 400;
                }
            } else {
                if ((dialogWidth = dialogWidth * true / 2) < 400) {
                    dialogWidth = 400;
                }
                if (dialogHeight < 300) {
                    dialogHeight = 300;
                }
            }
            this.getWindow().setLayout((int)var1_2, (int)var2_4);
            return;
        }
        this.getWindow().setLayout((int)var1_2, (int)(var2_4 - 80));
    }

    /*
     * WARNING - void declaration
     */
    private int getScaledSize(int screenSize, float density, int noPaddingSize, int maxPaddingSize) {
        void var1_1;
        void var3_4;
        void var2_3;
        int scaledSize = (int)((float)screenSize / density);
        double scaleFactor = scaledSize <= noPaddingSize ? 1.0 : (scaledSize >= maxPaddingSize ? 0.5 : 0.5 + (double)(maxPaddingSize - var2_3) / (double)(maxPaddingSize - var3_4) * 0.5);
        return (int)((double)var1_1 * scaleFactor);
    }

    /*
     * WARNING - void declaration
     */
    protected void sendSuccessToListener(Bundle values) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            void var1_1;
            this.listenerCalled = true;
            this.onCompleteListener.onComplete((Bundle)var1_1);
            this.dismiss();
        }
    }

    protected void sendErrorToListener(Throwable error) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(null);
            this.dismiss();
        }
    }

    protected void sendCancelToListener() {
        this.sendErrorToListener(null);
    }

    /*
     * WARNING - void declaration
     */
    private void createCrossImage() {
        void var1_1;
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ WebDialog this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onClick(View v) {
                this.this$0.dismiss();
            }
        });
        Drawable crossDrawable = this.getContext().getResources().getDrawable(R.drawable.ic_close_web);
        this.crossImageView.setImageDrawable((Drawable)var1_1);
        this.crossImageView.setVisibility(4);
        this.crossImageView.setPadding(WebDialog.convertDpToPixel(7.0f, this.getContext()), WebDialog.convertDpToPixel(7.0f, this.getContext()), 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int convertDpToPixel(float dp, Context context) {
        void var1_1;
        float f2;
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return (int)(f2 * ((float)var1_1.densityDpi / 160.0f));
    }

    /*
     * WARNING - void declaration
     */
    private void setupCookie() {
        void var2_2;
        void var1_1;
        this.cookieSyncManager = CookieSyncManager.createInstance((Context)this.getContext());
        this.cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        } else {
            this.cookieManager.setAcceptCookie(true);
        }
        String baseUrl = "https://plugin.zaloapp.com";
        String cookies = this.cookieManager.getCookie(baseUrl);
        Log.i((String)"debuglog", (String)("cookie: " + cookies));
        this.cookieManager.removeAllCookie();
        this.cookieManager.setCookie(baseUrl, "code=" + this.code);
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            this.cookieSyncManager.sync();
        }
        Log.i((String)"debuglog", (String)("set cookie: code=" + this.code));
        cookies = this.cookieManager.getCookie((String)var1_1);
        Log.i((String)"debuglog", (String)("cookies: " + (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView(int margin) {
        void var2_2;
        void var1_1;
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        this.webView = new WebView(this, this.getContext()){
            final /* synthetic */ WebDialog this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Context)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void onWindowFocusChanged(boolean hasWindowFocus) {
                try {
                    void var1_1;
                    super.onWindowFocusChanged((boolean)var1_1);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    return;
                }
            }
        };
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.setupCookie();
        this.webView.postUrl(this.url, this.queryBody.getBytes());
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setSaveFormData(false);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            void var3_3;
            String databasePath = this.getContext().getDir("database", 0).getPath();
            this.webView.getSettings().setDatabasePath((String)var3_3);
        }
        webViewContainer.setPadding(margin, margin, margin, (int)var1_1);
        webViewContainer.addView((View)this.webView);
        webViewContainer.setBackgroundColor(0xFFFFFF);
        this.contentFrameLayout.addView((View)var2_2);
    }

    public static class RequestsDialogBuilder
    extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String MESSAGE_PARAM = "message";
        private static final String TO_PARAM = "to";
        private static final String DATA_PARAM = "data";
        private static final String TITLE_PARAM = "title";

        /*
         * WARNING - void declaration
         */
        public RequestsDialogBuilder(Context context) {
            super((Context)var1_1, APPREQUESTS_DIALOG);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public RequestsDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super((Context)var1_1, (String)var2_2, APPREQUESTS_DIALOG, (Bundle)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public RequestsDialogBuilder setMessage(String message) {
            void var1_1;
            this.getParameters().putString(MESSAGE_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public RequestsDialogBuilder setTo(String id2) {
            void var1_1;
            this.getParameters().putString(TO_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public RequestsDialogBuilder setData(String data) {
            void var1_1;
            this.getParameters().putString(DATA_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public RequestsDialogBuilder setTitle(String title) {
            void var1_1;
            this.getParameters().putString(TITLE_PARAM, (String)var1_1);
            return this;
        }
    }

    public static class FeedDialogBuilder
    extends BuilderBase<FeedDialogBuilder> {
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String TO_PARAM = "to";
        private static final String LINK_PARAM = "link";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String NAME_PARAM = "name";
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder(Context context) {
            super((Context)var1_1, FEED_DIALOG);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder(Context context, Bundle parameters) {
            super((Context)var1_1, FEED_DIALOG, (Bundle)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super((Context)var1_1, (String)var2_2, FEED_DIALOG, (Bundle)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setFrom(String id2) {
            void var1_1;
            this.getParameters().putString(FROM_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setTo(String id2) {
            void var1_1;
            this.getParameters().putString(TO_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setLink(String link) {
            void var1_1;
            this.getParameters().putString(LINK_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setPicture(String picture) {
            void var1_1;
            this.getParameters().putString(PICTURE_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setSource(String source) {
            void var1_1;
            this.getParameters().putString(SOURCE_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setName(String name) {
            void var1_1;
            this.getParameters().putString(NAME_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setCaption(String caption) {
            void var1_1;
            this.getParameters().putString(CAPTION_PARAM, (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public FeedDialogBuilder setDescription(String description) {
            void var1_1;
            this.getParameters().putString(DESCRIPTION_PARAM, (String)var1_1);
            return this;
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        /*
         * WARNING - void declaration
         */
        public Builder(Context context, String action) {
            super((Context)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Context context, String action, Bundle parameters) {
            super((Context)var1_1, (String)var2_2, (Bundle)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Context context, String applicationId, String action, Bundle parameters) {
            super((Context)var1_1, (String)var2_2, (String)var3_3, parameters);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private Context context;
        private String applicationId;
        private String action;
        private int theme = 0x1030010;
        private OnCompleteListener listener;
        private Bundle parameters;

        /*
         * WARNING - void declaration
         */
        protected BuilderBase(Context context, String action) {
            void var2_2;
            void var1_1;
            this.finishInit((Context)var1_1, (String)var2_2, null);
        }

        /*
         * WARNING - void declaration
         */
        protected BuilderBase(Context context, String action, Bundle parameters) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.finishInit((Context)var1_1, (String)var2_2, (Bundle)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        protected BuilderBase(Context context, String applicationId, String action, Bundle parameters) {
            void var3_3;
            void var1_1;
            this.finishInit((Context)var1_1, (String)var3_3, parameters);
        }

        /*
         * WARNING - void declaration
         */
        public CONCRETE setTheme(int theme) {
            void var1_1;
            this.theme = var1_1;
            return (CONCRETE)this;
        }

        /*
         * WARNING - void declaration
         */
        public CONCRETE setOnCompleteListener(OnCompleteListener listener) {
            void var1_1;
            this.listener = var1_1;
            return (CONCRETE)this;
        }

        public WebDialog build() {
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected int getTheme() {
            return this.theme;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        /*
         * WARNING - void declaration
         */
        private void finishInit(Context context, String action, Bundle parameters) {
            void var2_2;
            void var1_1;
            this.context = var1_1;
            this.action = var2_2;
            if (parameters != null) {
                void var3_3;
                this.parameters = var3_3;
                return;
            }
            this.parameters = new Bundle();
        }
    }

    class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        /*
         * WARNING - void declaration
         */
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            void var2_2;
            void var1_1;
            return super.shouldOverrideUrlLoading((WebView)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.onReceivedError((WebView)var1_1, (int)var2_2, (String)var3_3, failingUrl);
            WebDialog.this.sendErrorToListener(null);
        }

        /*
         * WARNING - void declaration
         */
        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            void var2_2;
            void var3_3;
            void var1_1;
            super.onReceivedSslError((WebView)var1_1, handler, (SslError)var3_3);
            var2_2.cancel();
            WebDialog.this.sendErrorToListener(null);
        }

        /*
         * WARNING - void declaration
         */
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
            if (url.contains("plugin.zaloapp.com/webview/callback")) {
                view.stopLoading();
                if (WebDialog.this.zFeedCallback != null) {
                    void var1_1;
                    void var3_5;
                    void var2_3;
                    Uri u = Uri.parse((String)url);
                    Bundle b2 = this.parseUrlQueryString(u.getQuery());
                    boolean isSuccess = false;
                    int error_code = 0;
                    String strErrorCode = b2.getString("error_code");
                    if (!TextUtils.isEmpty((CharSequence)strErrorCode)) {
                        try {
                            error_code = Integer.parseInt(strErrorCode);
                        }
                        catch (Exception exception) {
                            error_code = 0;
                        }
                    }
                    if (error_code == 0) {
                        isSuccess = true;
                    }
                    String error_msg = b2.getString("error_message");
                    String data = b2.getString("result_data");
                    WebDialog.this.zFeedCallback.onResult((boolean)var2_3, (int)var3_5, error_msg, (String)var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public Bundle parseUrlQueryString(String queryString) {
            void var2_2;
            Bundle params = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)queryString)) {
                String[] stringArray;
                stringArray = stringArray.split("&");
                int n = stringArray.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    String[] keyValuePair = stringArray[i2].split("=");
                    try {
                        if (keyValuePair.length == 2) {
                            params.putString(URLDecoder.decode(keyValuePair[0], WebDialog.UTF8), URLDecoder.decode(keyValuePair[1], WebDialog.UTF8));
                            continue;
                        }
                        if (keyValuePair.length != 1) continue;
                        params.putString(URLDecoder.decode(keyValuePair[0], WebDialog.UTF8), "");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void onPageFinished(WebView view, String url) {
            void var2_2;
            void var1_1;
            super.onPageFinished((WebView)var1_1, (String)var2_2);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1);
    }
}

