/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.payment.direct.PaymentDialog;

public class PaymentAlertDialog
extends PaymentDialog
implements View.OnClickListener {
    OnCancelListener cancelListener = null;
    OnOkListener listener = null;
    String okTitle;
    boolean hideOkButton = false;
    String title;

    public PaymentAlertDialog(Context context) {
        super(context);
    }

    public PaymentAlertDialog(Context context, OnOkListener onOkListener) {
        super(context);
        this.listener = onOkListener;
    }

    public PaymentAlertDialog(Context context, OnOkListener onOkListener, OnCancelListener onCancelListener) {
        super(context);
        this.listener = onOkListener;
        this.cancelListener = onCancelListener;
    }

    public void setOnOkListener(OnOkListener onOkListener) {
        this.listener = onOkListener;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.zalosdk_activity_alert);
        this.findViewById(R.id.zalosdk_ok_ctl).setOnClickListener((View.OnClickListener)this);
        if (!TextUtils.isEmpty((CharSequence)this.okTitle)) {
            ((TextView)this.findViewById(R.id.zalosdk_ok_ctl)).setText((CharSequence)this.okTitle);
        }
        if (this.cancelListener == null) {
            this.findViewById(R.id.button_devider).setVisibility(8);
            this.findViewById(R.id.zalosdk_cancel_ctl).setVisibility(8);
            this.findViewById(R.id.zalosdk_cancel_ctl).setOnClickListener(null);
            return;
        }
        this.findViewById(R.id.button_devider).setVisibility(0);
        this.findViewById(R.id.zalosdk_cancel_ctl).setVisibility(0);
        this.findViewById(R.id.zalosdk_cancel_ctl).setOnClickListener((View.OnClickListener)this);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setOkButtonTitle(String string) {
        this.okTitle = string;
    }

    public void hideOkButton(boolean bl) {
        this.hideOkButton = bl;
    }

    public void showAlert(String string) {
        this.show();
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)string);
        string = this.findViewById(R.id.zalosdk_ok_ctl);
        if (this.hideOkButton) {
            string.setVisibility(8);
        } else {
            string.setVisibility(0);
        }
        this.setCancelable(true);
        string = (TextView)this.findViewById(R.id.text_title_alert);
        if (string != null) {
            string.setText((CharSequence)this.title);
        }
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.zalosdk_ok_ctl) {
            this.dismiss();
            if (this.listener != null) {
                this.listener.onOK();
                return;
            }
        } else if (n == R.id.zalosdk_cancel_ctl) {
            this.dismiss();
            if (this.cancelListener != null) {
                this.cancelListener.onCancel();
            }
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    public static interface OnOkListener {
        public void onOK();
    }
}

