package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnDismissListener;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.k;
import com.zing.zalo.zalosdk.core.log.Log;

public class PaymentProcessingDialog extends PaymentDialog implements OnDismissListener {
    String LOG_TAG = PaymentProcessingDialog.class.getSimpleName();
    Handler handler = new Handler();
    public boolean isShow = false;
    boolean isTimeOut = false;
    OnCloseListener listener;
    Runnable runnable = new Runnable() {
        public void run() {
            if (PaymentProcessingDialog.this.viewIndex > 0 && PaymentProcessingDialog.this.isShowing()) {
                PaymentProcessingDialog.this.hideView();
                if (PaymentProcessingDialog.this.listener != null) {
                    PaymentProcessingDialog.this.listener.onClose();
                }
            }
        }
    };
    int viewIndex = 0;
    String zalosdk_processing;
    String zalosdk_success;
    String zalosdk_unsuccess;

    public interface OnCloseListener {
        void onClose();
    }

    public enum Status {
        PROCESSING,
        SUCCESS,
        FAILED,
        TIMEOUT
    }

    public PaymentProcessingDialog(Context context, OnCloseListener onCloseListener) {
        super(context);
        this.listener = onCloseListener;
        setOnDismissListener(this);
        this.zalosdk_processing = k.a("zalosdk_processing");
        this.zalosdk_success = k.a("zalosdk_success");
        this.zalosdk_unsuccess = k.a("zalosdk_unsuccess");
    }

    private void autoClose() {
        this.handler.postDelayed(this.runnable, 3000);
    }

    private void showProcessingView() {
        Log.i("THREAD BEGIN", "PROCESSING!!");
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_processing);
        findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        setCancelable(false);
        this.viewIndex = 0;
    }

    private void showSuccessView() {
        Log.i(this.LOG_TAG, "Show success dialog");
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_success);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView) findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_success);
        imageView.setVisibility(0);
        setCancelable(true);
        this.viewIndex = 1;
        autoClose();
    }

    private void showTimeOutView() {
        Log.i("debuglog", "time out showview");
        findViewById(R.id.zalosdk_process_dialog_ctl).setVisibility(8);
        setCancelable(true);
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 1);
        this.isTimeOut = true;
    }

    private void showUnSuccessView() {
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_unsuccess);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView) findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_fail);
        imageView.setVisibility(0);
        setCancelable(true);
        this.viewIndex = 1;
        autoClose();
    }

    public void hide() {
        Log.i(this.LOG_TAG, "hide loading!");
        super.hide();
    }

    public void hideView() {
        this.isShow = false;
        hide();
    }

    public void onBackPressed() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        setContentView(R.layout.zalosdk_activity_processing);
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.listener != null) {
            Log.i(getClass().getName(), "cancel");
            this.listener.onClose();
        }
    }

    public void show() {
        Log.i(this.LOG_TAG, "show loading..");
        try {
            super.show();
        } catch (Exception e) {
            Log.i(this.LOG_TAG, "error can not show loading");
        }
    }

    public void showView(Status status) {
        show();
        this.isShow = true;
        switch (status) {
            case PROCESSING:
                showProcessingView();
                return;
            case SUCCESS:
                showSuccessView();
                return;
            case FAILED:
                showUnSuccessView();
                return;
            case TIMEOUT:
                showTimeOutView();
                return;
            default:
                return;
        }
    }

    public void updateProcessingTransactionView(String str) {
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(str);
    }
}
