package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.payment.direct.PaymentAlertDialog.OnCancelListener;
import com.zing.zalo.zalosdk.payment.direct.PaymentAlertDialog.OnOkListener;
import java.util.Locale;

public class Utils {
    private static String language = null;

    public static String getLanguage(Context context) {
        if (language == null) {
            return Locale.getDefault().getLanguage();
        }
        Log.i("debuglog", "default-------locale langauge : " + Locale.getDefault().getLanguage());
        if (Locale.getDefault().getLanguage().equalsIgnoreCase("vi")) {
            return "vi";
        }
        return "my";
    }

    public static void showAlertDialog(Context context, String mess, String okTile, OnOkListener listener, OnCancelListener cancelListener) {
        PaymentAlertDialog alertDlg = new PaymentAlertDialog(context, listener, cancelListener);
        alertDlg.setOkButtonTitle(okTile);
        alertDlg.showAlert(mess);
    }

    public static void showAlertDialog(Context context, String mess, OnOkListener listener) {
        new PaymentAlertDialog(context, listener).showAlert(mess);
    }

    public static void setLanguage(Context context, String _language) {
        language = _language;
    }
}
