package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.zing.zalo.devicetrackingsdk.AppUserDataCallback;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo.GetInfoListener;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo.OnGetAdsID;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.zalosdk.auth.internal.a;
import com.zing.zalo.zalosdk.core.exception.InitializedException;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.payment.direct.Utils;
import java.lang.ref.WeakReference;

public class ZaloSDK extends ZaloOAuth {
    public static ZaloSDK Instance = new ZaloSDK();
    private boolean a = false;
    private Authenticator b;
    private LocalizedString c = new LocalizedString();
    private OauthStorage d;
    private a e;
    private BaseAppInfo f;

    ZaloSDK() {
    }

    protected synchronized void initialize(Application app) {
        if (!this.a) {
            Context context = app.getApplicationContext();
            this.d = new OauthStorage(context);
            this.b = new Authenticator(context, this.d, this.c);
            this.a = true;
            this.e = new a(this.d);
            this.f = new BaseAppInfo(context, new BaseAppInfoStorage(context), String.valueOf(getAppID()));
        }
    }

    public Authenticator getAuthenticator() {
        return this.b;
    }

    public LocalizedString getLocalizedString() {
        return this.c;
    }

    public void setLocalizedString(LocalizedString localizedString) {
        this.c = localizedString;
    }

    public void authenticate(Activity activity, OAuthCompleteListener listener) {
        authenticate(activity, LoginVia.APP, listener);
    }

    public void authenticate(Activity activity, LoginVia loginVia, OAuthCompleteListener listener) {
        checkInitialize();
        this.b.authenticate(activity, loginVia, false, listener);
    }

    protected void authenticateZaloPlugin(Activity activity, OAuthCompleteListener listener) {
        checkInitialize();
        this.b.authenticate(activity, LoginVia.APP_OR_WEB, true, listener);
    }

    public void setOauthCompletedListener(OAuthCompleteListener listener) {
        checkInitialize();
        this.b.setOAuthCompleteListener(listener);
    }

    public void unauthenticate() {
        checkInitialize();
        this.b.unauthenticate();
    }

    public boolean isAuthenticate(ValidateOAuthCodeCallback callback) {
        return isAuthenticate(this.d.getOAuthCode(), callback);
    }

    protected boolean isAuthenticate(String oauthCode, ValidateOAuthCodeCallback callback) {
        checkInitialize();
        return this.b.isAuthenticate(oauthCode, callback);
    }

    public final boolean onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        return this.b.onActivityResult(activity, requestCode, resultCode, data);
    }

    public void requestPermissions(Activity activity, Enum<Permissions> permission, OAuthCompleteListener listener) {
        checkInitialize();
        this.b.requestPermissions(activity, permission, listener);
    }

    public String getOAuthCode() {
        checkInitialize();
        return this.d.getOAuthCode();
    }

    public String getLastestLoginChannel() {
        return this.d.getLastestLoginChannel();
    }

    public long getAppID() {
        return ZaloSDKApplication.appID;
    }

    public long getZaloId() {
        checkInitialize();
        return this.d.getZaloId();
    }

    public String getZaloDisplayname() {
        checkInitialize();
        return this.d.getZaloDisplayName();
    }

    public String getSocialId() {
        checkInitialize();
        return this.d.getSocialId();
    }

    public void getProfile(Context ctx, ZaloOpenAPICallback callback, String[] fields) {
        checkInitialize();
        a aVar = this.e;
        new HttpClientRequest(Type.GET, aVar.a).addParams("fields", a.a(fields));
        new a.a(aVar, ctx, new WeakReference(callback)).execute(new HttpClientRequest[]{r1});
    }

    public void getFriendListUsedApp(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        checkInitialize();
        a aVar = this.e;
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, aVar.a + "/friends");
        httpClientRequest.addParams("fields", a.a(fields));
        httpClientRequest.addParams("offset", String.valueOf(position));
        httpClientRequest.addParams("limit", String.valueOf(count));
        new a.a(aVar, ctx, new WeakReference(callback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void getFriendListInvitable(Context ctx, int position, int count, ZaloOpenAPICallback callback, String[] fields) {
        checkInitialize();
        a aVar = this.e;
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, aVar.a + "/invitable_friends");
        httpClientRequest.addParams("fields", a.a(fields));
        httpClientRequest.addParams("offset", String.valueOf(position));
        httpClientRequest.addParams("limit", String.valueOf(count));
        new a.a(aVar, ctx, new WeakReference(callback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void inviteFriendUseApp(Context ctx, String[] friendId, String message, ZaloOpenAPICallback callback) {
        checkInitialize();
        a aVar = this.e;
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://graph.zalo.me/v2.0/apprequests");
        httpClientRequest.addParams("to", a.a(friendId));
        httpClientRequest.addParams("message", message);
        new a.a(aVar, ctx, new WeakReference(callback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void checkInitialize() {
        if (!this.a) {
            throw new InitializedException("Missing call declare com.zing.zalo.zalosdk.oauth.ZaloSDKApplication in Application or call wrap init");
        }
    }

    public String getVersion() {
        return "2.4.1502";
    }

    public void setLogLevel(int logLevel) {
        Log.setLogLevel(logLevel);
    }

    public String getDeviceId() {
        return this.f.getDeviceId();
    }

    public String getDeviceId(GetInfoListener getDeviceIdListener) {
        return this.f.getDeviceId(getDeviceIdListener);
    }

    public String getGuestDeviceId() {
        return this.f.getGuestDeviceId();
    }

    public String getSDKId() {
        return this.f.getSDKId();
    }

    public String getPrivateKey() {
        return this.f.getPrivateKey();
    }

    public void submitAppUserData(String appUser, String loginChannel, String distributionSource, String appUTMSource, AppUserDataCallback callback) {
        checkInitialize();
        this.f.submitAppUserData(appUser, loginChannel, distributionSource, appUTMSource, callback);
    }

    public BaseAppInfo getBaseAppInfo() {
        return this.f;
    }

    public String getDistributionSource() {
        if (this.f != null) {
            return this.f.getDistributionSource();
        }
        return null;
    }

    public String getAppUser() {
        if (this.f != null) {
            return this.f.getAppUser();
        }
        return null;
    }

    public String getLoginChannel() {
        if (this.f != null) {
            return this.f.getLoginChannel();
        }
        return null;
    }

    public OauthStorage getOauthStorage() {
        return this.d;
    }

    public void setLanguageSDK(Context context, String language) {
        Utils.setLanguage(context, language);
    }

    public void registerZalo(Activity activity, OAuthCompleteListener listener) {
        checkInitialize();
        this.b.registerZalo(activity, listener);
    }

    public void getAdID(OnGetAdsID onGetAdsID) {
        if (getBaseAppInfo() != null) {
            getBaseAppInfo().getAdsID(onGetAdsID);
        }
    }

    public void setApplicationID(long appID) {
        ZaloSDKApplication.appID = appID;
    }
}
