package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;

public class PaymentAlertDialog extends PaymentDialog implements OnClickListener {
    OnCancelListener cancelListener = null;
    boolean hideOkButton = false;
    OnOkListener listener = null;
    String okTitle;
    String title;

    public interface OnCancelListener {
        void onCancel();
    }

    public interface OnOkListener {
        void onOK();
    }

    public PaymentAlertDialog(Context context) {
        super(context);
    }

    public PaymentAlertDialog(Context context, OnOkListener listener) {
        super(context);
        this.listener = listener;
    }

    public PaymentAlertDialog(Context context, OnOkListener listener, OnCancelListener cancelListener) {
        super(context);
        this.listener = listener;
        this.cancelListener = cancelListener;
    }

    public void setOnOkListener(OnOkListener listener) {
        this.listener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.zalosdk_activity_alert);
        findViewById(R.id.zalosdk_ok_ctl).setOnClickListener(this);
        if (!TextUtils.isEmpty(this.okTitle)) {
            ((TextView) findViewById(R.id.zalosdk_ok_ctl)).setText(this.okTitle);
        }
        if (this.cancelListener == null) {
            findViewById(R.id.button_devider).setVisibility(8);
            findViewById(R.id.zalosdk_cancel_ctl).setVisibility(8);
            findViewById(R.id.zalosdk_cancel_ctl).setOnClickListener(null);
            return;
        }
        findViewById(R.id.button_devider).setVisibility(0);
        findViewById(R.id.zalosdk_cancel_ctl).setVisibility(0);
        findViewById(R.id.zalosdk_cancel_ctl).setOnClickListener(this);
    }

    public void setTitle(String _title) {
        this.title = _title;
    }

    public void setOkButtonTitle(String title) {
        this.okTitle = title;
    }

    public void hideOkButton(boolean isHide) {
        this.hideOkButton = isHide;
    }

    public void showAlert(String message) {
        show();
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(message);
        View ok = findViewById(R.id.zalosdk_ok_ctl);
        if (this.hideOkButton) {
            ok.setVisibility(8);
        } else {
            ok.setVisibility(0);
        }
        setCancelable(true);
        TextView extTitle = (TextView) findViewById(R.id.text_title_alert);
        if (extTitle != null) {
            extTitle.setText(this.title);
        }
    }

    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.zalosdk_ok_ctl) {
            dismiss();
            if (this.listener != null) {
                this.listener.onOK();
            }
        } else if (id == R.id.zalosdk_cancel_ctl) {
            dismiss();
            if (this.cancelListener != null) {
                this.cancelListener.onCancel();
            }
        }
    }
}
