package com.zing.zalo.zalosdk.oauth;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;

class Utilities {
    Utilities() {
    }

    static boolean a(Context ctx) {
        if (!Utils.isPermissionGranted(ctx, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        NetworkInfo netInfo = ((ConnectivityManager) ctx.getSystemService("connectivity")).getActiveNetworkInfo();
        if (netInfo == null || !netInfo.isConnectedOrConnecting()) {
            return false;
        }
        return true;
    }

    public static void invokeMarketApp(Context context, String packageId) {
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse("market://details?id=" + packageId)));
        } catch (ActivityNotFoundException e) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse("https://play.google.com/store/apps/details?id=" + packageId)));
        }
    }

    public static int getVersionCode(Context oContext, String packageId) {
        try {
            PackageInfo pInfo = oContext.getPackageManager().getPackageInfo(packageId, 0);
            if (pInfo != null) {
                return pInfo.versionCode;
            }
        } catch (Exception e) {
        }
        return -1;
    }

    public static boolean isZaloSupportCallBack(Context context) {
        return getVersionCode(context, "com.zing.zalo") > 1100123;
    }

    public static boolean isZaloInstalled(Context context) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        if (intent.resolveActivityInfo(context.getPackageManager(), 0) != null) {
            return true;
        }
        return false;
    }

    public static boolean isTablet(Context ctx) {
        return ctx.getResources().getBoolean(R.bool.isTablet);
    }

    public static boolean isPortait(Context context) {
        Display display = ((WindowManager) context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        if (metrics.heightPixels > metrics.widthPixels) {
            return true;
        }
        return false;
    }

    static boolean b(Context ctx) {
        if (!SettingsManager.getInstance().isLoginViaBrowser(ctx)) {
            return false;
        }
        String appId = AppInfo.getAppId(ctx);
        String pkgName = AppInfo.getPackageName(ctx);
        if (TextUtils.isEmpty(appId)) {
            return false;
        }
        PackageManager pkgMgr = ctx.getPackageManager();
        Intent intent = new Intent();
        intent.setPackage(pkgName);
        intent.setData(Uri.parse("zalo-" + appId + "://"));
        ComponentName componentName = intent.resolveActivity(pkgMgr);
        if (componentName != null && BrowserLoginActivity.class.getName().equalsIgnoreCase(componentName.getClassName())) {
            return true;
        }
        Log.e("ZaloSDK support login via browser from version 2.4.0901");
        Log.e("Please add this activity to your AndroidManifest.xml");
        Log.e("  <activity android:name=\" " + BrowserLoginActivity.class.getName() + " \">");
        Log.e("    <intent-filter>");
        Log.e("      <action android:name=\"android.intent.action.VIEW\" />");
        Log.e("      <category android:name=\"android.intent.category.DEFAULT\" />");
        Log.e("      <category android:name=\"android.intent.category.BROWSABLE\" />");
        Log.e("      <data android:scheme=\"zalo-" + appId + "\" />");
        Log.e("    </intent-filter>");
        Log.e("  </activity>");
        return false;
    }
}
