package com.zing.zalo.zalosdk.oauth;

import android.content.Context;
import android.content.SharedPreferences.Editor;
import com.zing.zalo.zalosdk.core.helper.Storage;

public class OauthStorage extends Storage {
    private final String PREF_ACESS_TOKEN = "PREF_ACESS_TOKEN";
    private final String PREF_ACESS_TOKEN_NEW_API = "PREF_NEW_API_ACCESSTOKEN";
    private final String PREF_APP_VERSION_NOTI = "PREF_APP_VERSION_NOTI";
    private final String PREF_GCM_TOKEN = "PREF_GCM_TOKEN";
    private final String PREF_GUEST_DEVICE_ID = "PREF_GUEST_DEVICE_ID";
    private final String PREF_GUEST_IS_CERT = "PREF_GUEST_IS_CERTIFICATE";
    private final String PREF_IS_PROTECTED = "PREF_IS_PROTECTED";
    private final String PREF_OAUTH_CODE = "PREFERECE_ZALO_SDK_OAUTH_CODE";
    private final String PREF_OAUTH_CODE_CHANNEL = "PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL";
    private final String PREF_OSV = "PREF_APP_VERSION";
    private final String PREF_SOCIAL_ID = "PREFERECE_SOCIAL_ID";
    private final String PREF_ZALO_DISPLAY_NAME = "PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME";
    private final String PREF_ZALO_ID = "PREFERECE_ZALO_SDK_ZALO_ID";
    private final String PREF_ZALO_ID_NOTI = "PREFERECE_ZALO_SDK_ZALO_ID_NOTI";
    private final String PREF_ZPLUGIN_OAUTH_CODE = "PREFERECE_ZALO_SDK_ZPLUGIN_OAUTH_CODE";
    private final String PREF_ZPLUGIN_USERID = "PREFERECE_ZALO_SDK_ZPLUGIN_USERID";

    public OauthStorage(Context c) {
        super(c);
    }

    public String getSocialId() {
        return getString("PREFERECE_SOCIAL_ID");
    }

    public void setSocialId(String socialId) {
        setString("PREFERECE_SOCIAL_ID", socialId);
    }

    public String getOAuthCode() {
        return getString("PREFERECE_ZALO_SDK_OAUTH_CODE");
    }

    public String getLastestLoginChannel() {
        return getString("PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL");
    }

    public void setOAuthCode(String channel, String code) {
        setString("PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL", channel);
        setString("PREFERECE_ZALO_SDK_OAUTH_CODE", code);
    }

    public String getZaloPluginOAuthCode() {
        return getString("PREFERECE_ZALO_SDK_ZPLUGIN_OAUTH_CODE");
    }

    public void setZaloPluginOAuthCode(String code) {
        setString("PREFERECE_ZALO_SDK_ZPLUGIN_OAUTH_CODE", code);
    }

    public long getZaloPluginUserId() {
        return getLong("PREFERECE_ZALO_SDK_ZPLUGIN_USERID");
    }

    public void setZaloPluginUserId(long userId) {
        setLong("PREFERECE_ZALO_SDK_ZPLUGIN_USERID", userId);
    }

    public long getZaloId() {
        return getLong("PREFERECE_ZALO_SDK_ZALO_ID");
    }

    public void setZaloId(long id) {
        setLong("PREFERECE_ZALO_SDK_ZALO_ID", id);
    }

    public String getZaloDisplayName() {
        return getString("PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME");
    }

    public void setZaloDisplayName(String displayname) {
        setString("PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME", displayname);
    }

    public int getIsProtected() {
        return getInt("PREF_IS_PROTECTED");
    }

    public void setIsProtected(int isProtected) {
        setInt("PREF_IS_PROTECTED", isProtected);
    }

    public String getGuestDeviceId() {
        return getString("PREF_GUEST_DEVICE_ID");
    }

    public void setGuestDeviceId(String id) {
        setString("PREF_GUEST_DEVICE_ID", id);
    }

    public int getIsGuestCertificated() {
        return getInt("PREF_GUEST_IS_CERTIFICATE");
    }

    public void setIsGuestCertificated(int isCert) {
        setInt("PREF_GUEST_IS_CERTIFICATE", isCert);
    }

    public String getAccessToken() {
        return getString("PREF_ACESS_TOKEN");
    }

    public void setAccessToken(String token) {
        setString("PREF_ACESS_TOKEN", token);
    }

    public String getAccessTokenNewAPI() {
        return getString("PREF_NEW_API_ACCESSTOKEN");
    }

    public void setAccessTokenNewAPI(String token) {
        setString("PREF_NEW_API_ACCESSTOKEN", token);
    }

    public String getGCMToken() {
        return this.localPref.getString("PREF_GCM_TOKEN", "");
    }

    public int getAppVersion() {
        return this.localPref.getInt("PREF_APP_VERSION_NOTI", Integer.MIN_VALUE);
    }

    public String getOSV() {
        return this.localPref.getString("PREF_APP_VERSION", "");
    }

    public long getZaloIdNoti() {
        return getLong("PREFERECE_ZALO_SDK_ZALO_ID_NOTI");
    }

    public void storeRegistrationId(String token, int appVer, String osv, long zaloId) {
        Editor edit = this.localPref.edit();
        edit.putString("PREF_GCM_TOKEN", token);
        edit.putInt("PREF_APP_VERSION_NOTI", appVer);
        edit.putString("PREF_APP_VERSION", osv);
        edit.putLong("PREFERECE_ZALO_SDK_ZALO_ID_NOTI", zaloId);
        edit.commit();
    }
}
