package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.zing.zalo.zalosdk.auth.internal.j;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.ZTaskExecutor;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.payment.direct.Utils;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import org.json.JSONObject;

public class Authenticator {
    static boolean isGetZaloOAuth = false;
    /* access modifiers changed from: private */
    public boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    protected Context mContext;
    private LocalizedString mLocalizedString;
    /* access modifiers changed from: private */
    public OauthStorage mStorage;
    public String nameActivtyCheckAuthen = "";
    public BroadcastReceiver receiver = new BroadcastReceiver() {
        public final void onReceive(Context context, Intent intent) {
            if ("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP".equals(intent.getAction())) {
                Authenticator.this.bIsZaloLoginSuccessful = intent.getBooleanExtra("loginSuccessful", false);
            }
        }
    };
    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;
    private boolean zaloPluginLogin = false;

    class a extends AsyncTask<Void, Void, String> {
        ValidateOAuthCodeCallback a;
        String b;

        /* access modifiers changed from: protected */
        public final /* synthetic */ void onPostExecute(Object obj) {
            String str = (String) obj;
            super.onPostExecute(str);
            try {
                JSONObject jSONObject = new JSONObject(str);
                int i = jSONObject.getInt("error");
                if (i == 0) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                    long j = jSONObject2.getLong("uid");
                    if (j == Authenticator.this.mStorage.getZaloId()) {
                        int optInt = jSONObject2.optInt("zcert");
                        int optInt2 = jSONObject2.optInt("zprotect");
                        Authenticator.this.mStorage.setIsGuestCertificated(optInt);
                        Authenticator.this.mStorage.setIsProtected(optInt2);
                    }
                    this.a.onValidateComplete(true, 0, j, this.b);
                    return;
                }
                this.a.onValidateComplete(false, i, -1, null);
            } catch (Exception e) {
                this.a.onValidateComplete(false, ZaloOAuthResultCode.RESULTCODE_UNEXPECTED_ERROR, -1, null);
            }
        }

        a(String code, ValidateOAuthCodeCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback can't be null");
            }
            this.a = callback;
            this.b = code;
        }

        /* access modifiers changed from: protected */
        public final /* synthetic */ Object doInBackground(Object[] objArr) {
            HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v2/mobile/validate_oauth_code"));
            httpClientRequest.addParams("app_id", String.valueOf(ZaloSDKApplication.appID));
            httpClientRequest.addParams("code", this.b);
            httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
            httpClientRequest.addParams("frm", "sdk");
            return httpClientRequest.getText();
        }
    }

    Authenticator(Context ctx, OauthStorage storage, LocalizedString localizedString) {
        this.mContext = ctx;
        this.mStorage = storage;
        this.mLocalizedString = localizedString;
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        if (this.wListener == null || this.wListener.get() == null) {
            return new OAuthCompleteListener();
        }
        return (OAuthCompleteListener) this.wListener.get();
    }

    public void setOAuthCompleteListener(OAuthCompleteListener listener) {
        this.wListener = new WeakReference<>(listener);
    }

    /* access modifiers changed from: protected */
    public OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        if (this.wLoginFormListener == null || this.wLoginFormListener.get() == null) {
            return new OAuthCompleteListener();
        }
        return (OAuthCompleteListener) this.wLoginFormListener.get();
    }

    /* access modifiers changed from: protected */
    public void setLoginFormOAuthCompleteListener(OAuthCompleteListener listener) {
        this.wLoginFormListener = new WeakReference<>(listener);
    }

    /* access modifiers changed from: 0000 */
    public void authenticate(Activity activity, LoginVia loginVia, boolean zaloPluginLogin2, OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        this.zaloPluginLogin = zaloPluginLogin2;
        sendOAuthRequest(activity, loginVia);
    }

    /* access modifiers changed from: 0000 */
    public void registerZalo(Activity activity, OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        activity.startActivityForResult(WebLoginActivity.a(activity, true), 64725);
    }

    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        boolean isZaloInstalled = AppInfo.isPackageExists(activity, "com.zing.zalo");
        switch (loginVia) {
            case APP:
                if (isZaloInstalled) {
                    loginViaApp(activity);
                    return;
                } else {
                    getOAuthCompleteListener().onZaloNotInstalled(activity);
                    return;
                }
            case WEB:
                loginViaWeb(activity);
                return;
            case APP_OR_WEB:
                if (!isZaloInstalled) {
                    loginViaWeb(activity);
                    return;
                } else if (SettingsManager.getInstance().isUseWebViewUnLoginZalo(this.mContext)) {
                    loginViaAppOrWebIfNotLogin(activity);
                    return;
                } else {
                    loginViaApp(activity);
                    return;
                }
            default:
                return;
        }
    }

    private void loginViaAppOrWebIfNotLogin(final Activity activity) {
        getZaloLoginStatus(new GetZaloLoginStatus() {
            public final void onGetZaloLoginStatusCompleted(int status) {
                if (status == 1) {
                    Authenticator.this.loginViaApp(activity);
                } else {
                    Authenticator.this.loginViaWeb(activity);
                }
            }
        });
    }

    /* access modifiers changed from: private */
    public void loginViaApp(Activity activity) {
        try {
            activity.unregisterReceiver(this.receiver);
        } catch (Exception e) {
            Log.v(e.toString());
        }
        try {
            activity.registerReceiver(this.receiver, new IntentFilter("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP"));
            Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
            i.putExtra("android.intent.extra.UID", AppInfo.getAppIdLong(this.mContext));
            activity.startActivityForResult(i, 64725);
        } catch (ActivityNotFoundException e2) {
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        } catch (SecurityException e3) {
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        }
    }

    /* access modifiers changed from: private */
    public void loginViaWeb(Activity activity) {
        if (!Utilities.a(activity)) {
            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_NO_NETWORK, this.mLocalizedString.getNoNetworkMessage());
        } else if (Utilities.b(activity)) {
            loginViaBrowser(activity);
        } else {
            loginViaWebView(activity);
        }
    }

    private void loginViaBrowser(Activity activity) {
        StringBuilder url = new StringBuilder();
        url.append(ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/auth?app_id="));
        try {
            url.append(ZaloSDK.Instance.getAppID()).append("&sign_key=").append(URLEncoder.encode(AppInfo.getApplicationHashKey(activity), "UTF-8")).append("&pkg_name=").append(URLEncoder.encode(AppInfo.getPackageName(activity), "UTF-8")).append("&orientation=").append(activity.getResources().getConfiguration().orientation).append("&ts=").append(System.currentTimeMillis()).append("&lang=").append(Utils.getLanguage(activity));
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse(url.toString()));
            activity.startActivity(intent);
        } catch (UnsupportedEncodingException e) {
            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR, e.getMessage());
        }
    }

    private boolean checkCookieManagerSupport() {
        try {
            CookieManager.getInstance();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    private void loginViaWebView(Activity activity) {
        if (!checkCookieManagerSupport()) {
            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR, "Webview does not support login!");
        } else {
            activity.startActivityForResult(WebLoginActivity.a(activity, false), 64725);
        }
    }

    /* access modifiers changed from: protected */
    public void unauthenticate() {
        try {
            long uid = ZaloSDK.Instance.getZaloId();
            this.mContext.getSharedPreferences("zacPref", 0).edit().remove("MAX_PAGING" + uid).remove("GIFTCODE_EXPIRED_TIME" + uid).remove("CACHE_CODE_LIST" + uid).remove("CURRENT_PAGE" + uid).apply();
            this.mStorage.setAccessToken("");
            this.mStorage.setAccessTokenNewAPI("");
            this.mStorage.setOAuthCode("", "");
            this.mStorage.setZaloId(0);
            this.mStorage.setZaloDisplayName("");
            this.mStorage.setZaloPluginOAuthCode("");
            this.mStorage.setSocialId("");
        } catch (Exception e) {
        }
    }

    /* access modifiers changed from: 0000 */
    public boolean isAuthenticate(String code, ValidateOAuthCodeCallback callback) {
        if (code != null && code.length() != 0) {
            if (callback != null) {
                new a(code, callback).execute(new Void[0]);
            }
            return true;
        } else if (callback == null) {
            return false;
        } else {
            callback.onValidateComplete(false, ZaloOAuthResultCode.RESULTCODE_ZALO_OAUTH_INVALID, -1, null);
            return false;
        }
    }

    /* access modifiers changed from: protected */
    public boolean onActivityResult(Activity activity, int requestCode, int i, Intent data) {
        activity.getApplicationContext();
        if (requestCode == 64725) {
            receiveOAuthData(activity, data);
            return true;
        } else if (requestCode != 64726) {
            return false;
        } else {
            receivePermissionData(activity, data);
            return true;
        }
    }

    /* access modifiers changed from: 0000 */
    public void receiveOAuthData(Activity activity, Intent data) {
        isGetZaloOAuth = false;
        try {
            activity.unregisterReceiver(this.receiver);
        } catch (Exception e) {
        }
        if (!this.bIsZaloOutOfDate) {
            this.mStorage.setAccessToken("");
            this.mStorage.setAccessTokenNewAPI("");
            if (data == null) {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_USER_BACK, "");
                return;
            }
            int error = data.getIntExtra("error", 0);
            if (error == 203) {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEB_VIEW_LOGIN_NOT_ALLOWED, "Không thể đăng nhập Zalo.");
            } else if (error == 0) {
                long id = data.getLongExtra("uid", 0);
                String oauth = data.getStringExtra("code");
                boolean isRegister = data.getBooleanExtra("isRegister", false);
                if (this.zaloPluginLogin) {
                    this.mStorage.setZaloPluginOAuthCode(oauth);
                    this.mStorage.setZaloPluginUserId(id);
                }
                if ((this.zaloPluginLogin && TextUtils.isEmpty(this.mStorage.getOAuthCode())) || !this.zaloPluginLogin) {
                    this.mStorage.setOAuthCode(LoginChannel.ZALO.toString(), oauth);
                    this.mStorage.setZaloId(id);
                    try {
                        JSONObject jSONObject = new JSONObject(data.getStringExtra("data"));
                        JSONObject exData = jSONObject.getJSONObject("data");
                        String displayname = exData.getString("display_name");
                        this.mStorage.setIsProtected(exData.optInt("zprotect"));
                        this.mStorage.setZaloDisplayName(displayname);
                    } catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                OauthResponse oauthResponse = new OauthResponse(id, oauth, LoginChannel.ZALO);
                oauthResponse.setRegister(isRegister);
                getOAuthCompleteListener().onGetOAuthComplete(oauthResponse);
            } else if (error != 4) {
                int e3 = ZaloOAuthResultCode.findById(error);
                String errorMsg = "Không thể đăng nhập Zalo.";
                try {
                    String jsData = data.getStringExtra("data");
                    if (!TextUtils.isEmpty(jsData)) {
                        JSONObject jSONObject2 = new JSONObject(jsData);
                        String msg = jSONObject2.getString("errorMsg");
                        if (msg != null && msg.length() > 0) {
                            errorMsg = msg;
                        }
                    }
                } catch (Exception e4) {
                    Log.v("zalo return empty message");
                }
                getOAuthCompleteListener().onAuthenError(e3, errorMsg);
            } else if (this.bIsZaloLoginSuccessful) {
                authenticate(activity, LoginVia.APP, this.zaloPluginLogin, getOAuthCompleteListener());
            } else {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_USER_BACK, "");
            }
        }
    }

    private boolean checkZaloVersionSupport(Context ctx, int versionCode) {
        try {
            if (ctx.getPackageManager().getPackageInfo("com.zing.zalo", 0).versionCode >= versionCode) {
                return true;
            }
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(ctx);
            return false;
        } catch (NameNotFoundException e) {
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(ctx);
            return false;
        }
    }

    /* access modifiers changed from: 0000 */
    public void requestPermissions(Activity activity, Enum<Permissions> permission, OAuthCompleteListener listener) {
        if (checkZaloVersionSupport(activity, 90)) {
            if (listener == null) {
                throw new IllegalArgumentException("OAuthCompleteListener must be set.");
            }
            setOAuthCompleteListener(listener);
            Context ctx = activity.getApplicationContext();
            Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
            i.putExtra("app_id", ZaloSDK.Instance.getAppID());
            i.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
            i.putExtra("pkg_name", AppInfo.getPackageName(ctx));
            i.putExtra("sign_key", AppInfo.getApplicationHashKey(ctx));
            i.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
            i.putExtra("permission", permission.toString());
            activity.startActivityForResult(i, 64726);
        }
    }

    /* access modifiers changed from: 0000 */
    public void receivePermissionData(Activity activity, Intent data) {
        if (data != null) {
            getOAuthCompleteListener().onGetPermissionData(ZaloOAuthResultCode.findById(data.getIntExtra("error", 0)));
            return;
        }
        getOAuthCompleteListener().onGetPermissionData(ZaloOAuthResultCode.RESULTCODE_USER_BACK);
    }

    /* access modifiers changed from: 0000 */
    public void getZaloLoginStatus(final GetZaloLoginStatus callback) {
        if (callback != null) {
            ZTaskExecutor.queueRunnable(new Runnable() {
                public final void run() {
                    j service = new j();
                    Handler handler = new Handler(Looper.getMainLooper());
                    try {
                        final int status = service.a(Authenticator.this.mContext);
                        handler.post(new Runnable() {
                            public final void run() {
                                callback.onGetZaloLoginStatusCompleted(status);
                            }
                        });
                    } catch (Exception e) {
                        Log.e(e);
                        handler.post(new Runnable() {
                            public final void run() {
                                callback.onGetZaloLoginStatusCompleted(-1);
                            }
                        });
                    }
                }
            });
        }
    }

    public OauthStorage getStorage() {
        return this.mStorage;
    }

    public void resetListener() {
        this.wListener = null;
    }
}
