package com.zing.zalo.zalosdk.oauth;

import android.app.Application;
import com.zing.zalo.devicetrackingsdk.AppTracker;
import com.zing.zalo.devicetrackingsdk.AppTracker.Listener;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;

public class ZaloSDKApplication extends Application {
    private static Listener a;
    protected static String appID;
    protected static String facebookAppID = "";

    public void onCreate() {
        super.onCreate();
        a(this);
    }

    public static void wrap(Application app) {
        a(app);
    }

    private static void a(final Application app) {
        appID = AppInfo.getAppId(app);
        facebookAppID = AppInfo.getFacebookAppId(app);
        final BaseAppInfoStorage baseAppInfoStorage = new BaseAppInfoStorage(app);
        final DeviceTracking instance = DeviceTracking.getInstance();
        ServiceMapManager.getInstance().load(app);
        instance.initDeviceTracking(app, baseAppInfoStorage, appID);
        instance.getDeviceId(new GetInfoListener() {
            public final void onGetDeviceIdComplete(String deviceId) {
                SettingsManager.getInstance().init(app, deviceId);
                new AppTracker(app, baseAppInfoStorage, ZaloSDKApplication.appID, instance).setListener(ZaloSDKApplication.a);
                ZaloSDKApplication.a = null;
            }
        });
        Utils.initZingAnalytics(app, appID);
        ZaloSDK.Instance.initialize(app);
    }

    public static void setAppTrackerListener(Listener listener) {
        a = listener;
    }
}
