package com.zing.zalo.zalosdk.auth.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebSettings.RenderPriority;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public final class f extends d {
    private static final Pattern f = Pattern.compile("(wzuin=[\\d\\w]*)");
    WebView b;
    ProgressBar c;
    CookieManager d;
    CookieSyncManager e;

    static class a extends WebViewClient {
        private String a;
        private WeakReference<f> b;

        public a(WeakReference<f> that, String callbackUrl) {
            this.b = that;
            this.a = callbackUrl;
        }

        public final void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.b.get() != null) {
                ((f) this.b.get()).c.setVisibility(8);
            }
        }

        public final void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (this.b.get() != null) {
                ((f) this.b.get()).c.setVisibility(0);
            }
            if (VERSION.SDK_INT >= 11 || url.indexOf(this.a) != 0) {
                super.onPageStarted(view, url, favicon);
            } else {
                a(url);
            }
        }

        public final void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            if (this.b.get() != null) {
                ((f) this.b.get()).c.setVisibility(8);
            }
            if (this.b.get() != null) {
                ((f) this.b.get()).a(-1, 0, "", 0, "", false);
            }
        }

        public final boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (a(url)) {
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        private boolean a(String url) {
            if (url.indexOf(this.a) != 0) {
                return false;
            }
            Uri uri = Uri.parse(url);
            int error = 0;
            long uid = 0;
            String code = "";
            String name = "";
            int zprotect = 0;
            try {
                if (uri.getQueryParameter("error") != null) {
                    error = Integer.parseInt(uri.getQueryParameter("error"));
                } else {
                    uid = Long.parseLong(uri.getQueryParameter("uid"));
                    code = uri.getQueryParameter("code");
                    name = uri.getQueryParameter("display_name");
                    String tmp = uri.getQueryParameter("zprotect");
                    if (tmp != null) {
                        zprotect = Integer.parseInt(tmp);
                    }
                }
            } catch (Exception e) {
                Log.e(e);
            }
            if (this.b.get() != null) {
                ((f) this.b.get()).a(error, uid, code, zprotect, name, false);
            }
            return true;
        }
    }

    public static f b() {
        f fragment = new f();
        fragment.setArguments(new Bundle());
        return fragment;
    }

    public final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.e = CookieSyncManager.createInstance(getActivity());
        this.d = CookieManager.getInstance();
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle bundle) {
        View view = inflater.inflate(Utils.getResourceId(getContext(), "zalosdk_fragment_zalo_web_login", "layout"), container, false);
        Context context = getContext();
        this.b = (WebView) view.findViewById(Utils.getResourceId(context, "zalosdk_login_webview", "id"));
        String str = "http://" + AppInfo.getPackageName(context);
        this.b.getSettings().setJavaScriptEnabled(true);
        this.b.getSettings().setDomStorageEnabled(true);
        this.b.getSettings().setCacheMode(2);
        this.b.getSettings().setRenderPriority(RenderPriority.HIGH);
        this.b.getSettings().setAllowContentAccess(true);
        this.b.setWebViewClient(new a(new WeakReference(this), str));
        try {
            Object userAgentString = this.b.getSettings().getUserAgentString();
            if (userAgentString == null || TextUtils.isEmpty(userAgentString)) {
                str = "ZaloSDK";
            } else {
                str = userAgentString + "ZaloSDK";
            }
            this.b.getSettings().setUserAgentString(str);
        } catch (Exception e) {
            Log.w(e.toString());
        }
        if (VERSION.SDK_INT >= 19) {
            this.b.setLayerType(2, null);
        } else {
            this.b.setLayerType(1, null);
        }
        this.b.loadUrl(a(context));
        this.c = (ProgressBar) view.findViewById(Utils.getResourceId(getContext(), "zalosdk_progress", "id"));
        this.c.setVisibility(8);
        if (getActivity() != null) {
            getActivity().getWindow().setSoftInputMode(18);
        }
        return view;
    }

    private static String a(Context ctx) {
        StringBuilder url = new StringBuilder();
        url.append(ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v3/auth?app_id="));
        try {
            url.append(ZaloSDK.Instance.getAppID());
            url.append("&sign_key=");
            url.append(URLEncoder.encode(AppInfo.getApplicationHashKey(ctx), "UTF-8"));
            url.append("&pkg_name=");
            url.append(URLEncoder.encode(AppInfo.getPackageName(ctx), "UTF-8"));
            url.append("&orientation=");
            url.append(ctx.getResources().getConfiguration().orientation);
            url.append("&zregister=true");
            url.append("&ts=" + System.currentTimeMillis());
            url.append("&lang=" + com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(ctx));
            url.append("#register");
        } catch (UnsupportedEncodingException e) {
            Log.w(e.getMessage());
        }
        return url.toString();
    }

    public final void onResume() {
        super.onResume();
        a(getString(Utils.getResourceId(getActivity(), "txt_regis_acc", "string")));
        a();
    }

    protected final void a(int error, long uid, String oauth, int zprotect, String name, boolean isRegister) {
        super.a(error, uid, oauth, zprotect, name, isRegister);
        if (VERSION.SDK_INT >= 21) {
            this.d.removeSessionCookies(null);
        } else {
            this.d.removeSessionCookie();
        }
    }
}
