package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup.LayoutParams;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.c;
import com.zing.zalo.zalosdk.auth.internal.c.a;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class WebDialog extends Dialog {
    private static final int API_EC_DIALOG_CANCEL = 4201;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 16777215;
    public static final int DEFAULT_THEME = 16973840;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final String DISPLAY_TOUCH = "touch";
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String LOG_TAG = "WebDialog";
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final double MIN_SCALE_FACTOR = 0.5d;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final String UTF8 = "UTF-8";
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    private String code;
    private FrameLayout contentFrameLayout;
    CookieManager cookieManager;
    CookieSyncManager cookieSyncManager;
    private ImageView crossImageView;
    private boolean isDetached;
    private boolean isDismissed;
    private boolean listenerCalled;
    OrientationEventListener myOrientationEventListener;
    int oldWidth;
    private OnCompleteListener onCompleteListener;
    private String query;
    private String queryBody;
    private c spinner;
    private String url;
    private WebView webView;
    ZaloPluginCallback zFeedCallback;

    static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private String action;
        private String applicationId;
        private Context context;
        private OnCompleteListener listener;
        private Bundle parameters;
        private int theme = WebDialog.DEFAULT_THEME;

        protected BuilderBase(Context context, String action) {
            finishInit(context, action, null);
        }

        protected BuilderBase(Context context, String action, Bundle parameters) {
            finishInit(context, action, parameters);
        }

        protected BuilderBase(Context context, String str, String action, Bundle parameters) {
            finishInit(context, action, parameters);
        }

        public CONCRETE setTheme(int theme) {
            this.theme = theme;
            return this;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener listener) {
            this.listener = listener;
            return this;
        }

        public WebDialog build() {
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected int getTheme() {
            return this.theme;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        private void finishInit(Context context, String action, Bundle parameters) {
            this.context = context;
            this.action = action;
            if (parameters != null) {
                this.parameters = parameters;
            } else {
                this.parameters = new Bundle();
            }
        }
    }

    public static class Builder extends BuilderBase<Builder> {
        public /* bridge */ /* synthetic */ WebDialog build() {
            return super.build();
        }

        public Builder(Context context, String action) {
            super(context, action);
        }

        public Builder(Context context, String action, Bundle parameters) {
            super(context, action, parameters);
        }

        public Builder(Context context, String applicationId, String action, Bundle parameters) {
            super(context, applicationId, action, parameters);
        }
    }

    class DialogWebViewClient extends WebViewClient {
        private DialogWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            WebDialog.this.sendErrorToListener(null);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
            handler.cancel();
            WebDialog.this.sendErrorToListener(null);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
            if (url.contains("plugin.zaloapp.com/webview/callback")) {
                view.stopLoading();
                if (WebDialog.this.zFeedCallback != null) {
                    Bundle b = parseUrlQueryString(Uri.parse(url).getQuery());
                    boolean isSuccess = WebDialog.DISABLE_SSL_CHECK_FOR_TESTING;
                    int error_code = 0;
                    String strErrorCode = b.getString("error_code");
                    if (!TextUtils.isEmpty(strErrorCode)) {
                        try {
                            error_code = Integer.parseInt(strErrorCode);
                        } catch (Exception e) {
                            error_code = 0;
                        }
                    }
                    if (error_code == 0) {
                        isSuccess = true;
                    }
                    WebDialog.this.zFeedCallback.onResult(isSuccess, error_code, b.getString("error_message"), b.getString("result_data"));
                }
            }
        }

        public Bundle parseUrlQueryString(String queryString) {
            Bundle params = new Bundle();
            if (!TextUtils.isEmpty(queryString)) {
                for (String split : queryString.split("&")) {
                    String[] keyValuePair = split.split("=");
                    try {
                        if (keyValuePair.length == 2) {
                            params.putString(URLDecoder.decode(keyValuePair[0], WebDialog.UTF8), URLDecoder.decode(keyValuePair[1], WebDialog.UTF8));
                        } else if (keyValuePair.length == 1) {
                            params.putString(URLDecoder.decode(keyValuePair[0], WebDialog.UTF8), "");
                        }
                    } catch (UnsupportedEncodingException e) {
                    }
                }
            }
            return params;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }
    }

    public static class FeedDialogBuilder extends BuilderBase<FeedDialogBuilder> {
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String LINK_PARAM = "link";
        private static final String NAME_PARAM = "name";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String TO_PARAM = "to";

        public /* bridge */ /* synthetic */ WebDialog build() {
            return super.build();
        }

        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        public FeedDialogBuilder(Context context, Bundle parameters) {
            super(context, FEED_DIALOG, parameters);
        }

        public FeedDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, FEED_DIALOG, parameters);
        }

        public FeedDialogBuilder setFrom(String id) {
            getParameters().putString(FROM_PARAM, id);
            return this;
        }

        public FeedDialogBuilder setTo(String id) {
            getParameters().putString(TO_PARAM, id);
            return this;
        }

        public FeedDialogBuilder setLink(String link) {
            getParameters().putString(LINK_PARAM, link);
            return this;
        }

        public FeedDialogBuilder setPicture(String picture) {
            getParameters().putString(PICTURE_PARAM, picture);
            return this;
        }

        public FeedDialogBuilder setSource(String source) {
            getParameters().putString(SOURCE_PARAM, source);
            return this;
        }

        public FeedDialogBuilder setName(String name) {
            getParameters().putString(NAME_PARAM, name);
            return this;
        }

        public FeedDialogBuilder setCaption(String caption) {
            getParameters().putString(CAPTION_PARAM, caption);
            return this;
        }

        public FeedDialogBuilder setDescription(String description) {
            getParameters().putString(DESCRIPTION_PARAM, description);
            return this;
        }
    }

    public interface OnCompleteListener {
        void onComplete(Bundle bundle);
    }

    public static class RequestsDialogBuilder extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String DATA_PARAM = "data";
        private static final String MESSAGE_PARAM = "message";
        private static final String TITLE_PARAM = "title";
        private static final String TO_PARAM = "to";

        public /* bridge */ /* synthetic */ WebDialog build() {
            return super.build();
        }

        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        public RequestsDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, APPREQUESTS_DIALOG, parameters);
        }

        public RequestsDialogBuilder setMessage(String message) {
            getParameters().putString(MESSAGE_PARAM, message);
            return this;
        }

        public RequestsDialogBuilder setTo(String id) {
            getParameters().putString(TO_PARAM, id);
            return this;
        }

        public RequestsDialogBuilder setData(String data) {
            getParameters().putString(DATA_PARAM, data);
            return this;
        }

        public RequestsDialogBuilder setTitle(String title) {
            getParameters().putString(TITLE_PARAM, title);
            return this;
        }
    }

    public WebDialog(Context context, String url) {
        this(context, url, DEFAULT_THEME);
    }

    public WebDialog(Context context, String url, int theme) {
        super(context, theme);
        this.listenerCalled = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDismissed = DISABLE_SSL_CHECK_FOR_TESTING;
        this.oldWidth = 0;
        this.url = url;
    }

    public WebDialog(Context context, String str, Bundle parameters, int theme, OnCompleteListener listener) {
        super(context, theme);
        this.listenerCalled = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDismissed = DISABLE_SSL_CHECK_FOR_TESTING;
        this.oldWidth = 0;
        if (parameters == null) {
            parameters = new Bundle();
        }
        this.query = parameters.getString(EXTRA_QUERY);
        this.queryBody = parameters.getString(EXTRA_REQUEST_BODY);
        this.query = this.query == null ? "" : this.query;
        this.code = parameters.getString(EXTRA_OAUTH_CODE);
        this.url = "https://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = listener;
    }

    public void setFeedCallBackListener(ZaloPluginCallback callback) {
        this.zFeedCallback = callback;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void dismiss() {
        if (!this.isDismissed) {
            this.isDismissed = true;
            if (this.myOrientationEventListener != null) {
                this.myOrientationEventListener.disable();
            }
            if (!this.listenerCalled) {
                sendCancelToListener();
            }
            if (this.webView != null) {
                this.webView.stopLoading();
            }
            if (!this.isDetached) {
                if (this.spinner.isShowing()) {
                    this.spinner.dismiss();
                }
                super.dismiss();
            }
        }
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.spinner = new c(getContext(), new a() {
            public void onClose() {
            }
        });
        this.spinner.requestWindowFeature(1);
        this.spinner.setOnCancelListener(new OnCancelListener() {
            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.dismiss();
            }
        });
        requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(getContext());
        calculateSize();
        getWindow().setGravity(17);
        getWindow().setSoftInputMode(16);
        createCrossImage();
        this.crossImageView.getDrawable().getIntrinsicWidth();
        setUpWebView(0);
        this.contentFrameLayout.addView(this.crossImageView, new LayoutParams(-2, -2));
        setContentView(this.contentFrameLayout);
        this.crossImageView.bringToFront();
        this.myOrientationEventListener = new OrientationEventListener(getContext(), 3) {
            public void onOrientationChanged(int arg0) {
                if (arg0 > 350 || arg0 < 10) {
                    WebDialog.this.updateLayout();
                } else if (arg0 < 100 && arg0 > 80) {
                    WebDialog.this.updateLayout();
                } else if (arg0 > 170 && arg0 < 190) {
                    WebDialog.this.updateLayout();
                } else if (arg0 > 260 && arg0 < 280) {
                    WebDialog.this.updateLayout();
                }
            }
        };
        if (this.myOrientationEventListener.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        setOnCancelListener(new OnCancelListener() {
            public void onCancel(DialogInterface dialogInterface) {
            }
        });
        getWindow().addFlags(2);
        getWindow().getAttributes().dimAmount = 0.7f;
    }

    private void updateLayout() {
        if (this.oldWidth != getScreenWidth()) {
            calculateSize();
            this.oldWidth = getScreenWidth();
        }
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    private int getScreenWidth() {
        Display display = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return metrics.widthPixels;
    }

    private void calculateSize() {
        Display display = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        if (Utilities.isTablet(getContext())) {
            int dialogWidth;
            int dialogHeight = (height * 2) / 3;
            if (Utilities.isPortait(getContext())) {
                dialogWidth = (width * 2) / 3;
                if (dialogWidth < 300) {
                    dialogWidth = 300;
                }
                if (dialogHeight < 400) {
                    dialogHeight = 400;
                }
            } else {
                dialogWidth = (width * 1) / 2;
                if (dialogWidth < 400) {
                    dialogWidth = 400;
                }
                if (dialogHeight < 300) {
                    dialogHeight = 300;
                }
            }
            getWindow().setLayout(dialogWidth, dialogHeight);
            return;
        }
        getWindow().setLayout(width, height - 80);
    }

    private int getScaledSize(int screenSize, float density, int noPaddingSize, int maxPaddingSize) {
        double scaleFactor;
        int scaledSize = (int) (((float) screenSize) / density);
        if (scaledSize <= noPaddingSize) {
            scaleFactor = 1.0d;
        } else if (scaledSize >= maxPaddingSize) {
            scaleFactor = MIN_SCALE_FACTOR;
        } else {
            scaleFactor = MIN_SCALE_FACTOR + ((((double) (maxPaddingSize - scaledSize)) / ((double) (maxPaddingSize - noPaddingSize))) * MIN_SCALE_FACTOR);
        }
        return (int) (((double) screenSize) * scaleFactor);
    }

    protected void sendSuccessToListener(Bundle values) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(values);
            dismiss();
        }
    }

    protected void sendErrorToListener(Throwable th) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(null);
            dismiss();
        }
    }

    protected void sendCancelToListener() {
        sendErrorToListener(null);
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(getContext());
        this.crossImageView.setOnClickListener(new OnClickListener() {
            public void onClick(View view) {
                WebDialog.this.dismiss();
            }
        });
        this.crossImageView.setImageDrawable(getContext().getResources().getDrawable(R.drawable.ic_close_web));
        this.crossImageView.setVisibility(4);
        this.crossImageView.setPadding(convertDpToPixel(7.0f, getContext()), convertDpToPixel(7.0f, getContext()), 0, 0);
    }

    public static int convertDpToPixel(float dp, Context context) {
        return (int) ((((float) context.getResources().getDisplayMetrics().densityDpi) / 160.0f) * dp);
    }

    private void setupCookie() {
        this.cookieSyncManager = CookieSyncManager.createInstance(getContext());
        this.cookieManager = CookieManager.getInstance();
        if (VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        } else {
            this.cookieManager.setAcceptCookie(true);
        }
        String baseUrl = "https://plugin.zaloapp.com";
        Log.i("debuglog", "cookie: " + this.cookieManager.getCookie(baseUrl));
        this.cookieManager.removeAllCookie();
        this.cookieManager.setCookie(baseUrl, "code=" + this.code);
        if (VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            this.cookieSyncManager.sync();
        }
        Log.i("debuglog", "set cookie: code=" + this.code);
        Log.i("debuglog", "cookies: " + this.cookieManager.getCookie(baseUrl));
    }

    @SuppressLint({"SetJavaScriptEnabled"})
    private void setUpWebView(int margin) {
        LinearLayout webViewContainer = new LinearLayout(getContext());
        this.webView = new WebView(getContext()) {
            public void onWindowFocusChanged(boolean hasWindowFocus) {
                try {
                    super.onWindowFocusChanged(hasWindowFocus);
                } catch (NullPointerException e) {
                }
            }
        };
        this.webView.setVerticalScrollBarEnabled(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.setHorizontalScrollBarEnabled(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.setWebViewClient(new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        setupCookie();
        this.webView.postUrl(this.url, this.queryBody.getBytes());
        this.webView.setLayoutParams(new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.getSettings().setSaveFormData(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.getSettings().setDatabaseEnabled(true);
        if (VERSION.SDK_INT < 19) {
            this.webView.getSettings().setDatabasePath(getContext().getDir("database", 0).getPath());
        }
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView(this.webView);
        webViewContainer.setBackgroundColor(BACKGROUND_WHITE);
        this.contentFrameLayout.addView(webViewContainer);
    }
}
