package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.app.Application.ActivityLifecycleCallbacks;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.zing.zalo.zalosdk.auth.internal.n;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.ZTaskExecutor;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

public class Authenticator {
    static boolean isGetZaloOAuth = false;
    private boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    private a callbackAppLifeCycle;
    private boolean isRegisBroadcastReceiver = false;
    protected Context mContext;
    private LocalizedString mLocalizedString;
    private OauthStorage mStorage;
    private String nameActivtyAuthenticate = "";
    public String nameActivtyCheckAuthen = "";
    public BroadcastReceiver receiver = new BroadcastReceiver(this) {
        final /* synthetic */ Authenticator a;

        {
            this.a = this$0;
        }

        public final void onReceive(Context context, Intent intent) {
            if ("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP".equals(intent.getAction())) {
                this.a.bIsZaloLoginSuccessful = intent.getBooleanExtra("loginSuccessful", false);
            }
        }
    };
    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;
    private boolean zaloPluginLogin = false;

    class a implements ActivityLifecycleCallbacks {
        final /* synthetic */ Authenticator a;

        a(Authenticator this$0) {
            this.a = this$0;
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityStarted(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityStopped(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
            String nameActivity = activity.getClass().getSimpleName();
            if (this.a.nameActivtyAuthenticate != null && this.a.nameActivtyAuthenticate.length() > 0 && this.a.nameActivtyAuthenticate.equals(nameActivity)) {
                Log.i("debuglog", "unregister--------------------------------");
                this.a.unregisterBroadcastReceiver(activity);
            }
            if (this.a.nameActivtyCheckAuthen != null && this.a.nameActivtyCheckAuthen.length() > 0) {
                this.a.nameActivtyCheckAuthen.equals(nameActivity);
            }
        }
    }

    class b extends AsyncTask<Void, Void, String> {
        String a;
        final /* synthetic */ Authenticator b;
        private final String c;

        private b(Authenticator authenticator) {
            this.b = authenticator;
            this.c = "/v2/zalo/oauth_logout";
        }

        protected final /* synthetic */ Object doInBackground(Object[] objArr) {
            return a();
        }

        protected final /* synthetic */ void onPostExecute(Object obj) {
            String str = (String) obj;
            super.onPostExecute(str);
            try {
                new JSONObject(str).getInt("error");
            } catch (Exception e) {
            }
        }

        private String a() {
            HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v2/zalo/oauth_logout"));
            request.addParams("appId", String.valueOf(ZaloSDKApplication.appID));
            request.addParams("oauthCode", this.a);
            request.addParams("frm", "sdk");
            JSONObject dataJsonObject = new JSONObject();
            try {
                dataJsonObject.put("pl", "android");
                dataJsonObject.put("sdkv", ZaloSDK.Instance.getVersion());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            request.addParams("data", dataJsonObject.toString());
            return request.getText();
        }
    }

    class c extends AsyncTask<Void, Void, String> {
        ValidateOAuthCodeCallback a;
        String b;
        final /* synthetic */ Authenticator c;

        protected final /* synthetic */ void onPostExecute(Object obj) {
            String str = (String) obj;
            super.onPostExecute(str);
            try {
                JSONObject jSONObject = new JSONObject(str);
                int i = jSONObject.getInt("error");
                if (i == 0) {
                    jSONObject = jSONObject.getJSONObject("data");
                    long j = jSONObject.getLong("uid");
                    if (j == this.c.mStorage.getZaloId()) {
                        int optInt = jSONObject.optInt("zcert");
                        int optInt2 = jSONObject.optInt("zprotect");
                        this.c.mStorage.setIsGuestCertificated(optInt);
                        this.c.mStorage.setIsProtected(optInt2);
                    }
                    this.a.onValidateComplete(true, 0, j, this.b);
                    return;
                }
                this.a.onValidateComplete(false, i, -1, null);
            } catch (Exception e) {
                this.a.onValidateComplete(false, ZaloOAuthResultCode.RESULTCODE_UNEXPECTED_ERROR, -1, null);
            }
        }

        c(Authenticator authenticator, String code, ValidateOAuthCodeCallback callback) {
            this.c = authenticator;
            if (callback == null) {
                throw new IllegalArgumentException("callback can't be null");
            }
            this.a = callback;
            this.b = code;
        }

        protected final /* synthetic */ Object doInBackground(Object[] objArr) {
            HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor("oauth_http_s", "/v2/mobile/validate_oauth_code"));
            httpClientRequest.addParams("app_id", String.valueOf(ZaloSDKApplication.appID));
            httpClientRequest.addParams("code", this.b);
            httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
            httpClientRequest.addParams("frm", "sdk");
            return httpClientRequest.getText();
        }
    }

    Authenticator(Context ctx, OauthStorage storage, LocalizedString localizedString) {
        this.mContext = ctx;
        this.mStorage = storage;
        this.mLocalizedString = localizedString;
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        if (this.wListener == null || this.wListener.get() == null) {
            return new OAuthCompleteListener();
        }
        return (OAuthCompleteListener) this.wListener.get();
    }

    public void setOAuthCompleteListener(OAuthCompleteListener listener) {
        this.wListener = new WeakReference(listener);
    }

    protected OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        if (this.wLoginFormListener == null || this.wLoginFormListener.get() == null) {
            return new OAuthCompleteListener();
        }
        return (OAuthCompleteListener) this.wLoginFormListener.get();
    }

    protected void setLoginFormOAuthCompleteListener(OAuthCompleteListener listener) {
        this.wLoginFormListener = new WeakReference(listener);
    }

    void authenticate(Activity activity, LoginVia loginVia, boolean zaloPluginLogin, OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyAuthenticate = activity.getClass().getSimpleName();
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        this.zaloPluginLogin = zaloPluginLogin;
        sendOAuthRequest(activity, loginVia);
    }

    void registerZalo(Activity activity, OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyAuthenticate = activity.getClass().getSimpleName();
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        activity.startActivityForResult(WebLoginActivity.a(activity, true), 64725);
    }

    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        boolean isZaloInstalled = AppInfo.isPackageExists(activity, "com.zing.zalo");
        switch (loginVia) {
            case APP:
                if (isZaloInstalled) {
                    loginViaApp(activity);
                    return;
                } else {
                    getOAuthCompleteListener().onZaloNotInstalled(activity);
                    return;
                }
            case WEB:
                loginViaWeb(activity);
                return;
            case APP_OR_WEB:
                if (!isZaloInstalled) {
                    loginViaWeb(activity);
                    return;
                } else if (SettingsManager.getInstance().isUseWebViewUnLoginZalo(this.mContext)) {
                    loginViaAppOrWebIfNotLogin(activity);
                    return;
                } else {
                    loginViaApp(activity);
                    return;
                }
            default:
                return;
        }
    }

    private void loginViaAppOrWebIfNotLogin(final Activity activity) {
        getZaloLoginStatus(new GetZaloLoginStatus(this) {
            final /* synthetic */ Authenticator b;

            public final void onGetZaloLoginStatusCompleted(int status) {
                if (status == 1) {
                    this.b.loginViaApp(activity);
                } else {
                    this.b.loginViaWeb(activity);
                }
            }
        });
    }

    private void loginViaApp(Activity activity) {
        try {
            activity.unregisterReceiver(this.receiver);
        } catch (Exception e) {
            Log.v(e.toString());
        }
        try {
            activity.registerReceiver(this.receiver, new IntentFilter("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP"));
            Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
            i.putExtra("android.intent.extra.UID", AppInfo.getAppIdLong(this.mContext));
            activity.startActivityForResult(i, 64725);
        } catch (ActivityNotFoundException e2) {
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        } catch (SecurityException e3) {
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        }
    }

    private void loginViaWeb(Activity activity) {
        if (Utilities.a(activity)) {
            try {
                CookieManager.getInstance();
                activity.startActivityForResult(WebLoginActivity.a(activity, false), 64725);
                return;
            } catch (Exception ex) {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR, ex.getMessage());
                return;
            }
        }
        getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_NO_NETWORK, this.mLocalizedString.getNoNetworkMessage());
    }

    protected void unauthenticate() {
        try {
            b task = new b();
            task.a = this.mStorage.getOAuthCode();
            if (!TextUtils.isEmpty(task.a)) {
                task.execute(null);
            }
            long uid = ZaloSDK.Instance.getZaloId();
            this.mContext.getSharedPreferences("zacPref", 0).edit().remove("MAX_PAGING" + uid).remove("GIFTCODE_EXPIRED_TIME" + uid).remove("CACHE_CODE_LIST" + uid).remove("CURRENT_PAGE" + uid).apply();
            this.mStorage.setAccessToken("");
            this.mStorage.setAccessTokenNewAPI("");
            this.mStorage.setOAuthCode("", "");
            this.mStorage.setZaloId(0);
            this.mStorage.setZaloDisplayName("");
            this.mStorage.setZaloPluginOAuthCode("");
            this.mStorage.setSocialId("");
        } catch (Exception e) {
        }
    }

    boolean isAuthenticate(String code, ValidateOAuthCodeCallback callback) {
        if (code != null && code.length() != 0) {
            if (callback != null) {
                new c(this, code, callback).execute(new Void[0]);
            }
            return true;
        } else if (callback == null) {
            return false;
        } else {
            callback.onValidateComplete(false, ZaloOAuthResultCode.RESULTCODE_ZALO_OAUTH_INVALID, -1, null);
            return false;
        }
    }

    protected boolean onActivityResult(Activity activity, int requestCode, int i, Intent data) {
        activity.getApplicationContext();
        if (requestCode == 64725) {
            receiveOAuthData(activity, data);
            return true;
        } else if (requestCode != 64726) {
            return false;
        } else {
            receivePermissionData(activity, data);
            return true;
        }
    }

    void receiveOAuthData(Activity activity, Intent data) {
        isGetZaloOAuth = false;
        try {
            this.isRegisBroadcastReceiver = false;
            activity.unregisterReceiver(this.receiver);
        } catch (Exception e) {
        }
        if (!this.bIsZaloOutOfDate) {
            this.mStorage.setAccessToken("");
            this.mStorage.setAccessTokenNewAPI("");
            if (data == null) {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_USER_BACK, "");
                return;
            }
            int error = data.getIntExtra("error", 0);
            if (error == 203) {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEB_VIEW_LOGIN_NOT_ALLOWED, "Không thể đăng nhập Zalo.");
            } else if (error == 0) {
                long id = data.getLongExtra("uid", 0);
                String oauth = data.getStringExtra("code");
                boolean isRegister = data.getBooleanExtra("isRegister", false);
                if (this.zaloPluginLogin) {
                    this.mStorage.setZaloPluginOAuthCode(oauth);
                    this.mStorage.setZaloPluginUserId(id);
                }
                if ((this.zaloPluginLogin && TextUtils.isEmpty(this.mStorage.getOAuthCode())) || !this.zaloPluginLogin) {
                    this.mStorage.setOAuthCode(LoginChannel.ZALO.toString(), oauth);
                    this.mStorage.setZaloId(id);
                    try {
                        JSONObject exData = new JSONObject(data.getStringExtra("data")).getJSONObject("data");
                        String displayname = exData.getString("display_name");
                        this.mStorage.setIsProtected(exData.optInt("zprotect"));
                        this.mStorage.setZaloDisplayName(displayname);
                    } catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                OauthResponse oauthResponse = new OauthResponse(id, oauth, LoginChannel.ZALO);
                oauthResponse.setRegister(isRegister);
                getOAuthCompleteListener().onGetOAuthComplete(oauthResponse);
            } else if (error != 4) {
                int e3 = ZaloOAuthResultCode.findById(error);
                String errorMsg = "Không thể đăng nhập Zalo.";
                try {
                    String jsData = data.getStringExtra("data");
                    if (!TextUtils.isEmpty(jsData)) {
                        String msg = new JSONObject(jsData).getString("errorMsg");
                        if (msg != null && msg.length() > 0) {
                            errorMsg = msg;
                        }
                    }
                } catch (Exception e4) {
                    Log.v("zalo return empty message");
                }
                getOAuthCompleteListener().onAuthenError(e3, errorMsg);
            } else if (this.bIsZaloLoginSuccessful) {
                authenticate(activity, LoginVia.APP, this.zaloPluginLogin, getOAuthCompleteListener());
            } else {
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_USER_BACK, "");
            }
        }
    }

    private boolean checkZaloVersionSupport(Context ctx, int versionCode) {
        try {
            if (ctx.getPackageManager().getPackageInfo("com.zing.zalo", 0).versionCode >= versionCode) {
                return true;
            }
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(ctx);
            return false;
        } catch (NameNotFoundException e) {
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(ctx);
            return false;
        }
    }

    void requestPermissions(Activity activity, Enum<Permissions> permission, OAuthCompleteListener listener) {
        if (!checkZaloVersionSupport(activity, 90)) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        setOAuthCompleteListener(listener);
        Context ctx = activity.getApplicationContext();
        Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
        i.putExtra("app_id", ZaloSDK.Instance.getAppID());
        i.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
        i.putExtra("pkg_name", AppInfo.getPackageName(ctx));
        i.putExtra("sign_key", AppInfo.getApplicationHashKey(ctx));
        i.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
        i.putExtra("permission", permission.toString());
        activity.startActivityForResult(i, 64726);
    }

    void receivePermissionData(Activity activity, Intent data) {
        if (data != null) {
            getOAuthCompleteListener().onGetPermissionData(ZaloOAuthResultCode.findById(data.getIntExtra("error", 0)));
            return;
        }
        getOAuthCompleteListener().onGetPermissionData(ZaloOAuthResultCode.RESULTCODE_USER_BACK);
    }

    void getZaloLoginStatus(final GetZaloLoginStatus callback) {
        if (callback != null) {
            ZTaskExecutor.queueRunnable(new Runnable(this) {
                final /* synthetic */ Authenticator b;

                public final void run() {
                    try {
                        callback.onGetZaloLoginStatusCompleted(new n().a(this.b.mContext));
                    } catch (Exception e) {
                        Log.e(e);
                    }
                }
            });
        }
    }

    protected String getActivityNameAuthenticate() {
        return this.nameActivtyAuthenticate;
    }

    public void unregisterBroadcastReceiver(Activity activity) {
        try {
            if (this.isRegisBroadcastReceiver) {
                activity.unregisterReceiver(this.receiver);
            }
        } catch (Exception e) {
        }
    }

    public void registerAppLifeCycle(Application application) {
        if (!Utils.belowSandwich() && this.callbackAppLifeCycle == null) {
            this.callbackAppLifeCycle = new a(this);
            application.registerActivityLifecycleCallbacks(this.callbackAppLifeCycle);
        }
    }

    public void unregisterAppLifeCycle(Application application) {
        if (!Utils.belowSandwich() && this.callbackAppLifeCycle != null) {
            try {
                application.unregisterActivityLifecycleCallbacks(this.callbackAppLifeCycle);
            } catch (Exception e) {
            }
        }
    }

    public OauthStorage getStorage() {
        return this.mStorage;
    }

    public void resetListener() {
        this.wListener = null;
    }
}
