package com.zing.zalo.zalosdk.oauth;

public class ZaloOAuthResultCode {
    public static final int RESULTCODE_ACCESS_DENIED = -1005;
    public static final int RESULTCODE_APPLICATION_IS_NOT_APPROVED = -1014;
    public static final int RESULTCODE_CANT_LOGIN_FACEBOOK = -1105;
    public static final int RESULTCODE_CANT_LOGIN_GOOGLE = -1205;
    public static final int RESULTCODE_CANT_LOGIN_ZINGME = -1023;
    public static final int RESULTCODE_CREATE_ACCESS_TOKEN_FAILED = -1008;
    public static final int RESULTCODE_CREATE_OAUTH_FAILED = -1007;
    public static final int RESULTCODE_INVALID_APP_ID = -1001;
    public static final int RESULTCODE_INVALID_OAUTH_CODE = -1004;
    public static final int RESULTCODE_INVALID_PARAM = -1002;
    public static final int RESULTCODE_INVALID_SECRET_KEY = -1003;
    public static final int RESULTCODE_INVALID_SESSION = -1006;
    public static final int RESULTCODE_NO_ERROR = 0;
    public static final int RESULTCODE_PERMISSION_DENIED = -201;
    public static final int RESULTCODE_REGIS_CERTIFICATE_GUEST_SUCCESS = 8001;
    public static final int RESULTCODE_REGIS_IDENTIFY_CARD_NUMBER_SUCCESS = 8000;
    public static final int RESULTCODE_UNEXPECTED_ERROR = -1000;
    public static final int RESULTCODE_USER_BACK = -1111;
    public static final int RESULTCODE_USER_CONSENT_FAILED = -1009;
    public static final int RESULTCODE_USER_REJECT = -1114;
    public static final int RESULTCODE_ZALO_OAUTH_INVALID = -1019;
    public static final int RESULTCODE_ZALO_UNKNOWN_ERROR = -1112;
    public static final int RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR = -1020;
    public static final int RESULTCODE_ZALO_WEBVIEW_NO_NETWORK = -1021;
    public static final int RESULTCODE_ZALO_WEB_VIEW_LOGIN_NOT_ALLOWED = -1118;

    public static int findById(int rawCode) {
        switch (rawCode) {
            case RESULTCODE_CANT_LOGIN_FACEBOOK /*-1105*/:
                return RESULTCODE_CANT_LOGIN_FACEBOOK;
            case RESULTCODE_CANT_LOGIN_ZINGME /*-1023*/:
                return RESULTCODE_CANT_LOGIN_ZINGME;
            case RESULTCODE_ZALO_OAUTH_INVALID /*-1019*/:
                return RESULTCODE_ZALO_OAUTH_INVALID;
            case RESULTCODE_APPLICATION_IS_NOT_APPROVED /*-1014*/:
                return RESULTCODE_APPLICATION_IS_NOT_APPROVED;
            case RESULTCODE_USER_CONSENT_FAILED /*-1009*/:
                return RESULTCODE_USER_CONSENT_FAILED;
            case RESULTCODE_CREATE_ACCESS_TOKEN_FAILED /*-1008*/:
                return RESULTCODE_CREATE_ACCESS_TOKEN_FAILED;
            case RESULTCODE_CREATE_OAUTH_FAILED /*-1007*/:
                return RESULTCODE_CREATE_OAUTH_FAILED;
            case RESULTCODE_INVALID_SESSION /*-1006*/:
                return RESULTCODE_INVALID_SESSION;
            case RESULTCODE_ACCESS_DENIED /*-1005*/:
                return RESULTCODE_ACCESS_DENIED;
            case RESULTCODE_INVALID_OAUTH_CODE /*-1004*/:
                return RESULTCODE_INVALID_OAUTH_CODE;
            case RESULTCODE_INVALID_SECRET_KEY /*-1003*/:
                return RESULTCODE_INVALID_SECRET_KEY;
            case RESULTCODE_INVALID_PARAM /*-1002*/:
                return RESULTCODE_INVALID_PARAM;
            case RESULTCODE_INVALID_APP_ID /*-1001*/:
                return RESULTCODE_INVALID_APP_ID;
            case RESULTCODE_UNEXPECTED_ERROR /*-1000*/:
                return RESULTCODE_UNEXPECTED_ERROR;
            case RESULTCODE_PERMISSION_DENIED /*-201*/:
                return RESULTCODE_PERMISSION_DENIED;
            case RESULTCODE_NO_ERROR /*0*/:
                return 0;
            case 1:
                return RESULTCODE_ZALO_UNKNOWN_ERROR;
            case 3:
                return RESULTCODE_USER_REJECT;
            default:
                return rawCode;
        }
    }
}
