package com.zing.zalo.zalosdk.auth.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebSettings.RenderPriority;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Base64;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class h extends f {
    private static final Pattern g = Pattern.compile("(wzuin=[\\d\\w]*)");
    protected c b;
    WebView c;
    ProgressBar d;
    CookieManager e;
    CookieSyncManager f;
    private String h;
    private String i;

    public static class a {
        private WeakReference<c> a;

        public a(WeakReference<c> weakReference) {
            this.a = weakReference;
        }

        @JavascriptInterface
        public final void register() {
            if (this.a.get() != null) {
                this.a.get();
            }
        }

        @JavascriptInterface
        public final void forgotPassword(String str) {
            if (this.a.get() != null) {
                this.a.get();
            }
        }
    }

    static class b extends WebViewClient {
        private String a;
        private WeakReference<h> b;

        public b(WeakReference<h> that, String callbackUrl) {
            this.b = that;
            this.a = callbackUrl;
        }

        public final void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.b.get() != null) {
                ((h) this.b.get()).d.setVisibility(8);
            }
        }

        public final void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (this.b.get() != null) {
                ((h) this.b.get()).d.setVisibility(0);
            }
            if (VERSION.SDK_INT >= 11 || url.indexOf(this.a) != 0) {
                super.onPageStarted(view, url, favicon);
            } else {
                a(url);
            }
        }

        public final void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            if (this.b.get() != null) {
                ((h) this.b.get()).d.setVisibility(8);
            }
            if (this.b.get() != null) {
                ((h) this.b.get()).a(-1, 0, "", 0, "");
            }
        }

        public final boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.i("debuglog", "WebLoginActivity.java ---- shouldOverrideUrlLoading: url: " + url);
            if (a(url)) {
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        private boolean a(String url) {
            if (url.indexOf(this.a) != 0) {
                return false;
            }
            Log.i("debuglog", "register url: " + url);
            Uri uri = Uri.parse(url);
            int error = 0;
            long uid = 0;
            String code = "";
            String name = "";
            int zprotect = 0;
            try {
                if (uri.getQueryParameter("error") != null) {
                    error = Integer.parseInt(uri.getQueryParameter("error"));
                } else {
                    uid = Long.parseLong(uri.getQueryParameter("uid"));
                    code = uri.getQueryParameter("code");
                    name = uri.getQueryParameter("display_name");
                    String tmp = uri.getQueryParameter("zprotect");
                    if (tmp != null) {
                        zprotect = Integer.parseInt(tmp);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (this.b.get() != null) {
                ((h) this.b.get()).a(error, uid, code, zprotect, name);
            }
            return true;
        }
    }

    public interface c extends com.zing.zalo.zalosdk.auth.internal.f.a {
    }

    public static h b() {
        h fragment = new h();
        Bundle args = new Bundle();
        args.putString("zalert", null);
        fragment.setArguments(args);
        return fragment;
    }

    public final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.i = URLEncoder.encode(Base64.encode(getArguments().getString("zalert").getBytes("UTF-8")), "UTF-8");
        } catch (Exception e) {
            this.i = null;
        }
        this.f = CookieSyncManager.createInstance(getActivity());
        this.e = CookieManager.getInstance();
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle bundle) {
        String str;
        View view = inflater.inflate(Utils.getResourceId(getContext(), "zalosdk_fragment_zalo_web_login", "layout"), container, false);
        Context context = getContext();
        this.c = (WebView) view.findViewById(Utils.getResourceId(context, "zalosdk_login_webview", "id"));
        if (VERSION.SDK_INT >= 21) {
            this.e.setAcceptThirdPartyCookies(this.c, true);
        } else {
            this.e.setAcceptCookie(true);
        }
        String[] strArr = new String[]{"id.zaloapp.com", "id.zalo.me"};
        Object obj = null;
        for (int i = 0; i < 2; i++) {
            String str2 = strArr[i];
            CharSequence cookie = this.e.getCookie(str2);
            if (!(cookie == null || cookie.length() == 0)) {
                Matcher matcher = g.matcher(cookie);
                if (matcher.find()) {
                    obj = 1;
                    String group = matcher.group(1);
                    this.e.removeAllCookie();
                    this.e.setCookie(str2, group);
                    Log.i("debuglog", "found set cookie: " + group);
                    break;
                }
            }
        }
        if (obj == null) {
            this.e.removeAllCookie();
        }
        if (VERSION.SDK_INT >= 21) {
            this.e.flush();
        } else {
            this.f.sync();
        }
        this.h = "http://" + AppInfo.getPackageName(context);
        this.c.getSettings().setJavaScriptEnabled(true);
        this.c.getSettings().setDomStorageEnabled(true);
        this.c.getSettings().setCacheMode(2);
        this.c.getSettings().setRenderPriority(RenderPriority.HIGH);
        if (VERSION.SDK_INT > 10) {
            this.c.getSettings().setAllowContentAccess(true);
        }
        this.c.setWebViewClient(new b(new WeakReference(this), this.h));
        this.c.addJavascriptInterface(new a(new WeakReference(this.b)), "zdk");
        try {
            obj = this.c.getSettings().getUserAgentString();
            if (obj == null || TextUtils.isEmpty(obj)) {
                str = "ZaloSDK";
            } else {
                str = obj + "ZaloSDK";
            }
            this.c.getSettings().setUserAgentString(str);
        } catch (Exception e) {
        }
        if (!TextUtils.isEmpty(this.i)) {
            this.i = "";
        }
        if (VERSION.SDK_INT >= 19) {
            this.c.setLayerType(2, null);
        } else {
            this.c.setLayerType(1, null);
        }
        str = a(context);
        this.c.loadUrl(str);
        Log.i("debuglog", "generate url: " + str);
        this.d = (ProgressBar) view.findViewById(Utils.getResourceId(getContext(), "zalosdk_progress", "id"));
        this.d.setVisibility(8);
        getActivity().getWindow().setSoftInputMode(18);
        return view;
    }

    private String a(Context ctx) {
        StringBuilder url = new StringBuilder();
        url.append("https://oauth.zaloapp.com/v3/auth?app_id=");
        try {
            url.append(ZaloSDK.Instance.getAppID());
            url.append("&sign_key=");
            url.append(URLEncoder.encode(AppInfo.getApplicationHashKey(ctx), "UTF-8"));
            url.append("&pkg_name=");
            url.append(URLEncoder.encode(AppInfo.getPackageName(ctx), "UTF-8"));
            url.append("&orientation=");
            url.append(ctx.getResources().getConfiguration().orientation);
            url.append("&zregister=true");
            url.append("&ts=" + System.currentTimeMillis());
            if (!TextUtils.isEmpty(this.i)) {
                url.append("&zalert=" + this.i);
            }
            url.append("&lang=" + com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(ctx));
            url.append("#register");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url.toString();
    }

    public final void onResume() {
        super.onResume();
        a(getString(Utils.getResourceId(getActivity(), "txt_regis_acc", "string")));
        a();
    }

    public final void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.b = (c) this.a;
        } catch (ClassCastException e) {
            Log.e(context.getClass().getSimpleName() + " must implement " + c.class.getSimpleName());
        }
    }

    public final void onDetach() {
        super.onDetach();
        this.b = null;
    }
}
