package com.zing.zalo.zalosdk.payment.direct;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.os.Build.VERSION;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View.MeasureSpec;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;

public class DynamicLayout extends RelativeLayout {
    int mBoundedWidth = 900;
    int w;

    public DynamicLayout(Context context) {
        super(context);
    }

    public DynamicLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @TargetApi(13)
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (DeviceHelper.isTablet(getContext())) {
            int width;
            int height;
            Display display = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
            if (VERSION.SDK_INT >= 13) {
                Point size = new Point();
                display.getSize(size);
                width = size.x;
                height = size.y;
            } else {
                width = display.getWidth();
                height = display.getHeight();
            }
            if (MeasureSpec.getSize(widthMeasureSpec) < MeasureSpec.getSize(heightMeasureSpec)) {
                this.mBoundedWidth = (int) (((double) width) * 0.8d);
            } else {
                this.mBoundedWidth = (int) (((double) height) * 0.8d);
            }
            if (this.mBoundedWidth < MeasureSpec.getSize(widthMeasureSpec)) {
                this.w = MeasureSpec.makeMeasureSpec(this.mBoundedWidth, MeasureSpec.getMode(widthMeasureSpec));
            }
        } else if (MeasureSpec.getSize(widthMeasureSpec) < MeasureSpec.getSize(heightMeasureSpec)) {
            this.w = widthMeasureSpec;
        } else {
            this.w = heightMeasureSpec + 50;
        }
        super.onMeasure(this.w, heightMeasureSpec);
    }
}
