package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;

public abstract class ZaloOAuth {
    public static ZaloOAuth Instance;
    private LocalizedString a = new LocalizedString();

    public abstract void authenticate(Activity activity, LoginVia loginVia, OAuthCompleteListener oAuthCompleteListener);

    public abstract void authenticate(Activity activity, OAuthCompleteListener oAuthCompleteListener);

    public abstract long getAppID();

    public abstract String getDeviceId();

    public abstract void getDeviceId(GetInfoListener getInfoListener);

    public abstract void getFriendListInvitable(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr);

    public abstract void getFriendListUsedApp(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr);

    public abstract String getLastestLoginChannel();

    public abstract String getOAuthCode();

    public abstract String getPrivateKey();

    public abstract void getProfile(Context context, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr);

    public abstract String getSDKId();

    public abstract String getVersion();

    public abstract String getZaloDisplayname();

    public abstract long getZaloId();

    protected abstract void initialize(Application application);

    public abstract void inviteFriendUseApp(Context context, String[] strArr, String str, ZaloOpenAPICallback zaloOpenAPICallback);

    public abstract boolean isAuthenticate(ValidateOAuthCodeCallback validateOAuthCodeCallback);

    public abstract boolean onActivityResult(Activity activity, int i, int i2, Intent intent);

    public abstract void requestPermissions(Activity activity, Enum<Permissions> enumR, OAuthCompleteListener oAuthCompleteListener);

    public abstract void setLogLevel(int i);

    public abstract void unauthenticate();

    protected ZaloOAuth() {
    }

    public LocalizedString getLocalizedString() {
        return this.a;
    }

    public void setLocalizedString(LocalizedString localizedString) {
        this.a = localizedString;
    }
}
