package com.zing.zalo.zalosdk.oauth;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.Utils;

class Utilities {
    Utilities() {
    }

    static boolean a(Context context) {
        if (!Utils.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        NetworkInfo activeNetworkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }

    public static int getVersionCode(Context context, String str) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(str, 0);
            if (packageInfo != null) {
                return packageInfo.versionCode;
            }
        } catch (Exception e) {
        }
        return -1;
    }

    public static void invokeMarketApp(Context context, String str) {
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse("market://details?id=" + str)));
        } catch (ActivityNotFoundException e) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse("https://play.google.com/store/apps/details?id=" + str)));
        }
    }

    public static boolean isPortait(Context context) {
        Display defaultDisplay = ((WindowManager) context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        return displayMetrics.heightPixels > displayMetrics.widthPixels;
    }

    public static boolean isTablet(Context context) {
        return context.getResources().getBoolean(R.bool.isTablet);
    }

    public static boolean isZaloInstalled(Context context) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        return intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
    }

    public static boolean isZaloSupportCallBack(Context context) {
        return getVersionCode(context, "com.zing.zalo") > 1100123;
    }
}
