package com.zing.zalo.zalosdk.oauth;

import android.content.Context;
import android.content.SharedPreferences.Editor;
import com.zing.zalo.zalosdk.core.helper.Storage;

public class OauthStorage extends Storage {
    private final String PREF_ACESS_TOKEN = "PREF_ACESS_TOKEN";
    private final String PREF_ACESS_TOKEN_NEW_API = "PREF_NEW_API_ACCESSTOKEN";
    private final String PREF_APP_VERSION_NOTI = "PREF_APP_VERSION_NOTI";
    private final String PREF_GCM_TOKEN = "PREF_GCM_TOKEN";
    private final String PREF_GUEST_DEVICE_ID = "PREF_GUEST_DEVICE_ID";
    private final String PREF_GUEST_IS_CERT = "PREF_GUEST_IS_CERTIFICATE";
    private final String PREF_IS_PROTECTED = "PREF_IS_PROTECTED";
    private final String PREF_OAUTH_CODE = "PREFERECE_ZALO_SDK_OAUTH_CODE";
    private final String PREF_OAUTH_CODE_CHANNEL = "PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL";
    private final String PREF_OSV = "PREF_APP_VERSION";
    private final String PREF_SOCIAL_ID = "PREFERECE_SOCIAL_ID";
    private final String PREF_ZALO_DISPLAY_NAME = "PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME";
    private final String PREF_ZALO_ID = "PREFERECE_ZALO_SDK_ZALO_ID";
    private final String PREF_ZALO_ID_NOTI = "PREFERECE_ZALO_SDK_ZALO_ID_NOTI";
    private final String PREF_ZPLUGIN_OAUTH_CODE = "PREFERECE_ZALO_SDK_ZPLUGIN_OAUTH_CODE";
    private final String PREF_ZPLUGIN_USERID = "PREFERECE_ZALO_SDK_ZPLUGIN_USERID";

    public OauthStorage(Context context) {
        super(context);
    }

    public String getAccessToken() {
        return getString("PREF_ACESS_TOKEN");
    }

    public String getAccessTokenNewAPI() {
        return getString("PREF_NEW_API_ACCESSTOKEN");
    }

    public int getAppVersion() {
        return this.localPref.getInt("PREF_APP_VERSION_NOTI", Integer.MIN_VALUE);
    }

    public String getGCMToken() {
        return this.localPref.getString("PREF_GCM_TOKEN", "");
    }

    public String getGuestDeviceId() {
        return getString("PREF_GUEST_DEVICE_ID");
    }

    public int getIsGuestCertificated() {
        return getInt("PREF_GUEST_IS_CERTIFICATE");
    }

    public int getIsProtected() {
        return getInt("PREF_IS_PROTECTED");
    }

    public String getLastestLoginChannel() {
        return getString("PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL");
    }

    public String getOAuthCode() {
        return getString("PREFERECE_ZALO_SDK_OAUTH_CODE");
    }

    public String getOSV() {
        return this.localPref.getString("PREF_APP_VERSION", "");
    }

    public String getSocialId() {
        return getString("PREFERECE_SOCIAL_ID");
    }

    public String getZaloDisplayName() {
        return getString("PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME");
    }

    public long getZaloId() {
        return getLong("PREFERECE_ZALO_SDK_ZALO_ID");
    }

    public long getZaloIdNoti() {
        return getLong("PREFERECE_ZALO_SDK_ZALO_ID_NOTI");
    }

    public String getZaloPluginOAuthCode() {
        return getString("PREFERECE_ZALO_SDK_ZPLUGIN_OAUTH_CODE");
    }

    public long getZaloPluginUserId() {
        return getLong("PREFERECE_ZALO_SDK_ZPLUGIN_USERID");
    }

    public void setAccessToken(String str) {
        setString("PREF_ACESS_TOKEN", str);
    }

    public void setAccessTokenNewAPI(String str) {
        setString("PREF_NEW_API_ACCESSTOKEN", str);
    }

    public void setGuestDeviceId(String str) {
        setString("PREF_GUEST_DEVICE_ID", str);
    }

    public void setIsGuestCertificated(int i) {
        setInt("PREF_GUEST_IS_CERTIFICATE", i);
    }

    public void setIsProtected(int i) {
        setInt("PREF_IS_PROTECTED", i);
    }

    public void setOAuthCode(String str, String str2) {
        setString("PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL", str);
        setString("PREFERECE_ZALO_SDK_OAUTH_CODE", str2);
    }

    public void setSocialId(String str) {
        setString("PREFERECE_SOCIAL_ID", str);
    }

    public void setZaloDisplayName(String str) {
        setString("PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME", str);
    }

    public void setZaloId(long j) {
        setLong("PREFERECE_ZALO_SDK_ZALO_ID", j);
    }

    public void setZaloPluginOAuthCode(String str) {
        setString("PREFERECE_ZALO_SDK_ZPLUGIN_OAUTH_CODE", str);
    }

    public void setZaloPluginUserId(long j) {
        setLong("PREFERECE_ZALO_SDK_ZPLUGIN_USERID", j);
    }

    public void storeRegistrationId(String str, int i, String str2, long j) {
        Editor edit = this.localPref.edit();
        edit.putString("PREF_GCM_TOKEN", str);
        edit.putInt("PREF_APP_VERSION_NOTI", i);
        edit.putString("PREF_APP_VERSION", str2);
        edit.putLong("PREFERECE_ZALO_SDK_ZALO_ID_NOTI", j);
        edit.commit();
    }
}
