package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.zing.zalo.devicetrackingsdk.AppUserDataCallback;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo.GetInfoListener;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo.OnGetAdsID;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.zalosdk.auth.internal.a;
import com.zing.zalo.zalosdk.core.exception.InitializedException;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.payment.direct.Utils;
import java.lang.ref.WeakReference;

public class ZaloSDK extends ZaloOAuth {
    public static ZaloSDK Instance = new ZaloSDK();
    private boolean a = false;
    private Authenticator b;
    private LocalizedString c = new LocalizedString();
    private OauthStorage d;
    private a e;
    private BaseAppInfo f;

    ZaloSDK() {
    }

    public void authenticate(Activity activity, LoginVia loginVia, OAuthCompleteListener oAuthCompleteListener) {
        checkInitialize();
        this.b.authenticate(activity, loginVia, false, oAuthCompleteListener);
    }

    public void authenticate(Activity activity, OAuthCompleteListener oAuthCompleteListener) {
        authenticate(activity, LoginVia.APP, oAuthCompleteListener);
    }

    protected void authenticateZaloPlugin(Activity activity, OAuthCompleteListener oAuthCompleteListener) {
        checkInitialize();
        this.b.authenticate(activity, LoginVia.APP_OR_WEB, true, oAuthCompleteListener);
    }

    public void checkInitialize() {
        if (!this.a) {
            throw new InitializedException("Missing call declare com.zing.zalo.zalosdk.oauth.ZaloSDKApplication in Application or call wrap init");
        }
    }

    public void getAdID(OnGetAdsID onGetAdsID) {
        if (getBaseAppInfo() != null) {
            getBaseAppInfo().getAdsID(onGetAdsID);
        }
    }

    public long getAppID() {
        return ZaloSDKApplication.appID;
    }

    public String getAppUser() {
        return this.f != null ? this.f.getAppUser() : null;
    }

    public Authenticator getAuthenticator() {
        return this.b;
    }

    public BaseAppInfo getBaseAppInfo() {
        return this.f;
    }

    public String getDeviceId() {
        return this.f.getDeviceId();
    }

    public String getDeviceId(GetInfoListener getInfoListener) {
        return this.f.getDeviceId(getInfoListener);
    }

    public String getDistributionSource() {
        return this.f != null ? this.f.getDistributionSource() : null;
    }

    public void getFriendListInvitable(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr) {
        checkInitialize();
        a aVar = this.e;
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, aVar.a + "/invitable_friends");
        httpClientRequest.addParams("fields", a.a(strArr));
        httpClientRequest.addParams("offset", String.valueOf(i));
        httpClientRequest.addParams("limit", String.valueOf(i2));
        new a.a(aVar, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public void getFriendListUsedApp(Context context, int i, int i2, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr) {
        checkInitialize();
        a aVar = this.e;
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.GET, aVar.a + "/friends");
        httpClientRequest.addParams("fields", a.a(strArr));
        httpClientRequest.addParams("offset", String.valueOf(i));
        httpClientRequest.addParams("limit", String.valueOf(i2));
        new a.a(aVar, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public String getGuestDeviceId() {
        return this.f.getGuestDeviceId();
    }

    public String getLastestLoginChannel() {
        return this.d.getLastestLoginChannel();
    }

    public LocalizedString getLocalizedString() {
        return this.c;
    }

    public String getLoginChannel() {
        return this.f != null ? this.f.getLoginChannel() : null;
    }

    public String getOAuthCode() {
        checkInitialize();
        return this.d.getOAuthCode();
    }

    public OauthStorage getOauthStorage() {
        return this.d;
    }

    public String getPrivateKey() {
        return this.f.getPrivateKey();
    }

    public void getProfile(Context context, ZaloOpenAPICallback zaloOpenAPICallback, String[] strArr) {
        checkInitialize();
        a aVar = this.e;
        new HttpClientRequest(Type.GET, aVar.a).addParams("fields", a.a(strArr));
        new a.a(aVar, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{r1});
    }

    public String getSDKId() {
        return this.f.getSDKId();
    }

    public String getSocialId() {
        checkInitialize();
        return this.d.getSocialId();
    }

    public String getVersion() {
        return "2.3.0910";
    }

    public String getZaloDisplayname() {
        checkInitialize();
        return this.d.getZaloDisplayName();
    }

    public long getZaloId() {
        checkInitialize();
        return this.d.getZaloId();
    }

    protected synchronized void initialize(Application application) {
        if (!this.a) {
            Context applicationContext = application.getApplicationContext();
            this.d = new OauthStorage(applicationContext);
            this.b = new Authenticator(applicationContext, this.d, this.c);
            this.a = true;
            this.e = new a(this.d);
            this.f = new BaseAppInfo(applicationContext, new BaseAppInfoStorage(applicationContext), String.valueOf(getAppID()));
        }
    }

    public void inviteFriendUseApp(Context context, String[] strArr, String str, ZaloOpenAPICallback zaloOpenAPICallback) {
        checkInitialize();
        a aVar = this.e;
        HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://graph.zalo.me/v2.0/apprequests");
        httpClientRequest.addParams("to", a.a(strArr));
        httpClientRequest.addParams("message", str);
        new a.a(aVar, context, new WeakReference(zaloOpenAPICallback)).execute(new HttpClientRequest[]{httpClientRequest});
    }

    public boolean isAuthenticate(ValidateOAuthCodeCallback validateOAuthCodeCallback) {
        return isAuthenticate(this.d.getOAuthCode(), validateOAuthCodeCallback);
    }

    protected boolean isAuthenticate(String str, ValidateOAuthCodeCallback validateOAuthCodeCallback) {
        checkInitialize();
        return this.b.isAuthenticate(str, validateOAuthCodeCallback);
    }

    public final boolean onActivityResult(Activity activity, int i, int i2, Intent intent) {
        return this.b.onActivityResult(activity, i, i2, intent);
    }

    public void registerZalo(Activity activity, OAuthCompleteListener oAuthCompleteListener) {
        checkInitialize();
        this.b.registerZalo(activity, oAuthCompleteListener);
    }

    public void requestPermissions(Activity activity, Enum<Permissions> enumR, OAuthCompleteListener oAuthCompleteListener) {
        checkInitialize();
        this.b.requestPermissions(activity, enumR, oAuthCompleteListener);
    }

    public void setApplicationID(long j) {
        ZaloSDKApplication.appID = j;
    }

    public void setLanguageSDK(Context context, String str) {
        Utils.setLanguage(context, str);
    }

    public void setLocalizedString(LocalizedString localizedString) {
        this.c = localizedString;
    }

    public void setLogLevel(int i) {
        Log.setLogLevel(i);
    }

    public void setOauthCompletedListener(OAuthCompleteListener oAuthCompleteListener) {
        checkInitialize();
        this.b.setOAuthCompleteListener(oAuthCompleteListener);
    }

    public void submitAppUserData(String str, String str2, String str3, String str4, AppUserDataCallback appUserDataCallback) {
        checkInitialize();
        this.f.submitAppUserData(str, str2, str3, str4, appUserDataCallback);
    }

    public void unauthenticate() {
        checkInitialize();
        this.b.unauthenticate();
    }
}
