/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.d;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class WebDialog
extends Dialog {
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String UTF8 = "UTF-8";
    private static final String LOG_TAG = "WebDialog";
    private static final String DISPLAY_TOUCH = "touch";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 0xFFFFFF;
    public static final int DEFAULT_THEME = 0x1030010;
    private String url;
    private String query;
    private String queryBody;
    private String code;
    private OnCompleteListener onCompleteListener;
    ZaloPluginCallback zFeedCallback;
    private WebView webView;
    private d spinner;
    private ImageView crossImageView;
    private FrameLayout contentFrameLayout;
    private boolean listenerCalled = false;
    private boolean isDetached = false;
    private boolean isDismissed = false;
    CookieSyncManager cookieSyncManager;
    CookieManager cookieManager;
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    int oldWidth = 0;
    OrientationEventListener myOrientationEventListener;

    public WebDialog(Context context, String string2) {
        this(context, string2, 0x1030010);
    }

    public WebDialog(Context context, String string2, int n2) {
        super(context, n2);
        this.url = string2;
    }

    public WebDialog(Context context, String string2, Bundle bundle, int n2, OnCompleteListener onCompleteListener) {
        super(context, n2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.query = bundle.getString(EXTRA_QUERY);
        this.queryBody = bundle.getString(EXTRA_REQUEST_BODY);
        this.query = this.query == null ? "" : this.query;
        this.code = bundle.getString(EXTRA_OAUTH_CODE);
        this.url = "https://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = onCompleteListener;
    }

    public void setFeedCallBackListener(ZaloPluginCallback zaloPluginCallback) {
        this.zFeedCallback = zaloPluginCallback;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void dismiss() {
        if (this.isDismissed) {
            return;
        }
        this.isDismissed = true;
        if (this.myOrientationEventListener != null) {
            this.myOrientationEventListener.disable();
        }
        if (!this.listenerCalled) {
            this.sendCancelToListener();
        }
        if (this.webView != null) {
            this.webView.stopLoading();
        }
        if (!this.isDetached) {
            if (this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
            super.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.spinner = new d(this.getContext(), new d.a(){

            @Override
            public void onClose() {
            }
        });
        this.spinner.requestWindowFeature(1);
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.dismiss();
            }
        });
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.calculateSize();
        this.getWindow().setGravity(17);
        this.getWindow().setSoftInputMode(16);
        this.createCrossImage();
        this.crossImageView.getDrawable().getIntrinsicWidth();
        this.setUpWebView(0);
        bundle = new ViewGroup.LayoutParams(-2, -2);
        this.contentFrameLayout.addView((View)this.crossImageView, (ViewGroup.LayoutParams)bundle);
        this.setContentView((View)this.contentFrameLayout);
        this.crossImageView.bringToFront();
        this.myOrientationEventListener = new OrientationEventListener(this.getContext(), 3){

            public void onOrientationChanged(int n2) {
                if (n2 > 350 || n2 < 10) {
                    WebDialog.this.updateLayout();
                    return;
                }
                if (n2 < 100 && n2 > 80) {
                    WebDialog.this.updateLayout();
                    return;
                }
                if (n2 > 170 && n2 < 190) {
                    WebDialog.this.updateLayout();
                    return;
                }
                if (n2 > 260 && n2 < 280) {
                    WebDialog.this.updateLayout();
                }
            }
        };
        if (this.myOrientationEventListener.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
            }
        });
        this.getWindow().addFlags(2);
        this.getWindow().getAttributes().dimAmount = 0.7f;
    }

    private void updateLayout() {
        if (this.oldWidth != this.getScreenWidth()) {
            this.calculateSize();
            this.oldWidth = this.getScreenWidth();
        }
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    private int getScreenWidth() {
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    private void calculateSize() {
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n2 = displayMetrics.widthPixels;
        int n3 = displayMetrics.heightPixels;
        if (Utilities.isTablet(this.getContext())) {
            n3 = n3 * 2 / 3;
            if (Utilities.isPortait(this.getContext())) {
                if ((n2 = n2 * 2 / 3) < 300) {
                    n2 = 300;
                }
                if (n3 < 400) {
                    n3 = 400;
                }
            } else {
                if ((n2 = n2 * 1 / 2) < 400) {
                    n2 = 400;
                }
                if (n3 < 300) {
                    n3 = 300;
                }
            }
            this.getWindow().setLayout(n2, n3);
            return;
        }
        this.getWindow().setLayout(n2, n3 - 80);
    }

    private int getScaledSize(int n2, float f2, int n3, int n4) {
        int n5 = (int)((float)n2 / f2);
        double d2 = n5 <= n3 ? 1.0 : (n5 >= n4 ? 0.5 : 0.5 + (double)(n4 - n5) / (double)(n4 - n3) * 0.5);
        return (int)((double)n2 * d2);
    }

    protected void sendSuccessToListener(Bundle bundle) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(bundle);
            this.dismiss();
        }
    }

    protected void sendErrorToListener(Throwable throwable) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(null);
            this.dismiss();
        }
    }

    protected void sendCancelToListener() {
        this.sendErrorToListener(null);
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WebDialog.this.dismiss();
            }
        });
        Drawable drawable2 = this.getContext().getResources().getDrawable(R.drawable.ic_close_web);
        this.crossImageView.setImageDrawable(drawable2);
        this.crossImageView.setVisibility(4);
        this.crossImageView.setPadding(WebDialog.convertDpToPixel(7.0f, this.getContext()), WebDialog.convertDpToPixel(7.0f, this.getContext()), 0, 0);
    }

    public static int convertDpToPixel(float f2, Context context) {
        context = context.getResources().getDisplayMetrics();
        return (int)(f2 * ((float)context.densityDpi / 160.0f));
    }

    private void setupCookie() {
        this.cookieSyncManager = CookieSyncManager.createInstance((Context)this.getContext());
        this.cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        } else {
            this.cookieManager.setAcceptCookie(true);
        }
        String string2 = "https://plugin.zaloapp.com";
        String string3 = this.cookieManager.getCookie(string2);
        Log.i((String)"debuglog", (String)("cookie: " + string3));
        this.cookieManager.removeAllCookie();
        this.cookieManager.setCookie(string2, "code=" + this.code);
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            this.cookieSyncManager.sync();
        }
        Log.i((String)"debuglog", (String)("set cookie: code=" + this.code));
        string3 = this.cookieManager.getCookie(string2);
        Log.i((String)"debuglog", (String)("cookies: " + string3));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView(int n2) {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        this.webView = new WebView(this.getContext()){

            public void onWindowFocusChanged(boolean bl) {
                try {
                    super.onWindowFocusChanged(bl);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    return;
                }
            }
        };
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.setupCookie();
        this.webView.postUrl(this.url, this.queryBody.getBytes());
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setSaveFormData(false);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            String string2 = this.getContext().getDir("database", 0).getPath();
            this.webView.getSettings().setDatabasePath(string2);
        }
        linearLayout.setPadding(n2, n2, n2, n2);
        linearLayout.addView((View)this.webView);
        linearLayout.setBackgroundColor(0xFFFFFF);
        this.contentFrameLayout.addView((View)linearLayout);
    }

    public static class RequestsDialogBuilder
    extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String MESSAGE_PARAM = "message";
        private static final String TO_PARAM = "to";
        private static final String DATA_PARAM = "data";
        private static final String TITLE_PARAM = "title";

        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        public RequestsDialogBuilder(Context context, String string2, Bundle bundle) {
            super(context, string2, APPREQUESTS_DIALOG, bundle);
        }

        public RequestsDialogBuilder setMessage(String string2) {
            this.getParameters().putString(MESSAGE_PARAM, string2);
            return this;
        }

        public RequestsDialogBuilder setTo(String string2) {
            this.getParameters().putString(TO_PARAM, string2);
            return this;
        }

        public RequestsDialogBuilder setData(String string2) {
            this.getParameters().putString(DATA_PARAM, string2);
            return this;
        }

        public RequestsDialogBuilder setTitle(String string2) {
            this.getParameters().putString(TITLE_PARAM, string2);
            return this;
        }
    }

    public static class FeedDialogBuilder
    extends BuilderBase<FeedDialogBuilder> {
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String TO_PARAM = "to";
        private static final String LINK_PARAM = "link";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String NAME_PARAM = "name";
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";

        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        public FeedDialogBuilder(Context context, Bundle bundle) {
            super(context, FEED_DIALOG, bundle);
        }

        public FeedDialogBuilder(Context context, String string2, Bundle bundle) {
            super(context, string2, FEED_DIALOG, bundle);
        }

        public FeedDialogBuilder setFrom(String string2) {
            this.getParameters().putString(FROM_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setTo(String string2) {
            this.getParameters().putString(TO_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setLink(String string2) {
            this.getParameters().putString(LINK_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setPicture(String string2) {
            this.getParameters().putString(PICTURE_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setSource(String string2) {
            this.getParameters().putString(SOURCE_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setName(String string2) {
            this.getParameters().putString(NAME_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setCaption(String string2) {
            this.getParameters().putString(CAPTION_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setDescription(String string2) {
            this.getParameters().putString(DESCRIPTION_PARAM, string2);
            return this;
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        public Builder(Context context, String string2) {
            super(context, string2);
        }

        public Builder(Context context, String string2, Bundle bundle) {
            super(context, string2, bundle);
        }

        public Builder(Context context, String string2, String string3, Bundle bundle) {
            super(context, string2, string3, bundle);
        }
    }

    static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private Context context;
        private String applicationId;
        private String action;
        private int theme = 0x1030010;
        private OnCompleteListener listener;
        private Bundle parameters;

        protected BuilderBase(Context context, String string2) {
            this.finishInit(context, string2, null);
        }

        protected BuilderBase(Context context, String string2, Bundle bundle) {
            this.finishInit(context, string2, bundle);
        }

        protected BuilderBase(Context context, String string2, String string3, Bundle bundle) {
            this.finishInit(context, string3, bundle);
        }

        public CONCRETE setTheme(int n2) {
            this.theme = n2;
            return (CONCRETE)this;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener onCompleteListener) {
            this.listener = onCompleteListener;
            return (CONCRETE)this;
        }

        public WebDialog build() {
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected int getTheme() {
            return this.theme;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        private void finishInit(Context context, String string2, Bundle bundle) {
            this.context = context;
            this.action = string2;
            if (bundle != null) {
                this.parameters = bundle;
                return;
            }
            this.parameters = new Bundle();
        }
    }

    class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            return super.shouldOverrideUrlLoading(webView, string2);
        }

        public void onReceivedError(WebView webView, int n2, String string2, String string3) {
            super.onReceivedError(webView, n2, string2, string3);
            WebDialog.this.sendErrorToListener(null);
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.cancel();
            WebDialog.this.sendErrorToListener(null);
        }

        public void onPageStarted(WebView object, String string2, Bitmap bitmap) {
            super.onPageStarted(object, string2, bitmap);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
            if (string2.contains("plugin.zaloapp.com/webview/callback")) {
                object.stopLoading();
                if (WebDialog.this.zFeedCallback != null) {
                    object = Uri.parse((String)string2);
                    object = this.parseUrlQueryString(object.getQuery());
                    boolean bl = false;
                    int n2 = 0;
                    String string3 = object.getString("error_code");
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (Exception exception) {
                            n2 = 0;
                        }
                    }
                    if (n2 == 0) {
                        bl = true;
                    }
                    string3 = object.getString("error_message");
                    object = object.getString("result_data");
                    WebDialog.this.zFeedCallback.onResult(bl, n2, string3, (String)object);
                }
            }
        }

        public Bundle parseUrlQueryString(String stringArray) {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)stringArray)) {
                stringArray = stringArray.split("&");
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String[] stringArray2 = stringArray[i2].split("=");
                    try {
                        if (stringArray2.length == 2) {
                            bundle.putString(URLDecoder.decode(stringArray2[0], WebDialog.UTF8), URLDecoder.decode(stringArray2[1], WebDialog.UTF8));
                            continue;
                        }
                        if (stringArray2.length != 1) continue;
                        bundle.putString(URLDecoder.decode(stringArray2[0], WebDialog.UTF8), "");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            return bundle;
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1);
    }
}

