package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.FrameLayout.LayoutParams;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.d;
import com.zing.zalo.zalosdk.auth.internal.d.a;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class WebDialog extends Dialog {
    private static final int API_EC_DIALOG_CANCEL = 4201;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 16777215;
    public static final int DEFAULT_THEME = 16973840;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final String DISPLAY_TOUCH = "touch";
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String LOG_TAG = "WebDialog";
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final double MIN_SCALE_FACTOR = 0.5d;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final String UTF8 = "UTF-8";
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    private String code;
    private FrameLayout contentFrameLayout;
    CookieManager cookieManager;
    CookieSyncManager cookieSyncManager;
    private ImageView crossImageView;
    private boolean isDetached;
    private boolean isDismissed;
    private boolean listenerCalled;
    OrientationEventListener myOrientationEventListener;
    int oldWidth;
    private OnCompleteListener onCompleteListener;
    private String query;
    private String queryBody;
    private d spinner;
    private String url;
    private WebView webView;
    ZaloPluginCallback zFeedCallback;

    static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private String action;
        private String applicationId;
        private Context context;
        private OnCompleteListener listener;
        private Bundle parameters;
        private int theme = WebDialog.DEFAULT_THEME;

        protected BuilderBase(Context context, String str) {
            finishInit(context, str, null);
        }

        protected BuilderBase(Context context, String str, Bundle bundle) {
            finishInit(context, str, bundle);
        }

        protected BuilderBase(Context context, String str, String str2, Bundle bundle) {
            finishInit(context, str2, bundle);
        }

        private void finishInit(Context context, String str, Bundle bundle) {
            this.context = context;
            this.action = str;
            if (bundle != null) {
                this.parameters = bundle;
            } else {
                this.parameters = new Bundle();
            }
        }

        public WebDialog build() {
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected int getTheme() {
            return this.theme;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener onCompleteListener) {
            this.listener = onCompleteListener;
            return this;
        }

        public CONCRETE setTheme(int i) {
            this.theme = i;
            return this;
        }
    }

    public static class Builder extends BuilderBase<Builder> {
        public Builder(Context context, String str) {
            super(context, str);
        }

        public Builder(Context context, String str, Bundle bundle) {
            super(context, str, bundle);
        }

        public Builder(Context context, String str, String str2, Bundle bundle) {
            super(context, str, str2, bundle);
        }

        public /* bridge */ /* synthetic */ WebDialog build() {
            return super.build();
        }
    }

    class DialogWebViewClient extends WebViewClient {
        private DialogWebViewClient() {
        }

        public void onPageFinished(WebView webView, String str) {
            super.onPageFinished(webView, str);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }

        public void onPageStarted(WebView webView, String str, Bitmap bitmap) {
            boolean z = WebDialog.DISABLE_SSL_CHECK_FOR_TESTING;
            super.onPageStarted(webView, str, bitmap);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
            if (str.contains("plugin.zaloapp.com/webview/callback")) {
                webView.stopLoading();
                if (WebDialog.this.zFeedCallback != null) {
                    int i;
                    Bundle parseUrlQueryString = parseUrlQueryString(Uri.parse(str).getQuery());
                    Object string = parseUrlQueryString.getString("error_code");
                    if (TextUtils.isEmpty(string)) {
                        i = 0;
                    } else {
                        try {
                            i = Integer.parseInt(string);
                        } catch (Exception e) {
                            i = 0;
                        }
                    }
                    if (i == 0) {
                        z = true;
                    }
                    WebDialog.this.zFeedCallback.onResult(z, i, parseUrlQueryString.getString("error_message"), parseUrlQueryString.getString("result_data"));
                }
            }
        }

        public void onReceivedError(WebView webView, int i, String str, String str2) {
            super.onReceivedError(webView, i, str, str2);
            WebDialog.this.sendErrorToListener(null);
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.cancel();
            WebDialog.this.sendErrorToListener(null);
        }

        public Bundle parseUrlQueryString(String str) {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty(str)) {
                for (String split : str.split("&")) {
                    String[] split2 = split.split("=");
                    try {
                        if (split2.length == 2) {
                            bundle.putString(URLDecoder.decode(split2[0], WebDialog.UTF8), URLDecoder.decode(split2[1], WebDialog.UTF8));
                        } else if (split2.length == 1) {
                            bundle.putString(URLDecoder.decode(split2[0], WebDialog.UTF8), "");
                        }
                    } catch (UnsupportedEncodingException e) {
                    }
                }
            }
            return bundle;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String str) {
            return super.shouldOverrideUrlLoading(webView, str);
        }
    }

    public static class FeedDialogBuilder extends BuilderBase<FeedDialogBuilder> {
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String LINK_PARAM = "link";
        private static final String NAME_PARAM = "name";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String TO_PARAM = "to";

        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        public FeedDialogBuilder(Context context, Bundle bundle) {
            super(context, FEED_DIALOG, bundle);
        }

        public FeedDialogBuilder(Context context, String str, Bundle bundle) {
            super(context, str, FEED_DIALOG, bundle);
        }

        public /* bridge */ /* synthetic */ WebDialog build() {
            return super.build();
        }

        public FeedDialogBuilder setCaption(String str) {
            getParameters().putString(CAPTION_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setDescription(String str) {
            getParameters().putString(DESCRIPTION_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setFrom(String str) {
            getParameters().putString(FROM_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setLink(String str) {
            getParameters().putString(LINK_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setName(String str) {
            getParameters().putString(NAME_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setPicture(String str) {
            getParameters().putString(PICTURE_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setSource(String str) {
            getParameters().putString(SOURCE_PARAM, str);
            return this;
        }

        public FeedDialogBuilder setTo(String str) {
            getParameters().putString(TO_PARAM, str);
            return this;
        }
    }

    public interface OnCompleteListener {
        void onComplete(Bundle bundle);
    }

    public static class RequestsDialogBuilder extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String DATA_PARAM = "data";
        private static final String MESSAGE_PARAM = "message";
        private static final String TITLE_PARAM = "title";
        private static final String TO_PARAM = "to";

        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        public RequestsDialogBuilder(Context context, String str, Bundle bundle) {
            super(context, str, APPREQUESTS_DIALOG, bundle);
        }

        public /* bridge */ /* synthetic */ WebDialog build() {
            return super.build();
        }

        public RequestsDialogBuilder setData(String str) {
            getParameters().putString(DATA_PARAM, str);
            return this;
        }

        public RequestsDialogBuilder setMessage(String str) {
            getParameters().putString(MESSAGE_PARAM, str);
            return this;
        }

        public RequestsDialogBuilder setTitle(String str) {
            getParameters().putString(TITLE_PARAM, str);
            return this;
        }

        public RequestsDialogBuilder setTo(String str) {
            getParameters().putString(TO_PARAM, str);
            return this;
        }
    }

    public WebDialog(Context context, String str) {
        this(context, str, DEFAULT_THEME);
    }

    public WebDialog(Context context, String str, int i) {
        super(context, i);
        this.listenerCalled = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDismissed = DISABLE_SSL_CHECK_FOR_TESTING;
        this.oldWidth = 0;
        this.url = str;
    }

    public WebDialog(Context context, String str, Bundle bundle, int i, OnCompleteListener onCompleteListener) {
        super(context, i);
        this.listenerCalled = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDismissed = DISABLE_SSL_CHECK_FOR_TESTING;
        this.oldWidth = 0;
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.query = bundle.getString(EXTRA_QUERY);
        this.queryBody = bundle.getString(EXTRA_REQUEST_BODY);
        this.query = this.query == null ? "" : this.query;
        this.code = bundle.getString(EXTRA_OAUTH_CODE);
        this.url = "https://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = onCompleteListener;
    }

    private void calculateSize() {
        int i = 400;
        int i2 = 300;
        Display defaultDisplay = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        int i3 = displayMetrics.widthPixels;
        int i4 = displayMetrics.heightPixels;
        if (Utilities.isTablet(getContext())) {
            i4 = (i4 * 2) / 3;
            int i5;
            if (Utilities.isPortait(getContext())) {
                i5 = (i3 * 2) / 3;
                if (i5 >= 300) {
                    i2 = i5;
                }
                if (i4 < 400) {
                    i4 = 400;
                    i = i2;
                } else {
                    i = i2;
                }
            } else {
                i5 = (i3 * 1) / 2;
                if (i5 >= 400) {
                    i = i5;
                }
                if (i4 < 300) {
                    i4 = 300;
                }
            }
            getWindow().setLayout(i, i4);
            return;
        }
        getWindow().setLayout(i3, i4 - 80);
    }

    public static int convertDpToPixel(float f, Context context) {
        return (int) ((((float) context.getResources().getDisplayMetrics().densityDpi) / 160.0f) * f);
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(getContext());
        this.crossImageView.setOnClickListener(new OnClickListener() {
            public void onClick(View view) {
                WebDialog.this.dismiss();
            }
        });
        this.crossImageView.setImageDrawable(getContext().getResources().getDrawable(R.drawable.ic_close_web));
        this.crossImageView.setVisibility(4);
        this.crossImageView.setPadding(convertDpToPixel(7.0f, getContext()), convertDpToPixel(7.0f, getContext()), 0, 0);
    }

    private int getScaledSize(int i, float f, int i2, int i3) {
        double d = MIN_SCALE_FACTOR;
        int i4 = (int) (((float) i) / f);
        if (i4 <= i2) {
            d = 1.0d;
        } else if (i4 < i3) {
            d = MIN_SCALE_FACTOR + ((((double) (i3 - i4)) / ((double) (i3 - i2))) * MIN_SCALE_FACTOR);
        }
        return (int) (d * ((double) i));
    }

    private int getScreenWidth() {
        Display defaultDisplay = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    @SuppressLint({"SetJavaScriptEnabled"})
    private void setUpWebView(int i) {
        View linearLayout = new LinearLayout(getContext());
        this.webView = new WebView(getContext()) {
            public void onWindowFocusChanged(boolean z) {
                try {
                    super.onWindowFocusChanged(z);
                } catch (NullPointerException e) {
                }
            }
        };
        this.webView.setVerticalScrollBarEnabled(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.setHorizontalScrollBarEnabled(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.setWebViewClient(new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        setupCookie();
        this.webView.postUrl(this.url, this.queryBody.getBytes());
        this.webView.setLayoutParams(new LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.getSettings().setSaveFormData(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.getSettings().setDatabaseEnabled(true);
        if (VERSION.SDK_INT < 19) {
            this.webView.getSettings().setDatabasePath(getContext().getDir("database", 0).getPath());
        }
        linearLayout.setPadding(i, i, i, i);
        linearLayout.addView(this.webView);
        linearLayout.setBackgroundColor(BACKGROUND_WHITE);
        this.contentFrameLayout.addView(linearLayout);
    }

    private void setupCookie() {
        this.cookieSyncManager = CookieSyncManager.createInstance(getContext());
        this.cookieManager = CookieManager.getInstance();
        if (VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        } else {
            this.cookieManager.setAcceptCookie(true);
        }
        String str = "https://plugin.zaloapp.com";
        Log.i("debuglog", "cookie: " + this.cookieManager.getCookie(str));
        this.cookieManager.removeAllCookie();
        this.cookieManager.setCookie(str, "code=" + this.code);
        if (VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            this.cookieSyncManager.sync();
        }
        Log.i("debuglog", "set cookie: code=" + this.code);
        Log.i("debuglog", "cookies: " + this.cookieManager.getCookie(str));
    }

    private void updateLayout() {
        if (this.oldWidth != getScreenWidth()) {
            calculateSize();
            this.oldWidth = getScreenWidth();
        }
    }

    public void dismiss() {
        if (!this.isDismissed) {
            this.isDismissed = true;
            if (this.myOrientationEventListener != null) {
                this.myOrientationEventListener.disable();
            }
            if (!this.listenerCalled) {
                sendCancelToListener();
            }
            if (this.webView != null) {
                this.webView.stopLoading();
            }
            if (!this.isDetached) {
                if (this.spinner.isShowing()) {
                    this.spinner.dismiss();
                }
                super.dismiss();
            }
        }
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    public void onAttachedToWindow() {
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.spinner = new d(getContext(), new a() {
            public void onClose() {
            }
        });
        this.spinner.requestWindowFeature(1);
        this.spinner.setOnCancelListener(new OnCancelListener() {
            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.dismiss();
            }
        });
        requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(getContext());
        calculateSize();
        getWindow().setGravity(17);
        getWindow().setSoftInputMode(16);
        createCrossImage();
        this.crossImageView.getDrawable().getIntrinsicWidth();
        setUpWebView(0);
        this.contentFrameLayout.addView(this.crossImageView, new ViewGroup.LayoutParams(-2, -2));
        setContentView(this.contentFrameLayout);
        this.crossImageView.bringToFront();
        this.myOrientationEventListener = new OrientationEventListener(getContext(), 3) {
            public void onOrientationChanged(int i) {
                if (i > 350 || i < 10) {
                    WebDialog.this.updateLayout();
                } else if (i < 100 && i > 80) {
                    WebDialog.this.updateLayout();
                } else if (i > 170 && i < 190) {
                    WebDialog.this.updateLayout();
                } else if (i > 260 && i < 280) {
                    WebDialog.this.updateLayout();
                }
            }
        };
        if (this.myOrientationEventListener.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        setOnCancelListener(new OnCancelListener() {
            public void onCancel(DialogInterface dialogInterface) {
            }
        });
        getWindow().addFlags(2);
        getWindow().getAttributes().dimAmount = 0.7f;
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    protected void sendCancelToListener() {
        sendErrorToListener(null);
    }

    protected void sendErrorToListener(Throwable th) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(null);
            dismiss();
        }
    }

    protected void sendSuccessToListener(Bundle bundle) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(bundle);
            dismiss();
        }
    }

    public void setFeedCallBackListener(ZaloPluginCallback zaloPluginCallback) {
        this.zFeedCallback = zaloPluginCallback;
    }
}
