package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.payment.direct.PaymentAlertDialog.OnCancelListener;
import com.zing.zalo.zalosdk.payment.direct.PaymentAlertDialog.OnOkListener;
import java.util.Locale;

public class Utils {
    private static String language = null;

    public static String getLanguage(Context context) {
        if (language == null) {
            return Locale.getDefault().getLanguage();
        }
        Log.i("debuglog", "default-------locale langauge : " + Locale.getDefault().getLanguage());
        return !Locale.getDefault().getLanguage().equalsIgnoreCase("vi") ? "my" : "vi";
    }

    public static void setLanguage(Context context, String str) {
        language = str;
    }

    public static void showAlertDialog(Context context, String str, OnOkListener onOkListener) {
        new PaymentAlertDialog(context, onOkListener).showAlert(str);
    }

    public static void showAlertDialog(Context context, String str, String str2, OnOkListener onOkListener, OnCancelListener onCancelListener) {
        PaymentAlertDialog paymentAlertDialog = new PaymentAlertDialog(context, onOkListener, onCancelListener);
        paymentAlertDialog.setOkButtonTitle(str2);
        paymentAlertDialog.showAlert(str);
    }
}
