package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.FrameLayout.LayoutParams;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.d;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class WebDialog extends Dialog {
    private static final int API_EC_DIALOG_CANCEL = 4201;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 16777215;
    public static final int DEFAULT_THEME = 16973840;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final String DISPLAY_TOUCH = "touch";
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String LOG_TAG = "WebDialog";
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final double MIN_SCALE_FACTOR = 0.5d;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final String UTF8 = "UTF-8";
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    private String code;
    private FrameLayout contentFrameLayout;
    CookieManager cookieManager;
    CookieSyncManager cookieSyncManager;
    private ImageView crossImageView;
    private boolean isDetached;
    private boolean isDismissed;
    private boolean listenerCalled;
    OrientationEventListener myOrientationEventListener;
    int oldWidth;
    private b onCompleteListener;
    private String query;
    private String queryBody;
    private d spinner;
    private String url;
    private WebView webView;
    ZaloPluginCallback zFeedCallback;

    class a extends WebViewClient {
        final /* synthetic */ WebDialog a;

        private a(WebDialog webDialog) {
            this.a = webDialog;
        }

        private static Bundle a(String str) {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty(str)) {
                for (String split : str.split("&")) {
                    String[] split2 = split.split("=");
                    try {
                        if (split2.length == 2) {
                            bundle.putString(URLDecoder.decode(split2[0], WebDialog.UTF8), URLDecoder.decode(split2[1], WebDialog.UTF8));
                        } else if (split2.length == 1) {
                            bundle.putString(URLDecoder.decode(split2[0], WebDialog.UTF8), "");
                        }
                    } catch (UnsupportedEncodingException e) {
                    }
                }
            }
            return bundle;
        }

        public final void onPageFinished(WebView webView, String str) {
            super.onPageFinished(webView, str);
            if (!this.a.isDetached) {
                this.a.spinner.dismiss();
            }
            this.a.contentFrameLayout.setBackgroundColor(0);
            this.a.webView.setVisibility(0);
            this.a.crossImageView.setVisibility(0);
        }

        public final void onPageStarted(WebView webView, String str, Bitmap bitmap) {
            boolean z = WebDialog.DISABLE_SSL_CHECK_FOR_TESTING;
            super.onPageStarted(webView, str, bitmap);
            if (!this.a.isDetached) {
                this.a.spinner.show();
            }
            if (str.contains("plugin.zaloapp.com/webview/callback")) {
                webView.stopLoading();
                if (this.a.zFeedCallback != null) {
                    int i;
                    Bundle a = a(Uri.parse(str).getQuery());
                    Object string = a.getString("error_code");
                    if (TextUtils.isEmpty(string)) {
                        i = 0;
                    } else {
                        try {
                            i = Integer.parseInt(string);
                        } catch (Exception e) {
                            i = 0;
                        }
                    }
                    if (i == 0) {
                        z = true;
                    }
                    this.a.zFeedCallback.onResult(z, i, a.getString("error_message"), a.getString("result_data"));
                }
            }
        }

        public final void onReceivedError(WebView webView, int i, String str, String str2) {
            super.onReceivedError(webView, i, str, str2);
            this.a.sendErrorToListener(null);
        }

        public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.cancel();
            this.a.sendErrorToListener(null);
        }

        public final boolean shouldOverrideUrlLoading(WebView webView, String str) {
            return super.shouldOverrideUrlLoading(webView, str);
        }
    }

    public interface b {
    }

    public WebDialog(Context context, String str) {
        this(context, str, DEFAULT_THEME);
    }

    public WebDialog(Context context, String str, int i) {
        super(context, i);
        this.listenerCalled = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDismissed = DISABLE_SSL_CHECK_FOR_TESTING;
        this.oldWidth = 0;
        this.url = str;
    }

    public WebDialog(Context context, String str, Bundle bundle, int i, b bVar) {
        super(context, i);
        this.listenerCalled = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        this.isDismissed = DISABLE_SSL_CHECK_FOR_TESTING;
        this.oldWidth = 0;
        if (bundle == null) {
            bundle = new Bundle();
        }
        this.query = bundle.getString(EXTRA_QUERY);
        this.queryBody = bundle.getString(EXTRA_REQUEST_BODY);
        this.query = this.query == null ? "" : this.query;
        this.code = bundle.getString(EXTRA_OAUTH_CODE);
        this.url = "https://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = bVar;
    }

    private void calculateSize() {
        int i = 400;
        int i2 = 300;
        Display defaultDisplay = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        int i3 = displayMetrics.widthPixels;
        int i4 = displayMetrics.heightPixels;
        if (Utilities.isTablet(getContext())) {
            i4 = (i4 * 2) / 3;
            int i5;
            if (Utilities.isPortait(getContext())) {
                i5 = (i3 * 2) / 3;
                if (i5 >= 300) {
                    i2 = i5;
                }
                if (i4 < 400) {
                    i4 = 400;
                    i = i2;
                } else {
                    i = i2;
                }
            } else {
                i5 = (i3 * 1) / 2;
                if (i5 >= 400) {
                    i = i5;
                }
                if (i4 < 300) {
                    i4 = 300;
                }
            }
            getWindow().setLayout(i, i4);
            return;
        }
        getWindow().setLayout(i3, i4 - 80);
    }

    public static int convertDpToPixel(float f, Context context) {
        return (int) ((((float) context.getResources().getDisplayMetrics().densityDpi) / 160.0f) * f);
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(getContext());
        this.crossImageView.setOnClickListener(new OnClickListener(this) {
            final /* synthetic */ WebDialog a;

            {
                this.a = r1;
            }

            public final void onClick(View view) {
                this.a.dismiss();
            }
        });
        this.crossImageView.setImageDrawable(getContext().getResources().getDrawable(R.drawable.ic_close_web));
        this.crossImageView.setVisibility(4);
        this.crossImageView.setPadding(convertDpToPixel(7.0f, getContext()), convertDpToPixel(7.0f, getContext()), 0, 0);
    }

    private int getScaledSize(int i, float f, int i2, int i3) {
        double d = MIN_SCALE_FACTOR;
        int i4 = (int) (((float) i) / f);
        if (i4 <= i2) {
            d = 1.0d;
        } else if (i4 < i3) {
            d = MIN_SCALE_FACTOR + ((((double) (i3 - i4)) / ((double) (i3 - i2))) * MIN_SCALE_FACTOR);
        }
        return (int) (d * ((double) i));
    }

    private int getScreenWidth() {
        Display defaultDisplay = ((WindowManager) getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    @SuppressLint({"SetJavaScriptEnabled"})
    private void setUpWebView(int i) {
        View linearLayout = new LinearLayout(getContext());
        this.webView = new WebView(this, getContext()) {
            final /* synthetic */ WebDialog a;

            public final void onWindowFocusChanged(boolean z) {
                try {
                    super.onWindowFocusChanged(z);
                } catch (NullPointerException e) {
                }
            }
        };
        this.webView.setVerticalScrollBarEnabled(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.setHorizontalScrollBarEnabled(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.setWebViewClient(new a());
        this.webView.getSettings().setJavaScriptEnabled(true);
        setupCookie();
        this.webView.postUrl(this.url, this.queryBody.getBytes());
        this.webView.setLayoutParams(new LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.getSettings().setSaveFormData(DISABLE_SSL_CHECK_FOR_TESTING);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.getSettings().setDatabaseEnabled(true);
        if (VERSION.SDK_INT < 19) {
            this.webView.getSettings().setDatabasePath(getContext().getDir("database", 0).getPath());
        }
        linearLayout.setPadding(i, i, i, i);
        linearLayout.addView(this.webView);
        linearLayout.setBackgroundColor(BACKGROUND_WHITE);
        this.contentFrameLayout.addView(linearLayout);
    }

    private void setupCookie() {
        this.cookieSyncManager = CookieSyncManager.createInstance(getContext());
        this.cookieManager = CookieManager.getInstance();
        if (VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        } else {
            this.cookieManager.setAcceptCookie(true);
        }
        String str = "https://plugin.zaloapp.com";
        Log.i("debuglog", "cookie: " + this.cookieManager.getCookie(str));
        this.cookieManager.removeAllCookie();
        this.cookieManager.setCookie(str, "code=" + this.code);
        if (VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            this.cookieSyncManager.sync();
        }
        Log.i("debuglog", "set cookie: code=" + this.code);
        Log.i("debuglog", "cookies: " + this.cookieManager.getCookie(str));
    }

    private void updateLayout() {
        if (this.oldWidth != getScreenWidth()) {
            calculateSize();
            this.oldWidth = getScreenWidth();
        }
    }

    public void dismiss() {
        if (!this.isDismissed) {
            this.isDismissed = true;
            if (this.myOrientationEventListener != null) {
                this.myOrientationEventListener.disable();
            }
            if (!this.listenerCalled) {
                sendCancelToListener();
            }
            if (this.webView != null) {
                this.webView.stopLoading();
            }
            if (!this.isDetached) {
                if (this.spinner.isShowing()) {
                    this.spinner.dismiss();
                }
                super.dismiss();
            }
        }
    }

    public b getOnCompleteListener() {
        return this.onCompleteListener;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    public void onAttachedToWindow() {
        this.isDetached = DISABLE_SSL_CHECK_FOR_TESTING;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.spinner = new d(getContext(), new com.zing.zalo.zalosdk.auth.internal.d.a(this) {
            final /* synthetic */ WebDialog a;

            {
                this.a = r1;
            }
        });
        this.spinner.requestWindowFeature(1);
        this.spinner.setOnCancelListener(new OnCancelListener(this) {
            final /* synthetic */ WebDialog a;

            {
                this.a = r1;
            }

            public final void onCancel(DialogInterface dialogInterface) {
                this.a.dismiss();
            }
        });
        requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(getContext());
        calculateSize();
        getWindow().setGravity(17);
        getWindow().setSoftInputMode(16);
        createCrossImage();
        this.crossImageView.getDrawable().getIntrinsicWidth();
        setUpWebView(0);
        this.contentFrameLayout.addView(this.crossImageView, new ViewGroup.LayoutParams(-2, -2));
        setContentView(this.contentFrameLayout);
        this.crossImageView.bringToFront();
        this.myOrientationEventListener = new OrientationEventListener(this, getContext()) {
            final /* synthetic */ WebDialog a;

            public final void onOrientationChanged(int i) {
                if (i > 350 || i < 10) {
                    this.a.updateLayout();
                } else if (i < 100 && i > 80) {
                    this.a.updateLayout();
                } else if (i > 170 && i < 190) {
                    this.a.updateLayout();
                } else if (i > 260 && i < 280) {
                    this.a.updateLayout();
                }
            }
        };
        if (this.myOrientationEventListener.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        setOnCancelListener(new OnCancelListener(this) {
            final /* synthetic */ WebDialog a;

            {
                this.a = r1;
            }

            public final void onCancel(DialogInterface dialogInterface) {
            }
        });
        getWindow().addFlags(2);
        getWindow().getAttributes().dimAmount = 0.7f;
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    protected void sendCancelToListener() {
        sendErrorToListener(null);
    }

    protected void sendErrorToListener(Throwable th) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            dismiss();
        }
    }

    protected void sendSuccessToListener(Bundle bundle) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            dismiss();
        }
    }

    public void setFeedCallBackListener(ZaloPluginCallback zaloPluginCallback) {
        this.zFeedCallback = zaloPluginCallback;
    }
}
