/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.q;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.payment.direct.PaymentDialog;

public class PaymentProcessingDialog
extends PaymentDialog
implements DialogInterface.OnDismissListener {
    String LOG_TAG = PaymentProcessingDialog.class.getSimpleName();
    String zalosdk_processing;
    String zalosdk_success;
    String zalosdk_unsuccess;
    public boolean isShow = false;
    boolean isTimeOut = false;
    int viewIndex = 0;
    Handler handler;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (PaymentProcessingDialog.this.viewIndex > 0 && PaymentProcessingDialog.this.isShowing()) {
                PaymentProcessingDialog.this.hideView();
                if (PaymentProcessingDialog.this.listener != null) {
                    PaymentProcessingDialog.this.listener.onClose();
                }
            }
        }
    };
    OnCloseListener listener;

    public PaymentProcessingDialog(Context context, OnCloseListener onCloseListener) {
        super(context);
        this.handler = new Handler();
        this.listener = onCloseListener;
        this.setOnDismissListener(this);
        this.zalosdk_processing = q.a("zalosdk_processing");
        this.zalosdk_success = q.a("zalosdk_success");
        this.zalosdk_unsuccess = q.a("zalosdk_unsuccess");
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.zalosdk_activity_processing);
    }

    public void updateProcessingTransactionView(String string2) {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)string2);
    }

    private void showProcessingView() {
        Log.i((String)"THREAD BEGIN", (String)"PROCESSING!!");
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_processing);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
    }

    private void showSuccessView() {
        Log.i((String)this.LOG_TAG, (String)"Show success dialog");
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_success);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_success);
        imageView.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    private void showUnSuccessView() {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_unsuccess);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_fail);
        imageView.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    private void showTimeOutView() {
        Log.i((String)"debuglog", (String)"time out showview");
        this.findViewById(R.id.zalosdk_process_dialog_ctl).setVisibility(8);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 1L);
        this.isTimeOut = true;
    }

    private void autoClose() {
        this.handler.postDelayed(this.runnable, 3000L);
    }

    public void showView(Status status) {
        this.show();
        this.isShow = true;
        switch (status) {
            case PROCESSING: {
                this.showProcessingView();
                return;
            }
            case SUCCESS: {
                this.showSuccessView();
                return;
            }
            case FAILED: {
                this.showUnSuccessView();
                return;
            }
            case TIMEOUT: {
                this.showTimeOutView();
            }
        }
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.listener != null) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)"cancel");
            this.listener.onClose();
        }
    }

    public void onBackPressed() {
    }

    public void hideView() {
        this.isShow = false;
        this.hide();
    }

    public void show() {
        Log.i((String)this.LOG_TAG, (String)"show loading..");
        try {
            super.show();
            return;
        }
        catch (Exception exception) {
            Log.i((String)this.LOG_TAG, (String)"error can not show loading");
            return;
        }
    }

    public void hide() {
        Log.i((String)this.LOG_TAG, (String)"hide loading!");
        super.hide();
    }

    public static interface OnCloseListener {
        public void onClose();
    }

    public static enum Status {
        PROCESSING,
        SUCCESS,
        FAILED,
        TIMEOUT;

    }
}

