package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.app.Application.ActivityLifecycleCallbacks;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

public class Authenticator {
    static boolean isGetZaloOAuth = false;
    private boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    private a callbackAppLifeCycle;
    private boolean isRegisBroadcastReceiver = false;
    protected Context mContext;
    private LocalizedString mLocalizedString;
    private OauthStorage mStorage;
    private String nameActivtyAuthenticate = "";
    public String nameActivtyCheckAuthen = "";
    public BroadcastReceiver receiver = new BroadcastReceiver(this) {
        final /* synthetic */ Authenticator a;

        {
            this.a = r1;
        }

        public final void onReceive(Context context, Intent intent) {
            if ("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP".equals(intent.getAction())) {
                this.a.bIsZaloLoginSuccessful = intent.getBooleanExtra("loginSuccessful", false);
            }
        }
    };
    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;
    private boolean zaloPluginLogin = false;

    class a implements ActivityLifecycleCallbacks {
        final /* synthetic */ Authenticator a;

        a(Authenticator authenticator) {
            this.a = authenticator;
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
            String simpleName = activity.getClass().getSimpleName();
            if (this.a.nameActivtyAuthenticate != null && this.a.nameActivtyAuthenticate.length() > 0 && this.a.nameActivtyAuthenticate.equals(simpleName)) {
                Log.i("debuglog", "unregister--------------------------------");
                this.a.unregisterBroadcastReceiver(activity);
            }
            if (this.a.nameActivtyCheckAuthen != null && this.a.nameActivtyCheckAuthen.length() > 0) {
                this.a.nameActivtyCheckAuthen.equals(simpleName);
            }
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public final void onActivityStarted(Activity activity) {
        }

        public final void onActivityStopped(Activity activity) {
        }
    }

    class b extends AsyncTask<Void, Void, String> {
        String a;
        final /* synthetic */ Authenticator b;

        private b(Authenticator authenticator) {
            this.b = authenticator;
        }

        private String a() {
            HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://oauth.zaloapp.com/v2/zalo/oauth_logout");
            httpClientRequest.addParams("appId", String.valueOf(ZaloSDKApplication.appID));
            httpClientRequest.addParams("oauthCode", this.a);
            httpClientRequest.addParams("frm", "sdk");
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("pl", "android");
                jSONObject.put("sdkv", ZaloSDK.Instance.getVersion());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            httpClientRequest.addParams("data", jSONObject.toString());
            return httpClientRequest.getText();
        }

        protected final /* synthetic */ Object doInBackground(Object[] objArr) {
            return a();
        }

        protected final /* synthetic */ void onPostExecute(Object obj) {
            String str = (String) obj;
            super.onPostExecute(str);
            try {
                new JSONObject(str).getInt("error");
            } catch (Exception e) {
            }
        }
    }

    class c extends AsyncTask<Void, Void, String> {
        ValidateOAuthCodeCallback a;
        String b;
        final /* synthetic */ Authenticator c;

        c(Authenticator authenticator, String str, ValidateOAuthCodeCallback validateOAuthCodeCallback) {
            this.c = authenticator;
            if (validateOAuthCodeCallback == null) {
                throw new IllegalArgumentException("callback can't be null");
            }
            this.a = validateOAuthCodeCallback;
            this.b = str;
        }

        protected final /* synthetic */ Object doInBackground(Object[] objArr) {
            HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, "https://oauth.zaloapp.com/v2/mobile/validate_oauth_code");
            httpClientRequest.addParams("app_id", String.valueOf(ZaloSDKApplication.appID));
            httpClientRequest.addParams("code", this.b);
            httpClientRequest.addParams("version", ZaloSDK.Instance.getVersion());
            httpClientRequest.addParams("frm", "sdk");
            return httpClientRequest.getText();
        }

        protected final /* synthetic */ void onPostExecute(Object obj) {
            String str = (String) obj;
            super.onPostExecute(str);
            try {
                JSONObject jSONObject = new JSONObject(str);
                int i = jSONObject.getInt("error");
                if (i == 0) {
                    jSONObject = jSONObject.getJSONObject("data");
                    long j = jSONObject.getLong("uid");
                    if (j == this.c.mStorage.getZaloId()) {
                        int optInt = jSONObject.optInt("zcert");
                        int optInt2 = jSONObject.optInt("zprotect");
                        this.c.mStorage.setIsGuestCertificated(optInt);
                        this.c.mStorage.setIsProtected(optInt2);
                    }
                    this.a.onValidateComplete(true, 0, j, this.b);
                    return;
                }
                this.a.onValidateComplete(false, i, -1, null);
            } catch (Exception e) {
                this.a.onValidateComplete(false, -1000, -1, null);
            }
        }
    }

    Authenticator(Context context, OauthStorage oauthStorage, LocalizedString localizedString) {
        this.mContext = context;
        this.mStorage = oauthStorage;
        this.mLocalizedString = localizedString;
    }

    private boolean checkZaloVersionSupport(Context context, int i) {
        try {
            if (context.getPackageManager().getPackageInfo("com.zing.zalo", 0).versionCode >= i) {
                return true;
            }
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(context);
            return false;
        } catch (NameNotFoundException e) {
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(context);
            return false;
        }
    }

    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        boolean z = (loginVia == LoginVia.APP || loginVia == LoginVia.APP_OR_WEB) ? false : true;
        if (!z) {
            if (AppInfo.isPackageExists(activity, "com.zing.zalo")) {
                try {
                    isGetZaloOAuth = true;
                    try {
                        this.isRegisBroadcastReceiver = false;
                        activity.unregisterReceiver(this.receiver);
                    } catch (Exception e) {
                    }
                    this.isRegisBroadcastReceiver = true;
                    activity.registerReceiver(this.receiver, new IntentFilter("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP"));
                    Intent intent = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
                    intent.putExtra("android.intent.extra.UID", ZaloSDKApplication.appID);
                    activity.startActivityForResult(intent, 64725);
                } catch (ActivityNotFoundException e2) {
                    isGetZaloOAuth = false;
                    this.bIsZaloOutOfDate = true;
                    getOAuthCompleteListener().onZaloOutOfDate(activity);
                } catch (SecurityException e3) {
                    isGetZaloOAuth = false;
                    this.bIsZaloOutOfDate = true;
                    getOAuthCompleteListener().onZaloOutOfDate(activity);
                }
            } else if (loginVia == LoginVia.APP) {
                isGetZaloOAuth = false;
                getOAuthCompleteListener().onZaloNotInstalled(activity);
            } else {
                z = true;
            }
        }
        if (!z) {
            return;
        }
        if (Utilities.a(activity)) {
            activity.startActivityForResult(WebLoginActivity.a((Context) activity, false), 64725);
        } else {
            Toast.makeText(activity, this.mLocalizedString.getNoNetworkMessage(), 0).show();
        }
    }

    void authenticate(Activity activity, LoginVia loginVia, boolean z, OAuthCompleteListener oAuthCompleteListener) {
        if (oAuthCompleteListener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyAuthenticate = activity.getClass().getSimpleName();
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(oAuthCompleteListener);
        this.zaloPluginLogin = z;
        sendOAuthRequest(activity, loginVia);
    }

    protected String getActivityNameAuthenticate() {
        return this.nameActivtyAuthenticate;
    }

    protected OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        return (this.wLoginFormListener == null || this.wLoginFormListener.get() == null) ? new OAuthCompleteListener() : (OAuthCompleteListener) this.wLoginFormListener.get();
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        return (this.wListener == null || this.wListener.get() == null) ? new OAuthCompleteListener() : (OAuthCompleteListener) this.wListener.get();
    }

    public OauthStorage getStorage() {
        return this.mStorage;
    }

    boolean isAuthenticate(String str, ValidateOAuthCodeCallback validateOAuthCodeCallback) {
        if (str != null && str.length() != 0) {
            if (validateOAuthCodeCallback != null) {
                new c(this, str, validateOAuthCodeCallback).execute(new Void[0]);
            }
            return true;
        } else if (validateOAuthCodeCallback == null) {
            return false;
        } else {
            validateOAuthCodeCallback.onValidateComplete(false, -1019, -1, null);
            return false;
        }
    }

    protected boolean onActivityResult(Activity activity, int i, int i2, Intent intent) {
        activity.getApplicationContext();
        if (i == 64725) {
            receiveOAuthData(activity, intent);
            return true;
        } else if (i != 64726) {
            return false;
        } else {
            receivePermissionData(activity, intent);
            return true;
        }
    }

    /* JADX WARNING: inconsistent code. */
    /* Code decompiled incorrectly, please refer to instructions dump. */
    void receiveOAuthData(android.app.Activity r8, android.content.Intent r9) {
        /*
        r7 = this;
        r2 = -1111; // 0xfffffffffffffba9 float:NaN double:NaN;
        r4 = 0;
        isGetZaloOAuth = r4;
        r0 = 0;
        r7.isRegisBroadcastReceiver = r0;	 Catch:{ Exception -> 0x011e }
        r0 = r7.receiver;	 Catch:{ Exception -> 0x011e }
        r8.unregisterReceiver(r0);	 Catch:{ Exception -> 0x011e }
    L_0x000d:
        r0 = r7.bIsZaloOutOfDate;
        if (r0 == 0) goto L_0x0012;
    L_0x0011:
        return;
    L_0x0012:
        r0 = r7.mStorage;
        r1 = "";
        r0.setAccessToken(r1);
        r0 = r7.mStorage;
        r1 = "";
        r0.setAccessTokenNewAPI(r1);
        if (r9 != 0) goto L_0x002c;
    L_0x0022:
        r0 = r7.getOAuthCompleteListener();
        r1 = "";
        r0.onAuthenError(r2, r1);
        goto L_0x0011;
    L_0x002c:
        r0 = "error";
        r0 = r9.getIntExtra(r0, r4);
        r1 = 203; // 0xcb float:2.84E-43 double:1.003E-321;
        if (r0 != r1) goto L_0x0042;
    L_0x0036:
        r0 = r7.getOAuthCompleteListener();
        r1 = -1118; // 0xfffffffffffffba2 float:NaN double:NaN;
        r2 = "Không thể đăng nhập Zalo.";
        r0.onAuthenError(r1, r2);
        goto L_0x0011;
    L_0x0042:
        if (r0 != 0) goto L_0x00c9;
    L_0x0044:
        r0 = "uid";
        r2 = 0;
        r2 = r9.getLongExtra(r0, r2);
        r0 = "code";
        r1 = r9.getStringExtra(r0);
        r0 = "isRegister";
        r4 = r9.getBooleanExtra(r0, r4);
        r0 = r7.zaloPluginLogin;
        if (r0 == 0) goto L_0x0066;
    L_0x005c:
        r0 = r7.mStorage;
        r0.setZaloPluginOAuthCode(r1);
        r0 = r7.mStorage;
        r0.setZaloPluginUserId(r2);
    L_0x0066:
        r0 = r7.zaloPluginLogin;
        if (r0 == 0) goto L_0x0076;
    L_0x006a:
        r0 = r7.mStorage;
        r0 = r0.getOAuthCode();
        r0 = android.text.TextUtils.isEmpty(r0);
        if (r0 != 0) goto L_0x007a;
    L_0x0076:
        r0 = r7.zaloPluginLogin;
        if (r0 != 0) goto L_0x00b1;
    L_0x007a:
        r0 = r7.mStorage;
        r5 = com.zing.zalo.zalosdk.oauth.LoginChannel.ZALO;
        r5 = r5.toString();
        r0.setOAuthCode(r5, r1);
        r0 = r7.mStorage;
        r0.setZaloId(r2);
        r0 = "data";
        r0 = r9.getStringExtra(r0);	 Catch:{ Exception -> 0x00c4 }
        r5 = new org.json.JSONObject;	 Catch:{ Exception -> 0x00c4 }
        r5.<init>(r0);	 Catch:{ Exception -> 0x00c4 }
        r0 = "data";
        r0 = r5.getJSONObject(r0);	 Catch:{ Exception -> 0x00c4 }
        r5 = "display_name";
        r5 = r0.getString(r5);	 Catch:{ Exception -> 0x00c4 }
        r6 = "zprotect";
        r0 = r0.optInt(r6);	 Catch:{ Exception -> 0x00c4 }
        r6 = r7.mStorage;	 Catch:{ Exception -> 0x00c4 }
        r6.setIsProtected(r0);	 Catch:{ Exception -> 0x00c4 }
        r0 = r7.mStorage;	 Catch:{ Exception -> 0x00c4 }
        r0.setZaloDisplayName(r5);	 Catch:{ Exception -> 0x00c4 }
    L_0x00b1:
        r0 = new com.zing.zalo.zalosdk.oauth.OauthResponse;
        r5 = com.zing.zalo.zalosdk.oauth.LoginChannel.ZALO;
        r0.<init>(r2, r1, r5);
        r0.setRegister(r4);
        r1 = r7.getOAuthCompleteListener();
        r1.onGetOAuthComplete(r0);
        goto L_0x0011;
    L_0x00c4:
        r0 = move-exception;
        r0.printStackTrace();
        goto L_0x00b1;
    L_0x00c9:
        r1 = 4;
        if (r0 != r1) goto L_0x00e8;
    L_0x00cc:
        r0 = r7.bIsZaloLoginSuccessful;
        if (r0 == 0) goto L_0x00dd;
    L_0x00d0:
        r0 = com.zing.zalo.zalosdk.oauth.LoginVia.APP;
        r1 = r7.zaloPluginLogin;
        r2 = r7.getOAuthCompleteListener();
        r7.authenticate(r8, r0, r1, r2);
        goto L_0x0011;
    L_0x00dd:
        r0 = r7.getOAuthCompleteListener();
        r1 = "";
        r0.onAuthenError(r2, r1);
        goto L_0x0011;
    L_0x00e8:
        r2 = com.zing.zalo.zalosdk.auth.internal.b.a(r0);
        r1 = "Không thể đăng nhập Zalo.";
        r0 = "data";
        r0 = r9.getStringExtra(r0);	 Catch:{ Exception -> 0x0116 }
        r3 = android.text.TextUtils.isEmpty(r0);	 Catch:{ Exception -> 0x0116 }
        if (r3 != 0) goto L_0x011c;
    L_0x00fa:
        r3 = new org.json.JSONObject;	 Catch:{ Exception -> 0x0116 }
        r3.<init>(r0);	 Catch:{ Exception -> 0x0116 }
        r0 = "errorMsg";
        r0 = r3.getString(r0);	 Catch:{ Exception -> 0x0116 }
        if (r0 == 0) goto L_0x011c;
    L_0x0107:
        r3 = r0.length();	 Catch:{ Exception -> 0x0116 }
        if (r3 <= 0) goto L_0x011c;
    L_0x010d:
        r1 = r7.getOAuthCompleteListener();
        r1.onAuthenError(r2, r0);
        goto L_0x0011;
    L_0x0116:
        r0 = move-exception;
        r0 = "zalo return empty message";
        com.zing.zalo.zalosdk.core.log.Log.v(r0);
    L_0x011c:
        r0 = r1;
        goto L_0x010d;
    L_0x011e:
        r0 = move-exception;
        goto L_0x000d;
        */
        throw new UnsupportedOperationException("Method not decompiled: com.zing.zalo.zalosdk.oauth.Authenticator.receiveOAuthData(android.app.Activity, android.content.Intent):void");
    }

    void receivePermissionData(Activity activity, Intent intent) {
        if (intent != null) {
            getOAuthCompleteListener().onGetPermissionData(com.zing.zalo.zalosdk.auth.internal.b.a(intent.getIntExtra("error", 0)));
            return;
        }
        getOAuthCompleteListener().onGetPermissionData(-1111);
    }

    public void registerAppLifeCycle(Application application) {
        if (!Utils.belowSandwich() && this.callbackAppLifeCycle == null) {
            this.callbackAppLifeCycle = new a(this);
            application.registerActivityLifecycleCallbacks(this.callbackAppLifeCycle);
        }
    }

    void registerZalo(Activity activity, OAuthCompleteListener oAuthCompleteListener) {
        if (oAuthCompleteListener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyAuthenticate = activity.getClass().getSimpleName();
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(oAuthCompleteListener);
        activity.startActivityForResult(WebLoginActivity.a((Context) activity, true), 64725);
    }

    void requestPermissions(Activity activity, Enum<Permissions> enumR, OAuthCompleteListener oAuthCompleteListener) {
        if (!checkZaloVersionSupport(activity, 90)) {
            return;
        }
        if (oAuthCompleteListener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        setOAuthCompleteListener(oAuthCompleteListener);
        Context applicationContext = activity.getApplicationContext();
        Intent intent = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
        intent.putExtra("app_id", ZaloSDK.Instance.getAppID());
        intent.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
        intent.putExtra("pkg_name", AppInfo.getPackageName(applicationContext));
        intent.putExtra("sign_key", AppInfo.getApplicationHashKey(applicationContext));
        intent.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
        intent.putExtra("permission", enumR.toString());
        activity.startActivityForResult(intent, 64726);
    }

    public void resetListener() {
        this.wListener = null;
    }

    protected void setLoginFormOAuthCompleteListener(OAuthCompleteListener oAuthCompleteListener) {
        this.wLoginFormListener = new WeakReference(oAuthCompleteListener);
    }

    public void setOAuthCompleteListener(OAuthCompleteListener oAuthCompleteListener) {
        this.wListener = new WeakReference(oAuthCompleteListener);
    }

    protected void unauthenticate() {
        try {
            b bVar = new b();
            bVar.a = this.mStorage.getOAuthCode();
            if (!TextUtils.isEmpty(bVar.a)) {
                bVar.execute(null);
            }
            long zaloId = ZaloSDK.Instance.getZaloId();
            this.mContext.getSharedPreferences("zacPref", 0).edit().remove("MAX_PAGING" + zaloId).remove("GIFTCODE_EXPIRED_TIME" + zaloId).remove("CACHE_CODE_LIST" + zaloId).remove("CURRENT_PAGE" + zaloId).commit();
            this.mStorage.setAccessToken("");
            this.mStorage.setAccessTokenNewAPI("");
            this.mStorage.setOAuthCode("", "");
            this.mStorage.setZaloId(0);
            this.mStorage.setZaloDisplayName("");
            this.mStorage.setZaloPluginOAuthCode("");
            this.mStorage.setSocialId("");
        } catch (Exception e) {
        }
    }

    public void unregisterAppLifeCycle(Application application) {
        if (!Utils.belowSandwich() && this.callbackAppLifeCycle != null) {
            try {
                application.unregisterActivityLifecycleCallbacks(this.callbackAppLifeCycle);
            } catch (Exception e) {
            }
        }
    }

    public void unregisterBroadcastReceiver(Activity activity) {
        try {
            if (this.isRegisBroadcastReceiver) {
                activity.unregisterReceiver(this.receiver);
            }
        } catch (Exception e) {
        }
    }
}
