package com.zing.zalo.zalosdk.auth.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlertDialog.Builder;
import android.app.DatePickerDialog;
import android.app.DatePickerDialog.OnDateSetListener;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.content.DialogInterface.OnDismissListener;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore.Images.Media;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.text.Editable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.l.d;
import com.zing.zalo.zalosdk.core.helper.BitmapHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@TargetApi(10)
public final class p extends k implements OnClickListener, OnTouchListener {
    protected b a;
    String b = "";
    private EditText c;
    private RadioButton d;
    private RadioButton e;
    private View f;
    private View g;
    private ImageView h;
    private TextView j;
    private TextView k;
    private LayoutInflater l;
    private String m;
    private String n;
    private String o;
    private String p;
    private String q;
    private String r;
    private String s;
    private long t;
    private int u;
    private Bitmap v;
    private Uri w;

    @SuppressLint({"ValidFragment"})
    public static class a extends DialogFragment implements OnDateSetListener, OnCancelListener, OnDismissListener {
        Date a;
        a b;

        interface a {
            void a();

            void a(int i, int i2, int i3);
        }

        public a(Date date, a aVar) {
            this.b = aVar;
            this.a = date;
        }

        public final void onCancel(DialogInterface dialogInterface) {
            super.onCancel(dialogInterface);
            if (this.b != null) {
                this.b.a();
            }
        }

        public final Dialog onCreateDialog(Bundle bundle) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(this.a);
            int i = instance.get(1);
            int i2 = instance.get(2);
            int i3 = instance.get(5);
            Dialog datePickerDialog = new DatePickerDialog(getActivity(), 1, this, i, i2, i3);
            if (VERSION.SDK_INT >= 21) {
                datePickerDialog = new DatePickerDialog(getActivity(), 16974394, this, i, i2, i3);
            } else if (VERSION.SDK_INT >= 14) {
                datePickerDialog = new DatePickerDialog(getActivity(), 3, this, i, i2, i3);
            }
            datePickerDialog.getDatePicker().setMaxDate(new Date().getTime());
            datePickerDialog.setOnCancelListener(this);
            datePickerDialog.setOnDismissListener(this);
            return datePickerDialog;
        }

        public final void onDateSet(DatePicker datePicker, int i, int i2, int i3) {
            if (this.b != null) {
                this.b.a(i, i2, i3);
            }
        }

        public final void onDismiss(DialogInterface dialogInterface) {
            super.onDismiss(dialogInterface);
            if (this.b != null) {
                this.b.a();
            }
        }
    }

    public interface b extends com.zing.zalo.zalosdk.auth.internal.k.a {
    }

    public static p a(String str, String str2, long j, String str3, String str4, String str5, String str6, int i, String str7) {
        p pVar = new p();
        Bundle bundle = new Bundle();
        bundle.putString("phoneNumber", str);
        bundle.putString("countryCode", str2);
        bundle.putLong("uid", j);
        bundle.putString("oauthCode", str3);
        bundle.putString("displayName", str4);
        bundle.putString("gender", str5);
        bundle.putString("dob", str6);
        bundle.putInt("zprotect", i);
        bundle.putString("token", str7);
        pVar.setArguments(bundle);
        return pVar;
    }

    private void a(int i) {
        if (ContextCompat.checkSelfPermission(getContext(), "android.permission.READ_EXTERNAL_STORAGE") != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale(getActivity(), "android.permission.READ_EXTERNAL_STORAGE")) {
                a(i == 11 ? "You need to allow access to Photo Gallery" : "Camera need to store photo to your sd card.", new DialogInterface.OnClickListener(this) {
                    final /* synthetic */ p a;

                    {
                        this.a = r1;
                    }

                    public final void onClick(DialogInterface dialogInterface, int i) {
                        p.h(this.a);
                    }
                });
            } else {
                requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, i);
            }
        } else if (i == 11) {
            h();
        } else {
            j();
        }
    }

    private void a(TextView textView, String str) {
        int i = 0;
        CharSequence fromHtml = Html.fromHtml(str);
        CharSequence spannableStringBuilder = new SpannableStringBuilder(fromHtml);
        URLSpan[] uRLSpanArr = (URLSpan[]) spannableStringBuilder.getSpans(0, fromHtml.length(), URLSpan.class);
        int length = uRLSpanArr.length;
        while (i < length) {
            Object obj = uRLSpanArr[i];
            spannableStringBuilder.setSpan(new ClickableSpan(this) {
                final /* synthetic */ p a;

                {
                    this.a = r1;
                }

                public final void onClick(View view) {
                    Utils.hideSoftKeyboard(this.a.getActivity());
                    p.e(this.a);
                }

                public final void updateDrawState(TextPaint textPaint) {
                    textPaint.setColor(-16777216);
                }
            }, spannableStringBuilder.getSpanStart(obj), spannableStringBuilder.getSpanEnd(obj), spannableStringBuilder.getSpanFlags(obj));
            spannableStringBuilder.removeSpan(obj);
            i++;
        }
        textView.setText(spannableStringBuilder);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void a(String str, DialogInterface.OnClickListener onClickListener) {
        new Builder(getContext()).setMessage(str).setPositiveButton("Go Settings", onClickListener).setNegativeButton("Cancel", null).create().show();
    }

    static /* synthetic */ void b(p pVar) {
        pVar.g.setEnabled(true);
        pVar.g.getBackground().setAlpha(255);
    }

    private void e() {
        this.g.setEnabled(false);
        this.g.getBackground().setAlpha(51);
    }

    static /* synthetic */ void e(p pVar) {
        if ("0999666666".equalsIgnoreCase(pVar.m)) {
            pVar.a(-1, 0, "", 0, "", true);
            return;
        }
        pVar.a(0, pVar.t, pVar.o, pVar.u, pVar.p, true);
    }

    private void f() {
        this.c.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
    }

    private void g() {
        ((InputMethodManager) getActivity().getSystemService("input_method")).hideSoftInputFromWindow(this.c.getWindowToken(), 0);
    }

    static /* synthetic */ void g(p pVar) {
        int i = ContextCompat.checkSelfPermission(pVar.getContext(), "android.permission.CAMERA") != 0 ? 1 : 0;
        if (!Utils.hasPermissionInManifest(pVar.getContext(), "android.permission.CAMERA") || i == 0) {
            pVar.j();
        } else if (ActivityCompat.shouldShowRequestPermissionRationale(pVar.getActivity(), "android.permission.CAMERA")) {
            pVar.a("You need to allow access to Camera", new DialogInterface.OnClickListener(pVar) {
                final /* synthetic */ p a;

                {
                    this.a = r1;
                }

                public final void onClick(DialogInterface dialogInterface, int i) {
                    p.h(this.a);
                }
            });
        } else {
            pVar.requestPermissions(new String[]{"android.permission.CAMERA"}, 12);
        }
    }

    private void h() {
        Intent intent = new Intent("android.intent.action.PICK", Media.EXTERNAL_CONTENT_URI);
        this.w = Uri.fromFile(new File(Environment.getExternalStorageDirectory(), "tmp_avatar_" + String.valueOf(System.currentTimeMillis()) + ".jpg"));
        intent.putExtra("output", this.w);
        startActivityForResult(intent, 1);
    }

    static /* synthetic */ void h(p pVar) {
        Intent intent = new Intent();
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts("package", pVar.getContext().getPackageName(), null));
        pVar.getContext().startActivity(intent);
    }

    private File i() {
        try {
            return Environment.getExternalStorageState().equals("mounted") ? new File(Environment.getExternalStorageDirectory(), "tmp_avatar_" + String.valueOf(System.currentTimeMillis()) + ".jpg") : new File(getContext().getCacheDir(), "tmp_avatar_" + String.valueOf(System.currentTimeMillis()) + ".jpg");
        } catch (Exception e) {
            return null;
        }
    }

    private void j() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(getContext().getPackageManager()) != null) {
            File i = i();
            this.b = i.getAbsolutePath();
            Log.i("debuglog", "file path: " + i.getAbsolutePath());
            this.w = FileProvider.getUriForFile(getContext(), getContext().getApplicationContext().getPackageName() + ".zalosdk.fileprovider", i);
            intent.addFlags(1);
            intent.putExtra("output", this.w);
            intent.putExtra("return-data", true);
            startActivityForResult(intent, 2);
        }
    }

    public final void onActivityResult(int i, int i2, Intent intent) {
        super.onActivityResult(i, i2, intent);
        Log.i("debuglog", "onActivityResult: resultCode " + i2 + " requestCode: " + i);
        if (i2 == -1) {
            Uri data = (intent == null || intent.getData() == null) ? this.w : intent.getData();
            if (data == null) {
                Log.i("debuglog", "uri is null");
            }
            try {
                this.v = BitmapHelper.handleSamplingAndRotationBitmap(getContext(), data, 512, 512, this.b);
                this.h.setImageBitmap(this.v);
                File file = new File(data.getPath());
                if (file.exists()) {
                    file.delete();
                }
            } catch (Exception e) {
                Log.e(e);
            }
        }
    }

    public final void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.a = (b) this.i;
        } catch (ClassCastException e) {
            Log.e(context.getClass().getSimpleName() + " must implement " + d.class.getSimpleName());
        }
    }

    public final void onClick(View view) {
        if (this.d == view) {
            g();
            this.e.setChecked(false);
        } else if (this.e == view) {
            g();
            this.d.setChecked(false);
        } else if (this.f == view || this.j == view) {
            Date parse;
            g();
            this.f.setEnabled(false);
            try {
                parse = new SimpleDateFormat("dd/MM/yyyy").parse(this.j.getText().toString());
            } catch (Exception e) {
                parse = new Date();
            }
            new a(parse, new a(this) {
                final /* synthetic */ p a;

                {
                    this.a = r1;
                }

                public final void a() {
                    this.a.f.setEnabled(true);
                }

                public final void a(int i, int i2, int i3) {
                    String valueOf = String.valueOf(i3);
                    if (valueOf.length() == 1) {
                        valueOf = "0" + valueOf;
                    }
                    String valueOf2 = String.valueOf(i2 + 1);
                    if (valueOf2.length() == 1) {
                        valueOf2 = "0" + valueOf2;
                    }
                    this.a.j.setText(valueOf + "/" + valueOf2 + "/" + String.valueOf(i));
                    this.a.f.setEnabled(true);
                }
            }).show(getActivity().getSupportFragmentManager(), "datePicker");
        } else if (this.g == view) {
            boolean z;
            if (this.c.getText().toString().trim().length() == 0) {
                a(getString(R.string.txt_thong_bao_upper), getString(R.string.txt_input_name));
                z = false;
            } else {
                z = true;
            }
            if (z) {
                b bVar = new b();
                this.p = this.c.getText().toString().trim();
                bVar.a = this.s;
                bVar.b = this.m;
                bVar.c = this.t;
                bVar.d = this.p;
                bVar.e = this.d.isChecked() ? 1 : 2;
                bVar.g = BitmapHelper.toByteArray(this.v);
                bVar.h = this.n;
                try {
                    bVar.f = new SimpleDateFormat("yyyy-MM-dd").format(new SimpleDateFormat("dd/MM/yyyy").parse(this.j.getText().toString()));
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
                a();
                new g(getContext(), new a(this) {
                    final /* synthetic */ p a;

                    {
                        this.a = r1;
                    }

                    public final void a(c cVar) {
                        this.a.b();
                        if (this.a.a != null) {
                            if (cVar.b != 0) {
                                this.a.a(this.a.getString(Utils.getResourceId(this.a.getActivity(), "txt_thong_bao_upper", "string")), cVar.c);
                            } else {
                                this.a.a(0, this.a.t, this.a.o, this.a.u, this.a.p, true);
                            }
                        }
                    }
                }).execute(new b[]{bVar});
            }
        } else if (this.h == view) {
            g();
            View inflate = this.l.inflate(Utils.getResourceId(getContext(), "custom_photo_action_dialog", "layout"), null);
            final Dialog dialog = new Dialog(getContext());
            dialog.requestWindowFeature(1);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(0));
            dialog.setContentView(inflate);
            dialog.findViewById(Utils.getResourceId(getContext(), "open_photo", "id")).setOnClickListener(new OnClickListener(this) {
                final /* synthetic */ p b;

                public final void onClick(View view) {
                    this.b.a(11);
                    dialog.dismiss();
                }
            });
            dialog.findViewById(Utils.getResourceId(getContext(), "take_camera", "id")).setOnClickListener(new OnClickListener(this) {
                final /* synthetic */ p b;

                public final void onClick(View view) {
                    p.g(this.b);
                    dialog.dismiss();
                }
            });
            dialog.show();
        }
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        boolean z = true;
        int resourceId = Utils.getResourceId(getContext(), "zalosdk_fragment_zalo_web_update_profile", "layout");
        Bundle arguments = getArguments();
        this.m = arguments.getString("phoneNumber");
        this.n = arguments.getString("countryCode");
        this.t = arguments.getLong("uid");
        this.o = arguments.getString("oauthCode");
        this.p = arguments.getString("displayName");
        this.q = arguments.getString("gender");
        this.r = arguments.getString("dob");
        this.u = arguments.getInt("zprotect");
        this.s = arguments.getString("token");
        this.l = layoutInflater;
        View inflate = layoutInflater.inflate(resourceId, viewGroup, false);
        this.c = (EditText) inflate.findViewById(Utils.getResourceId(getContext(), "name", "id"));
        this.c.setOnTouchListener(this);
        this.c.requestFocus();
        if (TextUtils.isEmpty(this.p)) {
            this.c.setText(this.p);
        }
        boolean z2 = this.q.equals("2") || this.q.equals("female");
        this.d = (RadioButton) inflate.findViewById(Utils.getResourceId(getContext(), "gender_male", "id"));
        this.d.setOnClickListener(this);
        RadioButton radioButton = this.d;
        if (z2) {
            z = false;
        }
        radioButton.setChecked(z);
        this.e = (RadioButton) inflate.findViewById(Utils.getResourceId(getContext(), "gender_female", "id"));
        this.e.setOnClickListener(this);
        this.e.setChecked(z2);
        this.f = inflate.findViewById(Utils.getResourceId(getContext(), "edit_day", "id"));
        this.f.setOnClickListener(this);
        this.g = inflate.findViewById(Utils.getResourceId(getContext(), "update", "id"));
        this.g.setOnClickListener(this);
        this.h = (ImageView) inflate.findViewById(Utils.getResourceId(getContext(), "update_avatar", "id"));
        this.h.setOnClickListener(this);
        this.j = (TextView) inflate.findViewById(Utils.getResourceId(getContext(), "birthday", "id"));
        if (TextUtils.isEmpty(this.r)) {
            this.j.setText("01/01/1970");
        } else {
            try {
                this.j.setText(new SimpleDateFormat("dd/MM/yyyy").format(new SimpleDateFormat("dd/MM/yyyy").parse(this.r)));
            } catch (Exception e) {
                e.printStackTrace();
                this.j.setText("01/01/1970");
            }
        }
        this.j.setOnClickListener(this);
        this.k = (TextView) inflate.findViewById(Utils.getResourceId(getContext(), "next", "id"));
        a(this.k, getString(Utils.getResourceId(getActivity(), "next_step", "string")));
        this.c.addTextChangedListener(new TextWatcher(this) {
            final /* synthetic */ p a;

            {
                this.a = r1;
            }

            public final void afterTextChanged(Editable editable) {
                if (editable.toString().length() > 2) {
                    this.a.c.setCompoundDrawablesWithIntrinsicBounds(0, 0, Utils.getResourceId(this.a.getActivity(), "zalosdk_icon_x", "drawable"), 0);
                    p.b(this.a);
                    return;
                }
                this.a.f();
                this.a.e();
            }

            public final void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public final void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }
        });
        f();
        e();
        a(inflate, "parent0");
        getActivity().getWindow().setSoftInputMode(34);
        return inflate;
    }

    public final void onDetach() {
        super.onDetach();
        this.a = null;
    }

    public final void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
        super.onRequestPermissionsResult(i, strArr, iArr);
        if (i == 13) {
            if (iArr.length > 0 && iArr[0] == 0) {
                j();
            }
        } else if (i == 11) {
            if (iArr.length > 0 && iArr[0] == 0) {
                h();
            }
        } else if (i == 12 && iArr.length > 0 && iArr[0] == 0) {
            a(13);
        }
    }

    public final void onResume() {
        super.onResume();
        a(getString(Utils.getResourceId(getActivity(), "txt_update_info", "string")));
        d();
    }

    public final boolean onTouch(View view, MotionEvent motionEvent) {
        if (view == this.c && motionEvent.getAction() == 1 && this.c.getCompoundDrawables() != null && this.c.getCompoundDrawables()[2] != null && motionEvent.getRawX() >= ((float) (this.c.getRight() - this.c.getCompoundDrawables()[2].getBounds().width()))) {
            this.c.setText("");
        }
        return false;
    }
}
