/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.q;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.payment.direct.PaymentDialog;

public class PaymentProcessingDialog
extends PaymentDialog
implements DialogInterface.OnDismissListener {
    String LOG_TAG = PaymentProcessingDialog.class.getSimpleName();
    String zalosdk_processing;
    String zalosdk_success;
    String zalosdk_unsuccess;
    String zalosdk_atm_processing;
    String zalosdk_atm_processing_waiting;
    String zalosdk_timeout_message;
    long timeOut;
    long atmWaitingTimeOut;
    long zingCoinTimeOut;
    public boolean isShow = false;
    boolean isTimeOut = false;
    int viewIndex = 0;
    Handler handler;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (PaymentProcessingDialog.this.viewIndex > 0 && PaymentProcessingDialog.this.isShowing()) {
                PaymentProcessingDialog.this.hideView();
                if (PaymentProcessingDialog.this.listener != null) {
                    PaymentProcessingDialog.this.listener.onClose();
                }
            }
        }
    };
    Runnable runnableATMWaiting = new Runnable(){

        @Override
        public void run() {
            if (PaymentProcessingDialog.this.isShow) {
                PaymentProcessingDialog.this.updateProcessingTransactionView(PaymentProcessingDialog.this.zalosdk_atm_processing_waiting);
            }
        }
    };
    Runnable runnableTimeOut = new Runnable(){

        @Override
        public void run() {
            Log.i((String)"THREAD START", (String)("time out " + PaymentProcessingDialog.this.isShow + " " + PaymentProcessingDialog.this.viewIndex));
            if (PaymentProcessingDialog.this.isShow && PaymentProcessingDialog.this.viewIndex == 0) {
                PaymentProcessingDialog.this.hideView();
                PaymentProcessingDialog.this.showView(Status.TIMEOUT);
            }
        }
    };
    OnCloseListener listener;

    public boolean isTimeOut() {
        return this.isTimeOut;
    }

    public void setTimeOut(boolean bl) {
        this.isTimeOut = bl;
    }

    public PaymentProcessingDialog(Context context, OnCloseListener onCloseListener) {
        super(context);
        this.handler = new Handler();
        this.listener = onCloseListener;
        this.setOnDismissListener(this);
        this.zalosdk_processing = q.a("zalosdk_processing");
        this.zalosdk_success = q.a("zalosdk_success");
        this.zalosdk_unsuccess = q.a("zalosdk_unsuccess");
        this.zalosdk_atm_processing = q.a("zalosdk_atm_processing");
        this.zalosdk_atm_processing_waiting = q.a("zalosdk_atm_processing_waiting");
        this.timeOut = Long.parseLong(q.a("zalosdk_otp_timeout"));
        this.zingCoinTimeOut = Long.parseLong(q.a("zalosdk_zing_coin_timeout"));
        this.atmWaitingTimeOut = Long.parseLong(q.a("zalosdk_atm_waiting_timeout"));
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.zalosdk_activity_processing);
    }

    public void updateProcessingTransactionView(String string2) {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)string2);
    }

    public void showProcessingTransactionView(String string2) {
        this.show();
        this.isShow = true;
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)string2);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
    }

    private void showATMProcessingView() {
        Log.i((String)"debuglog", (String)("timeOut::: " + this.timeOut));
        Log.i((String)"debuglog", (String)("atmWaitingTimeOut::: " + this.atmWaitingTimeOut));
        this.setContentView(R.layout.zalosdk_activity_processing);
        try {
            this.handler.removeCallbacks(this.runnableATMWaiting);
            this.handler.removeCallbacks(this.runnableTimeOut);
        }
        catch (Exception exception) {}
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_atm_processing);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
        this.zalosdk_timeout_message = q.a("zalosdk_channels_opt_timeout");
        this.handler.postDelayed(this.runnableATMWaiting, this.atmWaitingTimeOut);
        this.handler.postDelayed(this.runnableTimeOut, this.timeOut);
    }

    private void showProcessingView() {
        Log.i((String)"THREAD BEGIN", (String)"PROCESSING!!");
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_processing);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
    }

    private void showZingCoinProcessingView() {
        try {
            this.handler.removeCallbacks(this.runnable);
            this.handler.removeCallbacks(this.runnableTimeOut);
        }
        catch (Exception exception) {}
        Log.i((String)"THREAD showZingCoinProcessingView", (String)"time out");
        this.showProcessingView();
        this.zalosdk_timeout_message = q.a("zalosdk_zingcoin_timeout_msg");
        this.handler.postDelayed(this.runnableTimeOut, this.zingCoinTimeOut);
    }

    private void showSuccessView() {
        Log.i((String)this.LOG_TAG, (String)"Show success dialog");
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_success);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_success);
        imageView.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    private void showUnSuccessView() {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_unsuccess);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_fail);
        imageView.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    private void showTimeOutView() {
        Log.i((String)"debuglog", (String)"time out showview");
        this.findViewById(R.id.zalosdk_process_dialog_ctl).setVisibility(8);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 1L);
        this.isTimeOut = true;
    }

    private void autoClose() {
        this.handler.postDelayed(this.runnable, 3000L);
    }

    public void showViewError(String string2) {
        this.show();
        this.isShow = true;
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)string2);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        string2 = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        string2.setImageResource(R.drawable.zalosdk_ic_fail);
        string2.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    public void showView(Status status) {
        this.show();
        this.isShow = true;
        switch (status) {
            case PROCESSING: {
                this.showProcessingView();
                return;
            }
            case SUCCESS: {
                this.showSuccessView();
                return;
            }
            case FAILED: {
                this.showUnSuccessView();
                return;
            }
            case TIMEOUT: {
                this.showTimeOutView();
                return;
            }
            case OTPROCESSING: 
            case ATMPROCESSING: {
                this.showATMProcessingView();
                return;
            }
            case ZINGCOINPROCESSING: {
                this.showZingCoinProcessingView();
            }
        }
    }

    public void showUnSuccessView(String string2) {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)string2);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        string2 = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        string2.setImageResource(R.drawable.zalosdk_ic_fail);
        string2.setVisibility(0);
        this.setCancelable(true);
        if (!this.isShowing()) {
            this.show();
        }
        this.viewIndex = 1;
        this.autoClose();
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.listener != null) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)"cancel");
            this.listener.onClose();
        }
    }

    public void onBackPressed() {
    }

    public void hideView() {
        this.isShow = false;
        this.hide();
    }

    public void removeAllCallBack() {
        try {
            this.handler.removeCallbacks(this.runnable);
            this.handler.removeCallbacks(this.runnableATMWaiting);
            this.handler.removeCallbacks(this.runnableTimeOut);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void closeView() {
        this.viewIndex = 1;
        this.autoClose();
    }

    public void closeViewImmediately() {
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 0L);
    }

    public void finishProcessingWithoutShowDialog() {
        if (this.listener != null) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)"cancel");
            this.listener.onClose();
        }
    }

    public void show() {
        Log.i((String)this.LOG_TAG, (String)"show loading..");
        try {
            super.show();
            return;
        }
        catch (Exception exception) {
            Log.i((String)this.LOG_TAG, (String)"error can not show loading");
            return;
        }
    }

    public void hide() {
        Log.i((String)this.LOG_TAG, (String)"hide loading!");
        super.hide();
    }

    public static interface OnCloseListener {
        public void onClose();
    }

    public static enum Status {
        PROCESSING,
        SUCCESS,
        FAILED,
        TIMEOUT,
        OTPROCESSING,
        ATMPROCESSING,
        ZINGCOINPROCESSING;

    }
}

