package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnDismissListener;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.q;
import com.zing.zalo.zalosdk.core.log.Log;

public class PaymentProcessingDialog extends PaymentDialog implements OnDismissListener {
    String LOG_TAG = PaymentProcessingDialog.class.getSimpleName();
    long atmWaitingTimeOut;
    Handler handler = new Handler();
    public boolean isShow = false;
    boolean isTimeOut = false;
    OnCloseListener listener;
    Runnable runnable = new Runnable() {
        public void run() {
            if (PaymentProcessingDialog.this.viewIndex > 0 && PaymentProcessingDialog.this.isShowing()) {
                PaymentProcessingDialog.this.hideView();
                if (PaymentProcessingDialog.this.listener != null) {
                    PaymentProcessingDialog.this.listener.onClose();
                }
            }
        }
    };
    Runnable runnableATMWaiting = new Runnable() {
        public void run() {
            if (PaymentProcessingDialog.this.isShow) {
                PaymentProcessingDialog.this.updateProcessingTransactionView(PaymentProcessingDialog.this.zalosdk_atm_processing_waiting);
            }
        }
    };
    Runnable runnableTimeOut = new Runnable() {
        public void run() {
            Log.i("THREAD START", "time out " + PaymentProcessingDialog.this.isShow + " " + PaymentProcessingDialog.this.viewIndex);
            if (PaymentProcessingDialog.this.isShow && PaymentProcessingDialog.this.viewIndex == 0) {
                PaymentProcessingDialog.this.hideView();
                PaymentProcessingDialog.this.showView(Status.TIMEOUT);
            }
        }
    };
    long timeOut;
    int viewIndex = 0;
    String zalosdk_atm_processing;
    String zalosdk_atm_processing_waiting;
    String zalosdk_processing;
    String zalosdk_success;
    String zalosdk_timeout_message;
    String zalosdk_unsuccess;
    long zingCoinTimeOut;

    public interface OnCloseListener {
        void onClose();
    }

    public enum Status {
        PROCESSING,
        SUCCESS,
        FAILED,
        TIMEOUT,
        OTPROCESSING,
        ATMPROCESSING,
        ZINGCOINPROCESSING
    }

    public PaymentProcessingDialog(Context context, OnCloseListener onCloseListener) {
        super(context);
        this.listener = onCloseListener;
        setOnDismissListener(this);
        this.zalosdk_processing = q.a("zalosdk_processing");
        this.zalosdk_success = q.a("zalosdk_success");
        this.zalosdk_unsuccess = q.a("zalosdk_unsuccess");
        this.zalosdk_atm_processing = q.a("zalosdk_atm_processing");
        this.zalosdk_atm_processing_waiting = q.a("zalosdk_atm_processing_waiting");
        this.timeOut = Long.parseLong(q.a("zalosdk_otp_timeout"));
        this.zingCoinTimeOut = Long.parseLong(q.a("zalosdk_zing_coin_timeout"));
        this.atmWaitingTimeOut = Long.parseLong(q.a("zalosdk_atm_waiting_timeout"));
    }

    private void autoClose() {
        this.handler.postDelayed(this.runnable, 3000);
    }

    private void showATMProcessingView() {
        Log.i("debuglog", "timeOut::: " + this.timeOut);
        Log.i("debuglog", "atmWaitingTimeOut::: " + this.atmWaitingTimeOut);
        setContentView(R.layout.zalosdk_activity_processing);
        try {
            this.handler.removeCallbacks(this.runnableATMWaiting);
            this.handler.removeCallbacks(this.runnableTimeOut);
        } catch (Exception e) {
        }
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_atm_processing);
        findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        setCancelable(false);
        this.viewIndex = 0;
        this.zalosdk_timeout_message = q.a("zalosdk_channels_opt_timeout");
        this.handler.postDelayed(this.runnableATMWaiting, this.atmWaitingTimeOut);
        this.handler.postDelayed(this.runnableTimeOut, this.timeOut);
    }

    private void showProcessingView() {
        Log.i("THREAD BEGIN", "PROCESSING!!");
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_processing);
        findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        setCancelable(false);
        this.viewIndex = 0;
    }

    private void showSuccessView() {
        Log.i(this.LOG_TAG, "Show success dialog");
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_success);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView) findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_success);
        imageView.setVisibility(0);
        setCancelable(true);
        this.viewIndex = 1;
        autoClose();
    }

    private void showTimeOutView() {
        Log.i("debuglog", "time out showview");
        findViewById(R.id.zalosdk_process_dialog_ctl).setVisibility(8);
        setCancelable(true);
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 1);
        this.isTimeOut = true;
    }

    private void showUnSuccessView() {
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(this.zalosdk_unsuccess);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView) findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_fail);
        imageView.setVisibility(0);
        setCancelable(true);
        this.viewIndex = 1;
        autoClose();
    }

    private void showZingCoinProcessingView() {
        try {
            this.handler.removeCallbacks(this.runnable);
            this.handler.removeCallbacks(this.runnableTimeOut);
        } catch (Exception e) {
        }
        Log.i("THREAD showZingCoinProcessingView", "time out");
        showProcessingView();
        this.zalosdk_timeout_message = q.a("zalosdk_zingcoin_timeout_msg");
        this.handler.postDelayed(this.runnableTimeOut, this.zingCoinTimeOut);
    }

    public void closeView() {
        this.viewIndex = 1;
        autoClose();
    }

    public void closeViewImmediately() {
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 0);
    }

    public void finishProcessingWithoutShowDialog() {
        if (this.listener != null) {
            Log.i(getClass().getName(), "cancel");
            this.listener.onClose();
        }
    }

    public void hide() {
        Log.i(this.LOG_TAG, "hide loading!");
        super.hide();
    }

    public void hideView() {
        this.isShow = false;
        hide();
    }

    public boolean isTimeOut() {
        return this.isTimeOut;
    }

    public void onBackPressed() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        setContentView(R.layout.zalosdk_activity_processing);
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.listener != null) {
            Log.i(getClass().getName(), "cancel");
            this.listener.onClose();
        }
    }

    public void removeAllCallBack() {
        try {
            this.handler.removeCallbacks(this.runnable);
            this.handler.removeCallbacks(this.runnableATMWaiting);
            this.handler.removeCallbacks(this.runnableTimeOut);
        } catch (Exception e) {
        }
    }

    public void setTimeOut(boolean z) {
        this.isTimeOut = z;
    }

    public void show() {
        Log.i(this.LOG_TAG, "show loading..");
        try {
            super.show();
        } catch (Exception e) {
            Log.i(this.LOG_TAG, "error can not show loading");
        }
    }

    public void showProcessingTransactionView(String str) {
        show();
        this.isShow = true;
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(str);
        findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        setCancelable(false);
        this.viewIndex = 0;
    }

    public void showUnSuccessView(String str) {
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(str);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView) findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_fail);
        imageView.setVisibility(0);
        setCancelable(true);
        if (!isShowing()) {
            show();
        }
        this.viewIndex = 1;
        autoClose();
    }

    public void showView(Status status) {
        show();
        this.isShow = true;
        switch (status) {
            case PROCESSING:
                showProcessingView();
                return;
            case SUCCESS:
                showSuccessView();
                return;
            case FAILED:
                showUnSuccessView();
                return;
            case TIMEOUT:
                showTimeOutView();
                return;
            case OTPROCESSING:
            case ATMPROCESSING:
                showATMProcessingView();
                return;
            case ZINGCOINPROCESSING:
                showZingCoinProcessingView();
                return;
            default:
                return;
        }
    }

    public void showViewError(String str) {
        show();
        this.isShow = true;
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(str);
        findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView imageView = (ImageView) findViewById(R.id.zalosdk_status_ctl);
        imageView.setImageResource(R.drawable.zalosdk_ic_fail);
        imageView.setVisibility(0);
        setCancelable(true);
        this.viewIndex = 1;
        autoClose();
    }

    public void updateProcessingTransactionView(String str) {
        ((TextView) findViewById(R.id.zalosdk_message_ctl)).setText(str);
    }
}
