package com.zing.zalo.devicetrackingsdk.event;

import android.database.Cursor;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    private String action;
    private JSONObject params;
    private long timestamp;

    public Event() {
    }

    public Event(String action2, long timestamp2, JSONObject params2) {
        this.action = action2;
        this.timestamp = timestamp2;
        this.params = params2;
    }

    public Event(Cursor cursor) {
        this.timestamp = Long.parseLong(cursor.getString(0));
        this.action = cursor.getString(1);
        try {
            this.params = new JSONObject(cursor.getString(2));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action2) {
        this.action = action2;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp2) {
        this.timestamp = timestamp2;
    }

    public JSONObject getParams() {
        return this.params;
    }

    public void setParams(JSONObject params2) {
        this.params = params2;
    }
}
