package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.Handler;
import android.os.Handler.Callback;
import android.os.HandlerThread;
import android.os.Message;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.devicetrackingsdk.abstracts.IEventTracker;
import com.zing.zalo.devicetrackingsdk.abstracts.IEventTrackerDelegate;
import com.zing.zalo.devicetrackingsdk.event.Event;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientFactory;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONObject;

public class a implements Callback, IEventTracker {
    public static int a = 1000;
    public static long b = 120000;
    public static long c = 60000;
    Context d;
    String e;
    private DeviceTracking f;
    private BaseAppInfoStorage g;
    private com.zing.zalo.devicetrackingsdk.model.a h;
    private int i = 1000;
    private long j = 120000;
    private long k = 60000;
    private long l = 100;
    private HandlerThread m = new HandlerThread("zdt-event-tracker", 1);
    private Handler n;
    private Timer o;
    private Timer p;
    private boolean q;
    private HttpClientFactory r = new HttpClientFactory();
    private IEventTrackerDelegate s;

    public a(Context context, BaseAppInfoStorage storage, com.zing.zalo.devicetrackingsdk.model.a _eventStorage, DeviceTracking deviceTracker, String _appId) {
        this.m.start();
        this.n = new Handler(this.m.getLooper(), this);
        this.d = context;
        this.g = storage;
        this.h = _eventStorage;
        this.f = deviceTracker;
        this.e = _appId;
        Message msg = new Message();
        msg.what = 20484;
        this.n.sendMessage(msg);
        if (this.j > 0) {
            b();
        }
        if (this.k > 0) {
            d();
        }
        Log.v("start zdt-event-tracker thread");
    }

    public void addEvent(String action, Map<String, String> params) {
        Event e2 = a(action, null, System.currentTimeMillis(), params);
        Message msg = new Message();
        msg.what = 20481;
        msg.obj = e2;
        this.n.sendMessage(msg);
    }

    public void setMaxEventsStored(int num) {
        this.i = num;
    }

    public void setDispatchEventsInterval(long ms) {
        if (ms != this.j) {
            if (ms > 0 || this.o == null) {
                if (ms < 10000) {
                    ms = 10000;
                }
                this.j = ms;
                b();
                return;
            }
            a();
        }
    }

    private void a() {
        if (this.o != null) {
            Log.v("cancel dispatch timer");
            this.o.cancel();
            this.o = null;
        }
    }

    private void b() {
        Log.v("schedule dispatch timer");
        a();
        try {
            this.o = new Timer();
            this.o.scheduleAtFixedRate(new TimerTask() {
                public void run() {
                    a.this.dispatchEvents();
                }
            }, this.j, this.j);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setStoreEventsInterval(long ms) {
        if (ms != this.k) {
            synchronized (this) {
                if (ms <= 0) {
                    c();
                    return;
                }
                if (ms < 10000) {
                    ms = 10000;
                }
                this.k = ms;
                d();
            }
        }
    }

    private synchronized void c() {
        if (this.p != null) {
            Log.v("cancel store events timer");
            this.p.cancel();
            this.p = null;
        }
    }

    private void d() {
        Log.v("schedule store events timer");
        c();
        try {
            this.p = new Timer();
            this.p.scheduleAtFixedRate(new TimerTask() {
                public void run() {
                    a.this.storeEvents();
                }
            }, this.k, this.k);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dispatchEvents() {
        try {
            Message msg = new Message();
            msg.what = 20480;
            this.n.sendMessage(msg);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void storeEvents() {
        try {
            synchronized (this) {
                Message msg = new Message();
                msg.what = 20482;
                this.n.sendMessage(msg);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setEventTrackerDelegate(IEventTrackerDelegate delegate) {
        this.s = delegate;
    }

    private Event a(String action, String name, long timestamp, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<>();
        }
        if (name != null && !params.containsKey("name")) {
            params.put("name", name);
        }
        return new Event(action, timestamp, Utils.mapToJSONObject(params));
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 20480:
                this.f.getDeviceId(new GetInfoListener() {
                    public void onGetDeviceIdComplete(String deviceId) {
                        a.this.a(deviceId);
                    }
                });
                break;
            case 20481:
                a((Event) msg.obj);
                break;
            case 20482:
                e();
                break;
            case 20484:
                g();
                break;
            default:
                return false;
        }
        return true;
    }

    public void a(String deviceId) {
        try {
            if ((this.h == null || this.h.b().size() != 0) && this.q) {
                JSONArray appData = new JSONArray();
                JSONObject eventData = h();
                String zdId = deviceId;
                String sdkId = this.f.getSDKId();
                String privateKey = this.f.getPrivateKey();
                if (zdId == null) {
                    zdId = "";
                }
                if (sdkId == null) {
                    String sdkId2 = "";
                }
                String an = AppInfo.getAppName(this.d);
                String av = AppInfo.getVersionName(this.d);
                String appId = this.e;
                String oauthCode = this.g.getOAuthCode();
                if (oauthCode == null) {
                    oauthCode = "";
                }
                String ts = "" + new Date().getTime();
                String strEventData = eventData.toString();
                String strAppData = appData.toString();
                String strSocialAcc = "[]";
                String[] params = {"pl", "appId", "oauthCode", "data", "apps", "ts", "zdId", "an", "av", "et", "gzip", "socialAcc", "packageName"};
                String[] values = {"android", appId, oauthCode, strEventData, strAppData, ts, zdId, an, av, "0", "0", strSocialAcc, this.d.getPackageName()};
                String url = ServiceMapManager.getInstance().urlFor("centralized_http_s", "/apps/mobile/android") + "?packageName=" + this.d.getPackageName();
                HttpClientRequest request = this.r.newRequest(Type.POST, url);
                String sig = Utils.getSignature(params, values, "@#centralize#@");
                request.addParams("pl", "android");
                request.addParams("appId", appId);
                request.addParams("oauthCode", oauthCode);
                request.addParams("zdId", zdId);
                request.addParams("data", strEventData);
                request.addParams("apps", strAppData);
                request.addParams("ts", ts);
                request.addParams("sig", sig);
                request.addParams("an", an);
                request.addParams("av", av);
                request.addParams("gzip", "0");
                request.addParams("et", "0");
                request.addParams("socialAcc", strSocialAcc);
                request.addParams("packageName", this.d.getPackageName());
                JSONObject jsonObject = request.getJSON();
                if (request.liveResponseCode >= 400 && request.liveResponseCode <= 599) {
                    this.h.c();
                } else if (jsonObject == null) {
                } else {
                    if (jsonObject.getInt("error") == 0) {
                        this.h.c();
                    }
                }
            }
        } catch (Exception e2) {
            e2.printStackTrace();
            this.h.c();
        }
    }

    private void e() {
        if (this.q) {
            this.h.d();
        }
    }

    private void a(Event e2) {
        if (this.q) {
            if (this.s != null) {
                this.s.onPushEvent(e2);
            }
            this.h.a(e2);
            f();
            List<Event> events = this.h.b();
            if (events != null && ((long) events.size()) >= this.l) {
                new Thread(new Runnable() {
                    public void run() {
                        a.this.dispatchEvents();
                    }
                }).start();
            }
        }
    }

    private void f() {
        if (this.q) {
            List<Event> events = this.h.b();
            if (events.size() > this.i) {
                Log.v("ZDK", "exceed max number of events %d > %d", new Object[]{Integer.valueOf(events.size()), Integer.valueOf(this.i)});
                Event[] removeEvents = (Event[]) events.subList(0, events.size() - this.i).toArray(new Event[0]);
                for (Event e2 : removeEvents) {
                    this.h.b(e2);
                }
            }
        }
    }

    private void g() {
        this.h.a();
        this.q = true;
    }

    private JSONObject h() {
        JSONObject data = new JSONObject();
        JSONObject deviceInfoData = this.f.prepareTrackingData();
        JSONArray jsonEvents = new JSONArray();
        try {
            for (Event e2 : this.h.b()) {
                if (this.s != null) {
                    this.s.onDispatchEvent(e2);
                }
                JSONObject jsonEvent = new JSONObject();
                JSONObject extras = e2.getParams();
                if (extras.has("name")) {
                    jsonEvent.put("name", extras.get("name"));
                }
                jsonEvent.put("extras", extras);
                jsonEvent.put("act", e2.getAction());
                jsonEvent.put("ts", e2.getTimestamp());
                jsonEvents.put(jsonEvent);
            }
            data.put("evt", jsonEvents);
            data.put("dat", deviceInfoData);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return data;
    }
}
