package com.zing.zalo.devicetrackingsdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.devicetrackingsdk.model.PreloadInfo;
import com.zing.zalo.zalosdk.analytics.internal.e;
import com.zing.zalo.zalosdk.analytics.internal.f;
import com.zing.zalo.zalosdk.analytics.internal.g;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.exception.InitializedException;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper.PreloadReadListener;
import com.zing.zalo.zalosdk.core.helper.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZingAnalyticsManager {
    private static ZingAnalyticsManager a = new ZingAnalyticsManager();
    private boolean b;
    private BaseAppInfoStorage c = null;
    private com.zing.zalo.devicetrackingsdk.model.a d;
    private com.zing.zalo.zalosdk.analytics.internal.a e;
    private Application f;
    private AppTracker g;
    private DeviceTracking h;
    private boolean i = true;
    private List<a> j = new ArrayList();
    private boolean k;

    private class a {
        String a;
        Map<String, String> b;
        final /* synthetic */ ZingAnalyticsManager c;

        a(ZingAnalyticsManager zingAnalyticsManager, String action, Map<String, String> params) {
            this.c = zingAnalyticsManager;
            this.a = action;
            this.b = params;
        }
    }

    public static ZingAnalyticsManager getInstance() {
        return a;
    }

    private ZingAnalyticsManager() {
    }

    public ZingAnalyticsManager init(Application app) {
        String appId = AppInfo.getAppId(app);
        if (appId == null) {
            appId = "";
        }
        return init(app, appId);
    }

    public ZingAnalyticsManager init(Application app, String appId) {
        synchronized (this) {
            if (this.b) {
            } else {
                this.f = app;
                final Context context = app.getApplicationContext();
                this.c = new BaseAppInfoStorage(context);
                this.d = new com.zing.zalo.devicetrackingsdk.model.a(context);
                boolean isEnableCrashTracking = AppInfo.isCrashTrackingEnabled(app.getApplicationContext());
                this.i = AppInfo.isAutoTrackingOpenApp(app.getApplicationContext());
                e.a.b = this.i;
                e.a.a(app);
                if (isEnableCrashTracking) {
                    f.a.a(app);
                }
                this.h = DeviceTracking.getInstance();
                this.h.initDeviceTracking(app.getApplicationContext(), this.c, appId);
                this.e = new a(context, this.c, this.d, DeviceTracking.getInstance(), appId);
                this.e.a(a.a);
                this.e.a(a.b);
                this.e.b(a.c);
                this.g = new AppTracker(context, this.c, appId, DeviceTracking.getInstance());
                DeviceTracking.getInstance().getDeviceId(new GetInfoListener(this) {
                    final /* synthetic */ ZingAnalyticsManager b;

                    public void onGetDeviceIdComplete(String deviceId) {
                        SettingsManager.getInstance().init(context, deviceId);
                    }
                });
                for (a event : this.j) {
                    if (event.b == null) {
                        event.b = new HashMap();
                    }
                    a(event.b);
                    this.e.a(event.a, event.b);
                }
                if (this.k) {
                    this.e.a();
                }
                this.b = true;
            }
        }
        return this;
    }

    public void finalize() {
        a = null;
    }

    private void a() {
        if (!this.b) {
            throw new InitializedException("Missing call ZingAnalyticsManager.getInstance().init() in Application.onCreate()");
        }
    }

    public String getDeviceId() {
        return DeviceTracking.getInstance().getDeviceId();
    }

    public void getDeviceId(GetInfoListener getDeviceIdListener) {
        DeviceTracking.getInstance().getDeviceId(getDeviceIdListener);
    }

    public void sendOpenView(String viewName) {
        long startTime = System.currentTimeMillis();
        Map<String, String> params = new HashMap();
        params.put("name", viewName);
        params.put("ts", String.valueOf(startTime));
        addEvent("start_screen", params);
    }

    public void addException(String name, String message, String reason, String stacktrace) {
        Map<String, String> params = new HashMap();
        params.put("name", name);
        params.put("message", message);
        params.put("reason", reason);
        params.put("stack_trace", stacktrace);
        params.put("app_exception", "true");
        addEvent("crash_log", params);
    }

    public void addEvent(String action, String category, String label, long value) {
        Map<String, String> params = new HashMap();
        params.put("category", category);
        params.put("label", label);
        params.put("value", "" + value);
        addEvent(action, params);
    }

    public void onResume(Activity activity) {
        if (Utils.belowSandwich()) {
            g.b(this.f).a(activity);
        }
    }

    public void onPause(Activity activity) {
        if (Utils.belowSandwich()) {
            g.b(this.f).b(activity);
        }
    }

    public void addEvent(String action, Map<String, String> params) {
        synchronized (this) {
            if (this.b) {
                if (params == null) {
                    params = new HashMap();
                }
                a(params);
                this.e.a(action, params);
            } else {
                this.j.add(new a(this, action, params));
            }
        }
    }

    private void a(Map<String, String> params) {
        try {
            Map<String, String> _params = new HashMap();
            PreloadInfo preloadInfo = DeviceHelper.getPreloadInfo(this.f.getApplicationContext());
            if (preloadInfo != null) {
                _params.put("preloadDefault", AppInfo.getPreloadChannel(this.f.getApplicationContext()));
                _params.put("preload", preloadInfo.preload);
                if (!preloadInfo.isPreloaded()) {
                    _params.put("preloadFailed", preloadInfo.error);
                }
            }
            _params.put("wakeupInfo", Utils.loadListDeviceIDWakeUp(this.f.getApplicationContext()));
            params.putAll(_params);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMaxEventsStored(int num) {
        if (this.b) {
            this.e.a(num);
        } else {
            a.a = num;
        }
    }

    public void setDispatchEventsInterval(long ms) {
        if (this.b) {
            this.e.a(ms);
        } else {
            a.b = ms;
        }
    }

    public void setStoreEventsInterval(long ms) {
        if (this.b) {
            this.e.b(ms);
        } else {
            a.c = ms;
        }
    }

    public void dispatchEvents() {
        if (this.b) {
            this.e.a();
        } else {
            this.k = true;
        }
    }

    public void storeEvents() {
        a();
        this.e.b();
    }

    public BaseAppInfoStorage getStorage() {
        a();
        return this.c;
    }

    public boolean getAutoActivityTracking() {
        return this.i;
    }

    public boolean isPreload(Context context) {
        PreloadInfo preloadInfo = DeviceHelper.getPreloadInfo(context);
        return preloadInfo != null && preloadInfo.isPreloaded();
    }

    public void isPreload(Context context, PreloadReadListener preloadReadListener) {
        DeviceHelper.getPreloadInfo(context, preloadReadListener);
    }
}
