package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.Handler;
import android.os.Handler.Callback;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.analytics.internal.b;
import com.zing.zalo.zalosdk.common.UtilsCore;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONObject;

public class a implements Callback, com.zing.zalo.zalosdk.analytics.internal.a {
    public static int a = 1000;
    public static long b = 120000;
    public static long c = 60000;
    Context d;
    String e;
    private DeviceTracking f;
    private BaseAppInfoStorage g;
    private com.zing.zalo.devicetrackingsdk.model.a h;
    private int i = 1000;
    private long j = 120000;
    private long k = 60000;
    private long l = 100;
    private HandlerThread m = new HandlerThread("zdt-event-tracker", 1);
    private Handler n;
    private Timer o;
    private Timer p;
    private boolean q;

    public a(Context context, BaseAppInfoStorage storage, com.zing.zalo.devicetrackingsdk.model.a _eventStorage, DeviceTracking deviceTracker, String _appId) {
        this.m.start();
        this.n = new Handler(this.m.getLooper(), this);
        this.d = context;
        this.g = storage;
        this.h = _eventStorage;
        this.f = deviceTracker;
        this.e = _appId;
        Message msg = new Message();
        msg.what = 20484;
        this.n.sendMessage(msg);
        if (this.j > 0) {
            d();
        }
        if (this.k > 0) {
            f();
        }
        Log.v("start zdt-event-tracker thread");
    }

    public void a(String action, Map<String, String> params) {
        b e = a(action, null, System.currentTimeMillis(), params);
        Message msg = new Message();
        msg.what = 20481;
        msg.obj = e;
        this.n.sendMessage(msg);
    }

    public void a(int num) {
        this.i = num;
    }

    public void a(long ms) {
        if (ms > 0 || this.o == null) {
            if (ms < 10000) {
                ms = 10000;
            }
            this.j = ms;
            d();
            return;
        }
        c();
    }

    private void c() {
        if (this.o != null) {
            Log.v("cancel dispatch timer");
            this.o.cancel();
            this.o = null;
        }
    }

    private void d() {
        Log.v("schedule dispatch timer");
        c();
        try {
            this.o = new Timer();
            this.o.scheduleAtFixedRate(new TimerTask(this) {
                final /* synthetic */ a a;

                {
                    this.a = this$0;
                }

                public void run() {
                    this.a.a();
                }
            }, this.j, this.j);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void b(long ms) {
        synchronized (this) {
            if (ms <= 0) {
                e();
                return;
            }
            if (ms < 10000) {
                ms = 10000;
            }
            this.k = ms;
            f();
        }
    }

    private synchronized void e() {
        if (this.p != null) {
            Log.v("cancel store events timer");
            this.p.cancel();
            this.p = null;
        }
    }

    private void f() {
        Log.v("schedule store events timer");
        e();
        try {
            this.p = new Timer();
            this.p.scheduleAtFixedRate(new TimerTask(this) {
                final /* synthetic */ a a;

                {
                    this.a = this$0;
                }

                public void run() {
                    this.a.b();
                }
            }, this.k, this.k);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void a() {
        try {
            Message msg = new Message();
            msg.what = 20480;
            this.n.sendMessage(msg);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void b() {
        try {
            synchronized (this) {
                Message msg = new Message();
                msg.what = 20482;
                this.n.sendMessage(msg);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private b a(String action, String name, long timestamp, Map<String, String> params) {
        if (params == null) {
            params = new HashMap();
        }
        if (!(name == null || params.containsKey("name"))) {
            params.put("name", name);
        }
        return new b(action, timestamp, Utils.mapToJSONObject(params));
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 20480:
                this.f.getDeviceId(new GetInfoListener(this) {
                    final /* synthetic */ a a;

                    {
                        this.a = this$0;
                    }

                    public void onGetDeviceIdComplete(String deviceId) {
                        this.a.a(deviceId);
                    }
                });
                break;
            case 20481:
                a((b) msg.obj);
                break;
            case 20482:
                g();
                break;
            case 20484:
                i();
                break;
            default:
                return false;
        }
        return true;
    }

    public void a(String deviceId) {
        try {
            if ((this.h == null || this.h.b().size() != 0) && this.q) {
                JSONObject jsonObject;
                JSONArray appData = new JSONArray();
                Log.logUpdateText("doDispatchEvent: deviceID: " + deviceId);
                JSONObject eventData = j();
                String zdId = deviceId;
                String sdkId = this.f.getSDKId();
                String privateKey = this.f.getPrivateKey();
                if (zdId == null) {
                    zdId = "";
                }
                if (sdkId == null) {
                    sdkId = "";
                }
                String et = TextUtils.isEmpty(sdkId) ? "0" : "1";
                String an = AppInfo.getAppName(this.d);
                String av = AppInfo.getVersionName(this.d);
                String appId = this.e;
                String oauthCode = this.g.getOAuthCode();
                if (oauthCode == null) {
                    oauthCode = "";
                }
                String ts = "" + new Date().getTime();
                String strEventData = eventData.toString();
                Log.logUpdateText("doDispatchEvent: strEventData: " + strEventData);
                String strAppData = appData.toString();
                String strSocialAcc = "[]";
                Log.logUpdateText("doDispatchEvent: packageName: " + this.d.getPackageName());
                String[] params = new String[]{"pl", "appId", "oauthCode", "data", "apps", "ts", "zdId", "an", "av", "et", "gzip", "socialAcc", "packageName"};
                String[] values = new String[]{"android", appId, oauthCode, strEventData, strAppData, ts, zdId, an, av, et, "0", strSocialAcc, packageName};
                String url = (Constant.getTrackingApiBaseUrl() + Constant.getTrackingApiUri()) + "?packageName=" + this.d.getPackageName();
                HttpClientRequest httpClientRequest = new HttpClientRequest(Type.POST, url);
                if (et.equals("0")) {
                    String sig = Utils.getSignature(Constant.getTrackingApiBaseUrl(), Constant.getTrackingApiUri(), params, values, "@#centralize#@");
                    httpClientRequest.addParams("pl", "android");
                    httpClientRequest.addParams("appId", appId);
                    httpClientRequest.addParams("oauthCode", oauthCode);
                    httpClientRequest.addParams("zdId", zdId);
                    httpClientRequest.addParams("data", strEventData);
                    httpClientRequest.addParams("apps", strAppData);
                    httpClientRequest.addParams("ts", ts);
                    httpClientRequest.addParams("sig", sig);
                    httpClientRequest.addParams("an", an);
                    httpClientRequest.addParams("av", av);
                    httpClientRequest.addParams("gzip", "0");
                    httpClientRequest.addParams("et", "0");
                    httpClientRequest.addParams("socialAcc", strSocialAcc);
                    httpClientRequest.addParams("packageName", this.d.getPackageName());
                    jsonObject = httpClientRequest.getJSON();
                } else {
                    JSONObject jsonData = new JSONObject();
                    jsonData.put("pl", "android");
                    jsonData.put("appId", appId);
                    jsonData.put("oauthCode", oauthCode);
                    jsonData.put("zdId", zdId);
                    jsonData.put("data", strEventData);
                    jsonData.put("apps", strAppData);
                    jsonData.put("an", an);
                    jsonData.put("av", av);
                    jsonData.put("socialAcc", strSocialAcc);
                    jsonData.put("packageName", this.d.getPackageName());
                    JSONObject jSONObject = new JSONObject(UtilsCore.postFile(url + "&et=1&sdkId=" + sdkId + "&gzip=0", "data.dat", "zce", UtilsCore.encrypt(privateKey, jsonData.toString()), null));
                }
                if (httpClientRequest.liveResponseCode >= 400 && httpClientRequest.liveResponseCode <= 599) {
                    this.h.c();
                } else if (jsonObject != null) {
                    try {
                        Log.logUpdateText("doDispatchEvent: result: " + jsonObject.toString());
                    } catch (Exception e) {
                    }
                    if (jsonObject.getInt("error") == 0) {
                        this.h.c();
                    }
                }
            }
        } catch (Exception e2) {
            Log.logUpdateText("doDispatchEvent: Exception: " + e2.getMessage());
            e2.printStackTrace();
            this.h.c();
        }
    }

    private void g() {
        if (this.q) {
            this.h.d();
        }
    }

    private void a(b e) {
        if (this.q) {
            this.h.a(e);
            h();
            List<b> events = this.h.b();
            if (events != null && ((long) events.size()) >= this.l) {
                new Thread(new Runnable(this) {
                    final /* synthetic */ a a;

                    {
                        this.a = this$0;
                    }

                    public void run() {
                        this.a.a();
                    }
                }).start();
            }
        }
    }

    private void h() {
        if (this.q) {
            List<b> events = this.h.b();
            if (events.size() > this.i) {
                Log.v("ZDK", "exceed max number of events %d > %d", new Object[]{Integer.valueOf(events.size()), Integer.valueOf(this.i)});
                b[] removeEvents = (b[]) events.subList(0, events.size() - this.i).toArray(new b[0]);
                for (b e : removeEvents) {
                    this.h.b(e);
                }
            }
        }
    }

    private void i() {
        this.h.a();
        this.q = true;
    }

    private JSONObject j() {
        JSONObject data = new JSONObject();
        JSONObject deviceInfoData = this.f.prepareTrackingData();
        JSONArray jsonEvents = new JSONArray();
        try {
            for (b e : this.h.b()) {
                JSONObject jsonEvent = new JSONObject();
                JSONObject extras = e.c();
                if (extras.has("name")) {
                    jsonEvent.put("name", extras.get("name"));
                }
                jsonEvent.put("extras", extras);
                jsonEvent.put("act", e.a());
                jsonEvent.put("ts", e.b());
                jsonEvents.put(jsonEvent);
            }
            data.put("evt", jsonEvents);
            data.put("dat", deviceInfoData);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return data;
    }
}
