package com.zing.zalo.zalosdk.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.log.Log;

public class ReferrerReceiver extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String referrerString = intent.getExtras().getString("referrer");
        if (!TextUtils.isEmpty(referrerString)) {
            context.getSharedPreferences("zacCookie", 0).edit().putString("referrer", referrerString).commit();
            Log.w("ReferrerReceiver", "Referrer is: " + referrerString);
        }
    }
}
