/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.callback;

import com.zhy.http.okhttp.OkHttpUtils;
import com.zhy.http.okhttp.callback.Callback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public abstract class FileCallBack
extends Callback<File> {
    private String destFileDir;
    private String destFileName;

    public FileCallBack(String destFileDir, String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    @Override
    public File parseNetworkResponse(Response response, int id) throws Exception {
        return this.saveFile(response, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveFile(Response response, final int id) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[2048];
        int len = 0;
        FileOutputStream fos = null;
        try {
            is = response.body().byteStream();
            final long total = response.body().contentLength();
            long sum = 0L;
            File dir = new File(this.destFileDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, this.destFileName);
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
                final long finalSum = sum += (long)len;
                OkHttpUtils.getInstance().getDelivery().execute(new Runnable(){

                    @Override
                    public void run() {
                        FileCallBack.this.inProgress((float)finalSum * 1.0f / (float)total, total, id);
                    }
                });
            }
            fos.flush();
            File file2 = file;
            return file2;
        }
        finally {
            try {
                response.body().close();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

