/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.adapter.recyclerview.wrapper;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.zhy.adapter.recyclerview.base.ViewHolder;
import com.zhy.adapter.recyclerview.utils.WrapperUtils;

public class LoadMoreWrapper<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int ITEM_TYPE_LOAD_MORE = 0x7FFFFFFD;
    private RecyclerView.Adapter mInnerAdapter;
    private View mLoadMoreView;
    private int mLoadMoreLayoutId;
    private OnLoadMoreListener mOnLoadMoreListener;

    public LoadMoreWrapper(RecyclerView.Adapter adapter) {
        this.mInnerAdapter = adapter;
    }

    private boolean hasLoadMore() {
        return this.mLoadMoreView != null || this.mLoadMoreLayoutId != 0;
    }

    private boolean isShowLoadMore(int position) {
        return this.hasLoadMore() && position >= this.mInnerAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        if (this.isShowLoadMore(position)) {
            return 0x7FFFFFFD;
        }
        return this.mInnerAdapter.getItemViewType(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0x7FFFFFFD) {
            ViewHolder holder = this.mLoadMoreView != null ? ViewHolder.createViewHolder(parent.getContext(), this.mLoadMoreView) : ViewHolder.createViewHolder(parent.getContext(), parent, this.mLoadMoreLayoutId);
            return holder;
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isShowLoadMore(position)) {
            if (this.mOnLoadMoreListener != null) {
                this.mOnLoadMoreListener.onLoadMoreRequested();
            }
            return;
        }
        this.mInnerAdapter.onBindViewHolder(holder, position);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        WrapperUtils.onAttachedToRecyclerView(this.mInnerAdapter, recyclerView, new WrapperUtils.SpanSizeCallback(){

            @Override
            public int getSpanSize(GridLayoutManager layoutManager, GridLayoutManager.SpanSizeLookup oldLookup, int position) {
                if (LoadMoreWrapper.this.isShowLoadMore(position)) {
                    return layoutManager.getSpanCount();
                }
                if (oldLookup != null) {
                    return oldLookup.getSpanSize(position);
                }
                return 1;
            }
        });
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewAttachedToWindow(holder);
        if (this.isShowLoadMore(holder.getLayoutPosition())) {
            this.setFullSpan(holder);
        }
    }

    private void setFullSpan(RecyclerView.ViewHolder holder) {
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
    }

    public int getItemCount() {
        return this.mInnerAdapter.getItemCount() + (this.hasLoadMore() ? 1 : 0);
    }

    public LoadMoreWrapper setOnLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        if (loadMoreListener != null) {
            this.mOnLoadMoreListener = loadMoreListener;
        }
        return this;
    }

    public LoadMoreWrapper setLoadMoreView(View loadMoreView) {
        this.mLoadMoreView = loadMoreView;
        return this;
    }

    public LoadMoreWrapper setLoadMoreView(int layoutId) {
        this.mLoadMoreLayoutId = layoutId;
        return this;
    }

    public static interface OnLoadMoreListener {
        public void onLoadMoreRequested();
    }
}

