/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.adapter.recyclerview.wrapper;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.zhy.adapter.recyclerview.base.ViewHolder;
import com.zhy.adapter.recyclerview.utils.WrapperUtils;

public class EmptyWrapper<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int ITEM_TYPE_EMPTY = 0x7FFFFFFE;
    private RecyclerView.Adapter mInnerAdapter;
    private View mEmptyView;
    private int mEmptyLayoutId;

    public EmptyWrapper(RecyclerView.Adapter adapter) {
        this.mInnerAdapter = adapter;
    }

    private boolean isEmpty() {
        return (this.mEmptyView != null || this.mEmptyLayoutId != 0) && this.mInnerAdapter.getItemCount() == 0;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.isEmpty()) {
            ViewHolder holder = this.mEmptyView != null ? ViewHolder.createViewHolder(parent.getContext(), this.mEmptyView) : ViewHolder.createViewHolder(parent.getContext(), parent, this.mEmptyLayoutId);
            return holder;
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        WrapperUtils.onAttachedToRecyclerView(this.mInnerAdapter, recyclerView, new WrapperUtils.SpanSizeCallback(){

            @Override
            public int getSpanSize(GridLayoutManager gridLayoutManager, GridLayoutManager.SpanSizeLookup oldLookup, int position) {
                if (EmptyWrapper.this.isEmpty()) {
                    return gridLayoutManager.getSpanCount();
                }
                if (oldLookup != null) {
                    return oldLookup.getSpanSize(position);
                }
                return 1;
            }
        });
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewAttachedToWindow(holder);
        if (this.isEmpty()) {
            WrapperUtils.setFullSpan(holder);
        }
    }

    public int getItemViewType(int position) {
        if (this.isEmpty()) {
            return 0x7FFFFFFE;
        }
        return this.mInnerAdapter.getItemViewType(position);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isEmpty()) {
            return;
        }
        this.mInnerAdapter.onBindViewHolder(holder, position);
    }

    public int getItemCount() {
        if (this.isEmpty()) {
            return 1;
        }
        return this.mInnerAdapter.getItemCount();
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void setEmptyView(int layoutId) {
        this.mEmptyLayoutId = layoutId;
    }
}

