/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.adapter.abslistview.base;

import android.support.v4.util.SparseArrayCompat;
import com.zhy.adapter.abslistview.ViewHolder;
import com.zhy.adapter.abslistview.base.ItemViewDelegate;

public class ItemViewDelegateManager<T> {
    SparseArrayCompat<ItemViewDelegate<T>> delegates = new SparseArrayCompat();

    public int getItemViewDelegateCount() {
        return this.delegates.size();
    }

    public ItemViewDelegateManager<T> addDelegate(ItemViewDelegate<T> delegate) {
        int viewType = this.delegates.size();
        if (delegate != null) {
            this.delegates.put(viewType, delegate);
            ++viewType;
        }
        return this;
    }

    public ItemViewDelegateManager<T> addDelegate(int viewType, ItemViewDelegate<T> delegate) {
        if (this.delegates.get(viewType) != null) {
            throw new IllegalArgumentException("An ItemViewDelegate is already registered for the viewType = " + viewType + ". Already registered ItemViewDelegate is " + this.delegates.get(viewType));
        }
        this.delegates.put(viewType, delegate);
        return this;
    }

    public ItemViewDelegateManager<T> removeDelegate(ItemViewDelegate<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("ItemViewDelegate is null");
        }
        int indexToRemove = this.delegates.indexOfValue(delegate);
        if (indexToRemove >= 0) {
            this.delegates.removeAt(indexToRemove);
        }
        return this;
    }

    public ItemViewDelegateManager<T> removeDelegate(int itemType) {
        int indexToRemove = this.delegates.indexOfKey(itemType);
        if (indexToRemove >= 0) {
            this.delegates.removeAt(indexToRemove);
        }
        return this;
    }

    public int getItemViewType(T item, int position) {
        int delegatesCount = this.delegates.size();
        for (int i = delegatesCount - 1; i >= 0; --i) {
            ItemViewDelegate delegate = (ItemViewDelegate)this.delegates.valueAt(i);
            if (!delegate.isForViewType(item, position)) continue;
            return this.delegates.keyAt(i);
        }
        throw new IllegalArgumentException("No ItemViewDelegate added that matches position=" + position + " in data source");
    }

    public void convert(ViewHolder holder, T item, int position) {
        int delegatesCount = this.delegates.size();
        for (int i = 0; i < delegatesCount; ++i) {
            ItemViewDelegate delegate = (ItemViewDelegate)this.delegates.valueAt(i);
            if (!delegate.isForViewType(item, position)) continue;
            delegate.convert(holder, item, position);
            return;
        }
        throw new IllegalArgumentException("No ItemViewDelegateManager added that matches position=" + position + " in data source");
    }

    public int getItemViewLayoutId(int viewType) {
        return ((ItemViewDelegate)this.delegates.get(viewType)).getItemViewLayoutId();
    }

    public int getItemViewType(ItemViewDelegate itemViewDelegate) {
        return this.delegates.indexOfValue((Object)itemViewDelegate);
    }

    public ItemViewDelegate getItemViewDelegate(T item, int position) {
        int delegatesCount = this.delegates.size();
        for (int i = delegatesCount - 1; i >= 0; --i) {
            ItemViewDelegate delegate = (ItemViewDelegate)this.delegates.valueAt(i);
            if (!delegate.isForViewType(item, position)) continue;
            return delegate;
        }
        throw new IllegalArgumentException("No ItemViewDelegate added that matches position=" + position + " in data source");
    }

    public int getItemViewLayoutId(T item, int position) {
        return this.getItemViewDelegate(item, position).getItemViewLayoutId();
    }
}

