/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.base.adapter.abslistview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zhy.base.adapter.ViewHolder;
import java.util.List;

public abstract class CommonAdapter<T>
extends BaseAdapter {
    protected Context mContext;
    protected List<T> mDatas;
    protected LayoutInflater mInflater;
    private int layoutId;

    public CommonAdapter(Context context, int layoutId, List<T> datas) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mDatas = datas;
        this.layoutId = layoutId;
    }

    public int getCount() {
        return this.mDatas.size();
    }

    public T getItem(int position) {
        return this.mDatas.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    protected void onConvertViewCreated(View convertView) {
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            View itemView = LayoutInflater.from((Context)this.mContext).inflate(this.layoutId, parent, false);
            this.onConvertViewCreated(itemView);
            holder = new ViewHolder(this.mContext, itemView, parent, position);
            holder.setLayoutId(this.layoutId);
        } else {
            holder = (ViewHolder)((Object)convertView.getTag());
            holder.updatePosition(position);
        }
        this.convert(holder, this.getItem(position));
        return holder.getConvertView();
    }

    public abstract void convert(ViewHolder var1, T var2);
}

