/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.base.adapter.recyclerview;

import android.content.Context;
import android.view.ViewGroup;
import com.zhy.base.adapter.ViewHolder;
import com.zhy.base.adapter.recyclerview.CommonAdapter;
import com.zhy.base.adapter.recyclerview.MultiItemTypeSupport;
import java.util.List;

public abstract class MultiItemCommonAdapter<T>
extends CommonAdapter<T> {
    protected MultiItemTypeSupport<T> mMultiItemTypeSupport;

    public MultiItemCommonAdapter(Context context, List<T> datas, MultiItemTypeSupport<T> multiItemTypeSupport) {
        super(context, -1, datas);
        this.mMultiItemTypeSupport = multiItemTypeSupport;
        if (this.mMultiItemTypeSupport == null) {
            throw new IllegalArgumentException("the mMultiItemTypeSupport can not be null.");
        }
    }

    public int getItemViewType(int position) {
        if (this.mMultiItemTypeSupport != null) {
            return this.mMultiItemTypeSupport.getItemViewType(position, this.mDatas.get(position));
        }
        return super.getItemViewType(position);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mMultiItemTypeSupport == null) {
            return super.onCreateViewHolder(parent, viewType);
        }
        int layoutId = this.mMultiItemTypeSupport.getLayoutId(viewType);
        ViewHolder holder = ViewHolder.get(this.mContext, null, parent, layoutId, -1);
        this.setListener(parent, holder, viewType);
        return holder;
    }
}

