/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.base.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zhy.base.adapter.ViewHolder;
import com.zhy.base.adapter.recyclerview.OnItemClickListener;
import java.util.List;

public abstract class CommonAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected Context mContext;
    protected int mLayoutId;
    protected List<T> mDatas;
    protected LayoutInflater mInflater;
    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public CommonAdapter(Context context, int layoutId, List<T> datas) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = layoutId;
        this.mDatas = datas;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolder viewHolder = ViewHolder.get(this.mContext, null, parent, this.mLayoutId, -1);
        this.setListener(parent, viewHolder, viewType);
        return viewHolder;
    }

    protected int getPosition(RecyclerView.ViewHolder viewHolder) {
        return viewHolder.getAdapterPosition();
    }

    protected boolean isEnabled(int viewType) {
        return true;
    }

    protected void setListener(final ViewGroup parent, final ViewHolder viewHolder, int viewType) {
        if (!this.isEnabled(viewType)) {
            return;
        }
        viewHolder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonAdapter.this.mOnItemClickListener != null) {
                    int position = CommonAdapter.this.getPosition(viewHolder);
                    CommonAdapter.this.mOnItemClickListener.onItemClick(parent, v, CommonAdapter.this.mDatas.get(position), position);
                }
            }
        });
        viewHolder.getConvertView().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (CommonAdapter.this.mOnItemClickListener != null) {
                    int position = CommonAdapter.this.getPosition(viewHolder);
                    return CommonAdapter.this.mOnItemClickListener.onItemLongClick(parent, v, CommonAdapter.this.mDatas.get(position), position);
                }
                return false;
            }
        });
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.updatePosition(position);
        this.convert(holder, this.mDatas.get(position));
    }

    public abstract void convert(ViewHolder var1, T var2);

    public int getItemCount() {
        return this.mDatas.size();
    }
}

